/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import java.util.HashMap;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.HandleFactory;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyResolver;
import org.eclipse.jdt.internal.core.search.HierarchyScope;
import org.eclipse.jdt.internal.core.search.matching.JavaSearchNameEnvironment;
import org.eclipse.jdt.internal.core.search.matching.MatchLocatorParser;
import org.eclipse.jdt.internal.core.search.matching.MatchSet;
import org.eclipse.jdt.internal.core.search.matching.MatchingOpenable;
import org.eclipse.jdt.internal.core.search.matching.MatchingOpenableSet;
import org.eclipse.jdt.internal.core.search.matching.OrPattern;
import org.eclipse.jdt.internal.core.search.matching.PackageDeclarationPattern;
import org.eclipse.jdt.internal.core.search.matching.SearchPattern;

public class MatchLocator
implements ITypeRequestor {
    public SearchPattern pattern;
    public int detailLevel;
    public IJavaSearchResultCollector collector;
    public IJavaSearchScope scope;
    public MatchLocatorParser parser;
    public INameEnvironment nameEnvironment;
    public NameLookup nameLookup;
    public LookupEnvironment lookupEnvironment;
    public HashtableOfObject parsedUnits;
    public MatchingOpenableSet matchingOpenables;
    private MatchingOpenable currentMatchingOpenable;
    public HandleFactory handleFactory;
    public IWorkingCopy[] workingCopies;
    public HierarchyResolver hierarchyResolver;
    public IProgressMonitor progressMonitor;
    static final char[] EMPTY_FILE_NAME = CharOperation.NO_CHAR;
    boolean compilationAborted;

    public MatchLocator(SearchPattern pattern, int detailLevel, IJavaSearchResultCollector collector, IJavaSearchScope scope, IProgressMonitor progressMonitor) {
        this.pattern = pattern;
        this.detailLevel = detailLevel;
        this.collector = collector;
        this.scope = scope;
        this.progressMonitor = progressMonitor;
    }

    public void accept(IBinaryType binaryType, PackageBinding packageBinding) {
        BinaryTypeBinding binaryBinding = new BinaryTypeBinding(packageBinding, binaryType, this.lookupEnvironment);
        ReferenceBinding cachedType = this.lookupEnvironment.getCachedType(binaryBinding.compoundName);
        if (cachedType == null || cachedType instanceof UnresolvedReferenceBinding) {
            this.lookupEnvironment.createBinaryTypeFrom(binaryType, packageBinding);
        }
    }

    public void accept(ICompilationUnit sourceUnit) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(new String(sourceUnit.getFileName())));
        CompilationUnit compilationUnit = (CompilationUnit)JavaCore.create(file);
        CompilationUnitDeclaration parsedUnit = this.parser.dietParse(sourceUnit, this, file, compilationUnit);
        this.lookupEnvironment.buildTypeBindings(parsedUnit);
        this.lookupEnvironment.completeTypeBindings(parsedUnit, true);
        ImportReference pkg = parsedUnit.currentPackage;
        char[][] packageName = pkg == null ? null : pkg.tokens;
        char[] mainTypeName = sourceUnit.getMainTypeName();
        char[] qualifiedName = packageName == null ? mainTypeName : CharOperation.concatWith(packageName, mainTypeName, '.');
        this.parsedUnits.put(qualifiedName, parsedUnit);
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding) {
        ISourceType sourceType = sourceTypes[0];
        while (sourceType.getEnclosingType() != null) {
            sourceType = sourceType.getEnclosingType();
        }
        if (sourceType instanceof SourceTypeElementInfo) {
            SourceTypeElementInfo elementInfo = (SourceTypeElementInfo)sourceType;
            IType type = elementInfo.getHandle();
            ICompilationUnit sourceUnit = (ICompilationUnit)((Object)type.getCompilationUnit());
            this.accept(sourceUnit);
        } else {
            CompilationResult result = new CompilationResult(sourceType.getFileName(), 0, 0, 0);
            CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(sourceTypes, true, true, false, this.lookupEnvironment.problemReporter, result);
            this.lookupEnvironment.buildTypeBindings(unit);
            this.lookupEnvironment.completeTypeBindings(unit, true);
            this.parsedUnits.put(sourceType.getQualifiedName(), unit);
        }
    }

    public IField createFieldHandle(FieldDeclaration field, IType type) {
        if (type == null) {
            return null;
        }
        return type.getField(new String(field.name));
    }

    public IJavaElement createImportHandle(ImportReference importRef) {
        Openable currentOpenable;
        char[] importName = CharOperation.concatWith(importRef.getImportName(), '.');
        if (importRef.onDemand) {
            importName = CharOperation.concat(importName, ".*".toCharArray());
        }
        if ((currentOpenable = this.getCurrentOpenable()) instanceof CompilationUnit) {
            return ((CompilationUnit)currentOpenable).getImport(new String(importName));
        }
        try {
            return ((ClassFile)currentOpenable).getType();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public IInitializer createInitializerHandle(TypeDeclaration typeDecl, FieldDeclaration initializer, IType type) {
        if (type == null) {
            return null;
        }
        int occurrenceCount = 0;
        FieldDeclaration[] fields = typeDecl.fields;
        int i = 0;
        int length = fields.length;
        while (i < length) {
            FieldDeclaration field = fields[i];
            if (!field.isField()) {
                ++occurrenceCount;
                if (field.equals(initializer)) break;
            }
            ++i;
        }
        return type.getInitializer(occurrenceCount);
    }

    public IMethod createMethodHandle(AbstractMethodDeclaration method, IType type) {
        int length;
        if (type == null) {
            return null;
        }
        Argument[] arguments = method.arguments;
        int n = length = arguments == null ? 0 : arguments.length;
        if (type.isBinary()) {
            ClassFileReader reader = this.classFileReader(type);
            if (reader == null) {
                return null;
            }
            IBinaryMethod[] methods = reader.getMethods();
            if (methods != null) {
                int i = 0;
                int methodsLength = methods.length;
                while (i < methodsLength) {
                    String[] parameterTypes;
                    char[] selector;
                    IBinaryMethod binaryMethod = methods[i];
                    char[] cArray = selector = binaryMethod.isConstructor() ? type.getElementName().toCharArray() : binaryMethod.getSelector();
                    if (CharOperation.equals(selector, method.selector) && length == (parameterTypes = Signature.getParameterTypes(new String(binaryMethod.getMethodDescriptor()))).length) {
                        boolean sameParameters = true;
                        int j = 0;
                        while (j < length) {
                            TypeReference parameterType = arguments[j].type;
                            char[] typeName = CharOperation.concatWith(parameterType.getTypeName(), '.');
                            int k = 0;
                            while (k < parameterType.dimensions()) {
                                typeName = CharOperation.concat(typeName, "[]".toCharArray());
                                ++k;
                            }
                            String parameterTypeName = parameterTypes[j].replace('/', '.');
                            if (!Signature.toString(parameterTypeName).endsWith(new String(typeName))) {
                                sameParameters = false;
                                break;
                            }
                            parameterTypes[j] = parameterTypeName;
                            ++j;
                        }
                        if (sameParameters) {
                            return type.getMethod(new String(selector), parameterTypes);
                        }
                    }
                    ++i;
                }
            }
            return null;
        }
        String[] parameterTypeSignatures = new String[length];
        int i = 0;
        while (i < length) {
            TypeReference parameterType = arguments[i].type;
            char[] typeName = CharOperation.concatWith(parameterType.getTypeName(), '.');
            int j = 0;
            while (j < parameterType.dimensions()) {
                typeName = CharOperation.concat(typeName, "[]".toCharArray());
                ++j;
            }
            parameterTypeSignatures[i] = Signature.createTypeSignature(typeName, false);
            ++i;
        }
        return type.getMethod(new String(method.selector), parameterTypeSignatures);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ClassFileReader classFileReader(IType type) {
        IClassFile classFile = type.getClassFile();
        if (((IOpenable)classFile).isOpen()) {
            JavaModelManager manager;
            JavaModelManager javaModelManager = manager = JavaModelManager.getJavaModelManager();
            synchronized (javaModelManager) {
                return (ClassFileReader)manager.getInfo(type);
            }
        }
        IPackageFragment pkg = type.getPackageFragment();
        IPackageFragmentRoot root = (IPackageFragmentRoot)pkg.getParent();
        try {
            ClassFileReader classFileReader;
            IPath zipPath;
            if (!root.isArchive()) return ClassFileReader.read(type.getPath().toOSString());
            IPath iPath = zipPath = root.isExternal() ? root.getPath() : root.getResource().getLocation();
            if (zipPath == null) {
                return null;
            }
            ZipFile zipFile = null;
            try {
                if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                    System.out.println("(" + Thread.currentThread() + ") [MatchLocator.classFileReader()] Creating ZipFile on " + zipPath);
                }
                zipFile = new ZipFile(zipPath.toOSString());
                char[] pkgPath = pkg.getElementName().toCharArray();
                CharOperation.replace(pkgPath, '.', '/');
                char[] classFileName = classFile.getElementName().toCharArray();
                char[] path = pkgPath.length == 0 ? classFileName : CharOperation.concat(pkgPath, classFileName, '/');
                classFileReader = ClassFileReader.read(zipFile, new String(path));
                Object var10_13 = null;
                if (zipFile == null) return classFileReader;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                if (zipFile == null) throw throwable;
                try {
                    zipFile.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                zipFile.close();
                return classFileReader;
            }
            catch (IOException iOException) {}
            return classFileReader;
        }
        catch (ClassFormatException classFormatException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public IType createTypeHandle(char[] simpleTypeName) {
        IType type;
        Openable currentOpenable = this.getCurrentOpenable();
        if (currentOpenable instanceof CompilationUnit) {
            CompilationUnit unit = (CompilationUnit)currentOpenable;
            return unit.getType(new String(simpleTypeName));
        }
        try {
            type = ((ClassFile)currentOpenable).getType();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        return MatchingOpenable.getTopLevelType(type);
    }

    public IType createTypeHandle(IType parent, char[] simpleTypeName) {
        return parent.getType(new String(simpleTypeName));
    }

    protected IResource getCurrentResource() {
        return this.currentMatchingOpenable.resource;
    }

    protected Scanner getScanner() {
        return this.parser == null ? null : this.parser.scanner;
    }

    public void initialize(JavaProject project) throws JavaModelException {
        CompilerOptions options = new CompilerOptions(project.getOptions(true));
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), options, new DefaultProblemFactory());
        this.lookupEnvironment = new LookupEnvironment(this, options, problemReporter, this.nameEnvironment);
        this.parser = new MatchLocatorParser(problemReporter, options.sourceLevel);
        MatchingOpenable[] openables = this.matchingOpenables.getMatchingOpenables(project.getPackageFragmentRoots());
        int i = 0;
        int length = openables.length;
        while (i < length) {
            MatchingOpenable matchingOpenable = openables[i];
            matchingOpenable.reset();
            ++i;
        }
        this.parsedUnits = new HashtableOfObject(10);
        this.nameLookup = project.getNameLookup();
    }

    public void initializeNameEnvironment(JavaProject project) throws JavaModelException {
        if (this.nameEnvironment != null) {
            this.nameEnvironment.cleanup();
        }
        this.nameEnvironment = this.getNameEnvironment(project);
    }

    public void locateMatches(String[] filePaths, IWorkspace workspace, IWorkingCopy[] workingCopies) throws JavaModelException {
        if (SearchEngine.VERBOSE) {
            System.out.println("Locating matches in files [");
            int i = 0;
            int length = filePaths.length;
            while (i < length) {
                String path = filePaths[i];
                System.out.println("\t" + path);
                ++i;
            }
            System.out.println("]");
            if (workingCopies != null) {
                System.out.println(" and working copies [");
                i = 0;
                length = workingCopies.length;
                while (i < length) {
                    IWorkingCopy wc = workingCopies[i];
                    System.out.println("\t" + ((JavaElement)((Object)wc)).toStringWithAncestors());
                    ++i;
                }
                System.out.println("]");
            }
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        try {
            int wcLength;
            manager.cacheZipFiles();
            if (this.handleFactory == null) {
                this.handleFactory = new HandleFactory(workspace);
            }
            this.workingCopies = workingCopies;
            HashMap<String, IWorkingCopy> wcPaths = new HashMap<String, IWorkingCopy>();
            if (workingCopies != null && (wcLength = workingCopies.length) > 0) {
                String[] newPaths = new String[wcLength];
                int i = 0;
                while (i < wcLength) {
                    IWorkingCopy workingCopy = workingCopies[i];
                    String path = workingCopy.getOriginalElement().getPath().toString();
                    wcPaths.put(path, workingCopy);
                    newPaths[i] = path;
                    ++i;
                }
                int filePathsLength = filePaths.length;
                String[] stringArray = filePaths;
                filePaths = new String[filePathsLength + wcLength];
                System.arraycopy(stringArray, 0, filePaths, 0, filePathsLength);
                System.arraycopy(newPaths, 0, filePaths, filePathsLength, wcLength);
            }
            int length = filePaths.length;
            if (this.progressMonitor != null) {
                if (this.pattern.needsResolve) {
                    this.progressMonitor.beginTask("", length * 10);
                } else {
                    this.progressMonitor.beginTask("", length * 4);
                }
            }
            Util.sort(filePaths);
            this.matchingOpenables = new MatchingOpenableSet();
            this.pattern.initializePolymorphicSearch(this, this.progressMonitor);
            JavaProject previousJavaProject = null;
            int i = 0;
            while (i < length) {
                block34: {
                    IResource resource;
                    Openable openable;
                    block32: {
                        IWorkingCopy workingCopy;
                        block37: {
                            String pathString;
                            block36: {
                                if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
                                    throw new OperationCanceledException();
                                }
                                pathString = filePaths[i];
                                if (i > 0 && pathString.equals(filePaths[i - 1])) break block34;
                                workingCopy = (IWorkingCopy)wcPaths.get(pathString);
                                if (workingCopy == null) break block36;
                                openable = (Openable)((Object)workingCopy);
                                break block37;
                            }
                            openable = this.handleFactory.createOpenable(pathString, this.scope);
                            if (openable == null) break block34;
                        }
                        resource = null;
                        JavaProject javaProject = null;
                        try {
                            javaProject = (JavaProject)openable.getJavaProject();
                            resource = workingCopy != null ? workingCopy.getOriginalElement().getResource() : openable.getResource();
                            if (resource == null) {
                                resource = javaProject.getProject();
                            }
                            if (javaProject.equals(previousJavaProject)) break block32;
                            if (previousJavaProject != null) {
                                block33: {
                                    try {
                                        this.locateMatches(previousJavaProject);
                                    }
                                    catch (JavaModelException e) {
                                        if (!(e.getException() instanceof CoreException)) break block33;
                                        throw e;
                                    }
                                }
                                this.matchingOpenables = new MatchingOpenableSet();
                            }
                            if (length == 1) {
                                if (this.nameEnvironment != null) {
                                    this.nameEnvironment.cleanup();
                                }
                                this.nameEnvironment = javaProject.getSearchableNameEnvironment();
                            } else {
                                this.initializeNameEnvironment(javaProject);
                            }
                            this.initialize(javaProject);
                            previousJavaProject = javaProject;
                        }
                        catch (JavaModelException javaModelException) {
                            break block34;
                        }
                    }
                    this.addMatchingOpenable(resource, openable, null, null);
                    if (this.progressMonitor != null) {
                        this.progressMonitor.worked(1);
                    }
                }
                ++i;
            }
            if (previousJavaProject != null) {
                block35: {
                    try {
                        this.locateMatches(previousJavaProject);
                    }
                    catch (JavaModelException e) {
                        if (!(e.getException() instanceof CoreException)) break block35;
                        throw e;
                    }
                }
                this.matchingOpenables = new MatchingOpenableSet();
            }
            if (this.progressMonitor != null) {
                this.progressMonitor.done();
            }
        }
        catch (Throwable throwable) {
            Object var16_24 = null;
            if (this.nameEnvironment != null) {
                this.nameEnvironment.cleanup();
            }
            this.parsedUnits = null;
            manager.flushZipFiles();
            throw throwable;
        }
        Object var16_25 = null;
        if (this.nameEnvironment != null) {
            this.nameEnvironment.cleanup();
        }
        this.parsedUnits = null;
        manager.flushZipFiles();
    }

    public void locatePackageDeclarations(IWorkspace workspace) throws JavaModelException {
        this.locatePackageDeclarations(this.pattern, workspace);
    }

    private void locatePackageDeclarations(SearchPattern searchPattern, IWorkspace workspace) throws JavaModelException {
        if (searchPattern instanceof OrPattern) {
            OrPattern orPattern = (OrPattern)searchPattern;
            this.locatePackageDeclarations(orPattern.leftPattern, workspace);
            this.locatePackageDeclarations(orPattern.rightPattern, workspace);
        } else if (searchPattern instanceof PackageDeclarationPattern) {
            PackageDeclarationPattern pkgPattern = (PackageDeclarationPattern)searchPattern;
            IJavaProject[] projects = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProjects();
            int i = 0;
            int length = projects.length;
            while (i < length) {
                IJavaProject javaProject = projects[i];
                IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
                int j = 0;
                int rootsLength = roots.length;
                while (j < rootsLength) {
                    IJavaElement[] pkgs = roots[j].getChildren();
                    int k = 0;
                    int pksLength = pkgs.length;
                    while (k < pksLength) {
                        IPackageFragment pkg = (IPackageFragment)pkgs[k];
                        if (pkg.getChildren().length > 0 && pkgPattern.matchesName(pkgPattern.pkgName, pkg.getElementName().toCharArray())) {
                            IResource resource = pkg.getResource();
                            if (resource == null) {
                                resource = javaProject.getProject();
                            }
                            this.currentMatchingOpenable = new MatchingOpenable(this, resource, null, null, null);
                            try {
                                this.report(-1, -2, pkg, 0);
                            }
                            catch (CoreException e) {
                                if (e instanceof JavaModelException) {
                                    throw (JavaModelException)e;
                                }
                                throw new JavaModelException(e);
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public IType lookupType(TypeBinding typeBinding) {
        IType type;
        char[] packageName = typeBinding.qualifiedPackageName();
        char[] typeName = typeBinding.qualifiedSourceName();
        IPackageFragment[] pkgs = this.nameLookup.findPackageFragments(packageName == null || packageName.length == 0 ? "" : new String(packageName), false);
        int i = 0;
        int length = pkgs == null ? 0 : pkgs.length;
        while (i < length) {
            type = this.nameLookup.findType(new String(typeName), pkgs[i], false, typeBinding.isClass() ? 2 : 4);
            if (type != null) {
                return type;
            }
            ++i;
        }
        char[][] qualifiedName = CharOperation.splitOn('.', typeName);
        length = qualifiedName.length;
        if (length == 0) {
            return null;
        }
        type = this.createTypeHandle(qualifiedName[0]);
        if (type == null) {
            return null;
        }
        int i2 = 1;
        while (i2 < length) {
            if ((type = this.createTypeHandle(type, qualifiedName[i2])) == null) {
                return null;
            }
            ++i2;
        }
        if (type.exists()) {
            return type;
        }
        return null;
    }

    public void report(int sourceStart, int sourceEnd, IJavaElement element, int accuracy) throws CoreException {
        if (this.scope.encloses(element)) {
            if (SearchEngine.VERBOSE) {
                IResource res = this.getCurrentResource();
                System.out.println("Reporting match");
                System.out.println("\tResource: " + (res == null ? " <unknown> " : res.getFullPath().toString()));
                System.out.println("\tPositions: [" + sourceStart + ", " + sourceEnd + "]");
                System.out.println("\tJava element: " + ((JavaElement)element).toStringWithAncestors());
                if (accuracy == 0) {
                    System.out.println("\tAccuracy: EXACT_MATCH");
                } else {
                    System.out.println("\tAccuracy: POTENTIAL_MATCH");
                }
            }
            this.report(this.getCurrentResource(), sourceStart, sourceEnd, element, accuracy);
        }
    }

    public void report(IResource resource, int sourceStart, int sourceEnd, IJavaElement element, int accuracy) throws CoreException {
        this.collector.accept(resource, sourceStart, sourceEnd + 1, element, accuracy);
    }

    public void reportBinaryMatch(IMember binaryMember, IBinaryType info, int accuracy) throws CoreException, JavaModelException {
        this.reportBinaryMatch(null, binaryMember, info, accuracy);
    }

    public void reportBinaryMatch(IResource resource, IMember binaryMember, IBinaryType info, int accuracy) throws CoreException, JavaModelException {
        char[] contents;
        IType type;
        String sourceFileName;
        ClassFile classFile;
        SourceMapper mapper;
        ISourceRange range = binaryMember.getNameRange();
        if (range.getOffset() == -1 && (mapper = (classFile = (ClassFile)binaryMember.getClassFile()).getSourceMapper()) != null && (sourceFileName = mapper.findSourceFileName(type = classFile.getType(), info)) != null && (contents = mapper.findSource(type, sourceFileName)) != null) {
            range = mapper.mapSource(type, contents, binaryMember);
        }
        int startIndex = range.getOffset();
        int endIndex = startIndex + range.getLength() - 1;
        if (resource == null) {
            this.report(startIndex, endIndex, binaryMember, accuracy);
        } else {
            this.report(resource, startIndex, endIndex, binaryMember, accuracy);
        }
    }

    public void reportFieldDeclaration(FieldDeclaration fieldDeclaration, IJavaElement parent, int accuracy) throws CoreException {
        this.report(fieldDeclaration.sourceStart, fieldDeclaration.sourceEnd, parent instanceof IType ? ((IType)parent).getField(new String(fieldDeclaration.name)) : parent, accuracy);
    }

    public void reportImport(ImportReference reference, int accuracy) throws CoreException {
        IJavaElement importHandle = this.createImportHandle(reference);
        this.pattern.matchReportImportRef(reference, null, importHandle, accuracy, this);
    }

    public void reportMethodDeclaration(AbstractMethodDeclaration methodDeclaration, IJavaElement parent, int accuracy) throws CoreException {
        IJavaElement enclosingElement;
        if (parent instanceof IType) {
            enclosingElement = this.createMethodHandle(methodDeclaration, (IType)parent);
            if (enclosingElement == null) {
                return;
            }
        } else {
            enclosingElement = parent;
        }
        Scanner scanner = this.parser.scanner;
        int nameSourceStart = methodDeclaration.sourceStart;
        scanner.setSource(this.currentMatchingOpenable.getSource());
        scanner.resetTo(nameSourceStart, methodDeclaration.sourceEnd);
        try {
            scanner.getNextToken();
        }
        catch (InvalidInputException invalidInputException) {}
        int nameSourceEnd = scanner.currentPosition - 1;
        this.report(nameSourceStart, nameSourceEnd, enclosingElement, accuracy);
    }

    public void reportPackageDeclaration(ImportReference node) {
    }

    public void reportPackageReference(ImportReference node) {
    }

    public void reportAccurateReference(int sourceStart, int sourceEnd, char[][] qualifiedName, IJavaElement element, int accuracy) throws CoreException {
        if (accuracy == -1) {
            return;
        }
        Scanner scanner = this.parser.scanner;
        scanner.setSource(this.currentMatchingOpenable.getSource());
        scanner.resetTo(sourceStart, sourceEnd);
        int refSourceStart = -1;
        int refSourceEnd = -1;
        int tokenNumber = qualifiedName.length;
        int token = -1;
        int previousValid = -1;
        int i = 0;
        while (true) {
            int currentPosition = scanner.currentPosition;
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {}
            if (token != 6 && token != 114) continue;
            if (token != 114) {
                char[] currentTokenSource = scanner.getCurrentTokenSource();
                boolean equals = false;
                while (i < tokenNumber && !(equals = this.pattern.matchesName(qualifiedName[i++], currentTokenSource))) {
                }
                if (equals && (previousValid == -1 || previousValid == i - 2)) {
                    previousValid = i - 1;
                    if (refSourceStart == -1) {
                        refSourceStart = currentPosition;
                    }
                    refSourceEnd = scanner.currentPosition - 1;
                } else {
                    i = 0;
                    refSourceStart = -1;
                    previousValid = -1;
                }
                try {
                    token = scanner.getNextToken();
                }
                catch (InvalidInputException invalidInputException) {}
            }
            if (i == tokenNumber) {
                if (refSourceStart != -1) {
                    this.report(refSourceStart, refSourceEnd, element, accuracy);
                } else {
                    this.report(sourceStart, sourceEnd, element, accuracy);
                }
                return;
            }
            if (token == 114) break;
        }
    }

    public void reportAccurateReference(int sourceStart, int sourceEnd, char[][] tokens, IJavaElement element, int[] accuracies) throws CoreException {
        Scanner scanner = this.parser.scanner;
        scanner.setSource(this.currentMatchingOpenable.getSource());
        scanner.resetTo(sourceStart, sourceEnd);
        int refSourceStart = -1;
        int refSourceEnd = -1;
        int length = tokens.length;
        int token = -1;
        int previousValid = -1;
        int i = 0;
        int accuracyIndex = 0;
        do {
            int currentPosition = scanner.currentPosition;
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {}
            if (token != 114) {
                char[] currentTokenSource = scanner.getCurrentTokenSource();
                boolean equals = false;
                while (i < length && !(equals = this.pattern.matchesName(tokens[i++], currentTokenSource))) {
                }
                if (equals && (previousValid == -1 || previousValid == i - 2)) {
                    previousValid = i - 1;
                    if (refSourceStart == -1) {
                        refSourceStart = currentPosition;
                    }
                    refSourceEnd = scanner.currentPosition - 1;
                } else {
                    i = 0;
                    refSourceStart = -1;
                    previousValid = -1;
                }
                try {
                    token = scanner.getNextToken();
                }
                catch (InvalidInputException invalidInputException) {}
            }
            if (accuracies[accuracyIndex] != -1) {
                if (refSourceStart != -1) {
                    this.report(refSourceStart, refSourceEnd, element, accuracies[accuracyIndex]);
                } else {
                    this.report(sourceStart, sourceEnd, element, accuracies[accuracyIndex]);
                }
                i = 0;
            }
            refSourceStart = -1;
            previousValid = -1;
            if (accuracyIndex >= accuracies.length - 1) continue;
            ++accuracyIndex;
        } while (token != 114);
    }

    public void reportReference(AstNode reference, AbstractMethodDeclaration methodDeclaration, IJavaElement parent, int accuracy) throws CoreException {
        IJavaElement enclosingElement;
        if (parent instanceof IType) {
            enclosingElement = this.createMethodHandle(methodDeclaration, (IType)parent);
            if (enclosingElement == null) {
                return;
            }
        } else {
            enclosingElement = parent;
        }
        this.pattern.matchReportReference(reference, enclosingElement, accuracy, this);
    }

    public void reportReference(AstNode reference, TypeDeclaration typeDeclaration, FieldDeclaration fieldDeclaration, IJavaElement parent, int accuracy) throws CoreException {
        if (fieldDeclaration.isField()) {
            IJavaElement enclosingElement;
            if (parent instanceof IType) {
                enclosingElement = this.createFieldHandle(fieldDeclaration, (IType)parent);
                if (enclosingElement == null) {
                    return;
                }
            } else {
                enclosingElement = parent;
            }
            this.pattern.matchReportReference(reference, enclosingElement, accuracy, this);
        } else {
            IJavaElement enclosingElement;
            if (parent instanceof IType) {
                enclosingElement = this.createInitializerHandle(typeDeclaration, fieldDeclaration, (IType)parent);
                if (enclosingElement == null) {
                    return;
                }
            } else {
                enclosingElement = parent;
            }
            this.pattern.matchReportReference(reference, enclosingElement, accuracy, this);
        }
    }

    public void reportSuperTypeReference(TypeReference typeRef, IJavaElement type, int accuracy) throws CoreException {
        this.pattern.matchReportReference(typeRef, type, accuracy, this);
    }

    public void reportTypeDeclaration(TypeDeclaration typeDeclaration, IJavaElement parent, int accuracy) throws CoreException {
        this.report(typeDeclaration.sourceStart, typeDeclaration.sourceEnd, parent == null ? this.createTypeHandle(typeDeclaration.name) : (parent instanceof IType ? this.createTypeHandle((IType)parent, typeDeclaration.name) : parent), accuracy);
    }

    void addMatchingOpenable(IResource resource, Openable openable, CompilationUnitDeclaration parsedUnit, MatchSet matchSet) {
        MatchingOpenable matchingOpenable = new MatchingOpenable(this, resource, openable, parsedUnit, matchSet);
        if (matchingOpenable != null) {
            this.matchingOpenables.add(matchingOpenable);
        }
    }

    BinaryTypeBinding cacheBinaryType(IType type) throws JavaModelException {
        char[][] compoundName;
        ReferenceBinding referenceBinding;
        IBinaryType binaryType;
        BinaryTypeBinding binding;
        IType enclosingType = type.getDeclaringType();
        if (enclosingType != null) {
            this.cacheBinaryType(enclosingType);
        }
        if ((binding = this.lookupEnvironment.cacheBinaryType(binaryType = (IBinaryType)((BinaryType)type).getElementInfo())) == null && (referenceBinding = this.lookupEnvironment.getCachedType(compoundName = CharOperation.splitOn('.', type.getFullyQualifiedName().toCharArray()))) != null && referenceBinding instanceof BinaryTypeBinding) {
            binding = (BinaryTypeBinding)referenceBinding;
        }
        return binding;
    }

    private INameEnvironment getNameEnvironment(JavaProject project) throws JavaModelException {
        return new JavaSearchNameEnvironment(project);
    }

    public CompilationUnitDeclaration dietParse(final char[] source) {
        ICompilationUnit sourceUnit = new ICompilationUnit(){

            public char[] getContents() {
                return source;
            }

            public char[] getFileName() {
                return EMPTY_FILE_NAME;
            }

            public char[] getMainTypeName() {
                return null;
            }

            public char[][] getPackageName() {
                return null;
            }
        };
        CompilationResult compilationResult = new CompilationResult(sourceUnit, 0, 0, 0);
        return this.parser.dietParse(sourceUnit, compilationResult);
    }

    public char[] findSource(ClassFile classFile) {
        char[] source = null;
        try {
            SourceMapper sourceMapper = classFile.getSourceMapper();
            if (sourceMapper != null) {
                IType type = classFile.getType();
                if (classFile.isOpen() && type.getDeclaringType() == null) {
                    source = sourceMapper.findSource(type);
                } else {
                    String sourceFileName;
                    ClassFileReader reader = this.classFileReader(type);
                    if (reader != null && (sourceFileName = sourceMapper.findSourceFileName(type, reader)) != null) {
                        source = sourceMapper.findSource(type, sourceFileName);
                    }
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        return source;
    }

    public IBinaryType getBinaryInfo(ClassFile classFile, IResource resource) throws CoreException {
        BinaryType binaryType = (BinaryType)classFile.getType();
        if (classFile.isOpen()) {
            return (IBinaryType)binaryType.getElementInfo();
        }
        try {
            ClassFileReader info;
            IJavaElement pkg = classFile.getParent();
            PackageFragmentRoot root = (PackageFragmentRoot)pkg.getParent();
            if (root.isArchive()) {
                String pkgPath = pkg.getElementName().replace('.', '/');
                String classFilePath = pkgPath.length() > 0 ? String.valueOf(pkgPath) + "/" + classFile.getElementName() : classFile.getElementName();
                ZipFile zipFile = null;
                try {
                    zipFile = ((JarPackageFragmentRoot)root).getJar();
                    info = ClassFileReader.read(zipFile, classFilePath);
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
                    throw throwable;
                }
                Object var10_14 = null;
                JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
            } else {
                String osPath = resource.getFullPath().toOSString();
                info = ClassFileReader.read(osPath);
            }
            return info;
        }
        catch (ClassFormatException classFormatException) {
            return null;
        }
        catch (IOException e) {
            throw new JavaModelException(e, 985);
        }
    }

    protected Openable getCurrentOpenable() {
        return this.currentMatchingOpenable.openable;
    }

    private void locateMatches(JavaProject javaProject) throws JavaModelException {
        MatchingOpenable[] openables = this.matchingOpenables.getMatchingOpenables(javaProject.getPackageFragmentRoots());
        this.compilationAborted = false;
        if (this.pattern.needsResolve) {
            this.createAndResolveBindings(openables);
        }
        if (this.scope instanceof HierarchyScope) {
            IType focusType = ((HierarchyScope)this.scope).focusType;
            if (focusType != null) {
                if (!focusType.isBinary()) {
                    this.accept((ICompilationUnit)((Object)focusType.getCompilationUnit()));
                }
                char[] fullyQualifiedName = focusType.getFullyQualifiedName().toCharArray();
                this.hierarchyResolver = new HierarchyResolver(this.lookupEnvironment, null);
                if (this.hierarchyResolver.setFocusType(CharOperation.splitOn('.', fullyQualifiedName)) == null) {
                    return;
                }
            } else {
                this.hierarchyResolver = null;
            }
        } else {
            this.hierarchyResolver = null;
        }
        int i = 0;
        int length = openables.length;
        while (i < length) {
            Object var6_8;
            block17: {
                if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    try {
                        this.currentMatchingOpenable = openables[i];
                        if (!this.currentMatchingOpenable.hasAlreadyDefinedType()) {
                            this.currentMatchingOpenable.locateMatches();
                        }
                    }
                    catch (AbortCompilation abortCompilation) {
                        this.compilationAborted = true;
                    }
                    catch (CoreException e) {
                        if (e instanceof JavaModelException) {
                            this.compilationAborted = true;
                            break block17;
                        }
                        throw new JavaModelException(e);
                    }
                }
                catch (Throwable throwable) {
                    var6_8 = null;
                    this.currentMatchingOpenable.reset();
                    throw throwable;
                }
            }
            var6_8 = null;
            this.currentMatchingOpenable.reset();
            if (this.progressMonitor != null) {
                this.progressMonitor.worked(3);
            }
            ++i;
        }
        this.currentMatchingOpenable = null;
    }

    void createAndResolveBindings(MatchingOpenable[] openables) {
        int i = 0;
        int length = openables.length;
        while (i < length) {
            openables[i].buildTypeBindings();
            if (this.progressMonitor != null) {
                if (this.progressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.progressMonitor.worked(6);
            }
            ++i;
        }
        try {
            this.lookupEnvironment.completeTypeBindings();
        }
        catch (AbortCompilation abortCompilation) {
            this.compilationAborted = true;
        }
    }
}

