/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.index.impl;

import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.internal.core.index.IDocument;
import org.eclipse.jdt.internal.core.index.impl.BlocksIndexOutput;
import org.eclipse.jdt.internal.core.index.impl.IndexOutput;
import org.eclipse.jdt.internal.core.index.impl.IndexedFile;
import org.eclipse.jdt.internal.core.index.impl.IndexedFileHashedArray;
import org.eclipse.jdt.internal.core.index.impl.Util;
import org.eclipse.jdt.internal.core.index.impl.WordEntry;
import org.eclipse.jdt.internal.core.index.impl.WordEntryHashedArray;

public class InMemoryIndex {
    protected WordEntryHashedArray words;
    protected IndexedFileHashedArray files;
    protected long footprint;
    private WordEntry[] sortedWordEntries;
    private IndexedFile[] sortedFiles;

    public InMemoryIndex() {
        this.init();
    }

    public IndexedFile addDocument(IDocument document) {
        IndexedFile indexedFile = this.files.add(document);
        this.footprint += (long)(indexedFile.footprint() + 4);
        this.sortedFiles = null;
        return indexedFile;
    }

    protected void addRef(char[] word, int[] references) {
        int size = references.length;
        int i = 0;
        while (i < size) {
            if (references[i] != 0) {
                this.addRef(word, references[i]);
            }
            ++i;
        }
    }

    protected void addRef(char[] word, int fileNum) {
        WordEntry entry = this.words.get(word);
        if (entry == null) {
            entry = new WordEntry(word);
            entry.addRef(fileNum);
            this.words.add(entry);
            this.sortedWordEntries = null;
            this.footprint += (long)entry.footprint();
        } else {
            this.footprint += (long)entry.addRef(fileNum);
        }
    }

    public void addRef(IndexedFile indexedFile, char[] word) {
        this.addRef(word, indexedFile.getFileNumber());
    }

    public void addRef(IndexedFile indexedFile, String word) {
        this.addRef(word.toCharArray(), indexedFile.getFileNumber());
    }

    public long getFootprint() {
        return this.footprint;
    }

    public IndexedFile getIndexedFile(String path) {
        return this.files.get(path);
    }

    public int getNumFiles() {
        return this.files.size();
    }

    public int getNumWords() {
        return this.words.elementSize;
    }

    protected IndexedFile[] getSortedFiles() {
        if (this.sortedFiles == null) {
            IndexedFile[] indexedFiles = this.files.asArray();
            Util.sort(indexedFiles);
            this.sortedFiles = indexedFiles;
        }
        return this.sortedFiles;
    }

    protected WordEntry[] getSortedWordEntries() {
        if (this.sortedWordEntries == null) {
            WordEntry[] wordEntries = this.words.asArray();
            Util.sort(wordEntries);
            this.sortedWordEntries = wordEntries;
        }
        return this.sortedWordEntries;
    }

    protected WordEntry getWordEntry(char[] word) {
        return this.words.get(word);
    }

    public void init() {
        this.words = new WordEntryHashedArray(501);
        this.files = new IndexedFileHashedArray(101);
        this.footprint = 0L;
        this.sortedWordEntries = null;
        this.sortedFiles = null;
    }

    public void save(File file) throws IOException {
        BlocksIndexOutput output = new BlocksIndexOutput(file);
        this.save(output);
    }

    protected void save(IndexOutput output) throws IOException {
        block5: {
            boolean ok = false;
            try {
                output.open();
                IndexedFile[] indexedFiles = this.files.asArray();
                int i = 0;
                int length = indexedFiles.length;
                while (i < length) {
                    output.addFile(indexedFiles[i]);
                    ++i;
                }
                this.getSortedWordEntries();
                i = 0;
                int numWords = this.sortedWordEntries.length;
                while (i < numWords) {
                    output.addWord(this.sortedWordEntries[i]);
                    ++i;
                }
                output.flush();
                output.close();
                ok = true;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (!ok && output != null) {
                    output.close();
                }
                throw throwable;
            }
            Object var6_8 = null;
            if (ok || output == null) break block5;
            output.close();
        }
    }
}

