/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.Comparator;
import java.util.Locale;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.jdt.internal.core.JavaModelOperation;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.SortElementBuilder;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.jdt.internal.core.WorkingCopy;
import org.eclipse.jdt.internal.core.builder.ProblemFactory;

public class SortElementsOperation
extends JavaModelOperation {
    Comparator comparator;
    boolean hasChanged;
    int[] positions;

    public SortElementsOperation(IJavaElement[] elements, int[] positions, Comparator comparator) {
        super(elements);
        this.comparator = comparator;
        this.positions = positions;
    }

    protected int getMainAmountOfWork() {
        return this.fElementsToProcess.length;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeOperation() throws JavaModelException {
        block5: {
            block4: {
                try {
                    this.beginTask(Util.bind("operation.sortelements"), this.getMainAmountOfWork());
                    WorkingCopy copy = (WorkingCopy)this.fElementsToProcess[0];
                    ICompilationUnit unit = (ICompilationUnit)copy.getOriginalElement();
                    IBuffer buffer = copy.getBuffer();
                    if (buffer == null) {
                        Object var6_4 = null;
                        break block4;
                    }
                    char[] bufferContents = buffer.getCharacters();
                    String result = this.processElement(unit, this.positions, bufferContents);
                    if (!CharOperation.equals(result.toCharArray(), bufferContents)) {
                        copy.getBuffer().setContents(result);
                    }
                    this.worked(1);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    this.done();
                    throw throwable;
                }
            }
            this.done();
            return;
        }
        Object var6_6 = null;
        this.done();
    }

    private String processElement(ICompilationUnit unit, int[] positionsToMap, char[] source) throws JavaModelException {
        this.hasChanged = false;
        SortElementBuilder builder = new SortElementBuilder(source, positionsToMap, this.comparator);
        SourceElementParser parser = new SourceElementParser(builder, ProblemFactory.getProblemFactory(Locale.getDefault()), new CompilerOptions(JavaCore.getOptions()), true);
        if (unit.exists()) {
            IPackageFragment packageFragment = (IPackageFragment)unit.getAncestor(4);
            char[][] expectedPackageName = null;
            if (packageFragment != null) {
                expectedPackageName = CharOperation.splitOn('.', packageFragment.getElementName().toCharArray());
            }
            parser.parseCompilationUnit(new BasicCompilationUnit(source, expectedPackageName, unit.getElementName(), null), false);
        } else {
            parser.parseCompilationUnit(new BasicCompilationUnit(source, null, "", null), false);
        }
        return builder.getSource();
    }

    public IJavaModelStatus verify() {
        if (this.fElementsToProcess.length != 1) {
            return new JavaModelStatus(968);
        }
        if (this.fElementsToProcess[0] == null) {
            return new JavaModelStatus(968);
        }
        if (!(this.fElementsToProcess[0] instanceof IWorkingCopy) || !((IWorkingCopy)((Object)this.fElementsToProcess[0])).isWorkingCopy()) {
            return new JavaModelStatus(967, this.fElementsToProcess[0]);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

