/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TagBits;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;

public final class MethodVerifier
implements TagBits,
TypeConstants {
    SourceTypeBinding type = null;
    HashtableOfObject inheritedMethods = null;
    HashtableOfObject currentMethods = null;
    ReferenceBinding runtimeException = null;
    ReferenceBinding errorException = null;
    LookupEnvironment environment;

    public MethodVerifier(LookupEnvironment environment) {
        this.environment = environment;
    }

    private void checkAgainstInheritedMethods(MethodBinding currentMethod, MethodBinding[] methods, int length) {
        currentMethod.modifiers |= 0x10000000;
        int i = length;
        while (--i >= 0) {
            MethodBinding inheritedMethod = methods[i];
            if (!currentMethod.isAbstract() && inheritedMethod.isAbstract()) {
                currentMethod.modifiers |= 0x20000000;
            }
            if (currentMethod.returnType != inheritedMethod.returnType) {
                this.problemReporter(currentMethod).incompatibleReturnType(currentMethod, inheritedMethod);
                continue;
            }
            if (currentMethod.isStatic() != inheritedMethod.isStatic()) {
                this.problemReporter(currentMethod).staticAndInstanceConflict(currentMethod, inheritedMethod);
                continue;
            }
            if (currentMethod.thrownExceptions != TypeConstants.NoExceptions) {
                this.checkExceptions(currentMethod, inheritedMethod);
            }
            if (inheritedMethod.isFinal()) {
                this.problemReporter(currentMethod).finalMethodCannotBeOverridden(currentMethod, inheritedMethod);
            }
            if (!this.isAsVisible(currentMethod, inheritedMethod)) {
                this.problemReporter(currentMethod).visibilityConflict(currentMethod, inheritedMethod);
            }
            if (!inheritedMethod.isViewedAsDeprecated() || currentMethod.isViewedAsDeprecated() && !this.environment.options.reportDeprecationInsideDeprecatedCode) continue;
            this.problemReporter(currentMethod).overridesDeprecatedMethod(currentMethod, inheritedMethod);
        }
    }

    private void checkExceptions(MethodBinding newMethod, MethodBinding inheritedMethod) {
        ReferenceBinding[] newExceptions = newMethod.thrownExceptions;
        ReferenceBinding[] inheritedExceptions = inheritedMethod.thrownExceptions;
        int i = newExceptions.length;
        while (--i >= 0) {
            ReferenceBinding newException = newExceptions[i];
            int j = inheritedExceptions.length;
            while (--j > -1 && !this.isSameClassOrSubclassOf(newException, inheritedExceptions[j])) {
            }
            if (j != -1 || newException.isCompatibleWith(this.runtimeException()) || newException.isCompatibleWith(this.errorException())) continue;
            this.problemReporter(newMethod).incompatibleExceptionInThrowsClause(this.type, newMethod, inheritedMethod, newException);
        }
    }

    private void checkInheritedMethods(MethodBinding[] methods, int length) {
        int i;
        TypeBinding returnType = methods[0].returnType;
        int index = length;
        while (--index > 0 && returnType == methods[index].returnType) {
        }
        if (index > 0) {
            this.problemReporter().inheritedMethodsHaveIncompatibleReturnTypes(this.type, methods, length);
            return;
        }
        MethodBinding concreteMethod = null;
        if (!this.type.isInterface()) {
            i = length;
            while (--i >= 0) {
                if (methods[i].isAbstract()) continue;
                concreteMethod = methods[i];
                break;
            }
        }
        if (concreteMethod == null) {
            if (this.type.isClass() && !this.type.isAbstract()) {
                i = length;
                while (--i >= 0) {
                    if (this.mustImplementAbstractMethod(methods[i])) continue;
                    return;
                }
                TypeDeclaration typeDeclaration = this.type.scope.referenceContext;
                if (typeDeclaration != null) {
                    MethodDeclaration missingAbstractMethod = typeDeclaration.addMissingAbstractMethodFor(methods[0]);
                    missingAbstractMethod.scope.problemReporter().abstractMethodMustBeImplemented(this.type, methods[0]);
                } else {
                    this.problemReporter().abstractMethodMustBeImplemented(this.type, methods[0]);
                }
            }
            return;
        }
        MethodBinding[] abstractMethods = new MethodBinding[length - 1];
        index = 0;
        int i2 = length;
        while (--i2 >= 0) {
            if (methods[i2] == concreteMethod) continue;
            abstractMethods[index++] = methods[i2];
        }
        if (concreteMethod.isStatic()) {
            this.problemReporter().staticInheritedMethodConflicts(this.type, concreteMethod, abstractMethods);
        }
        if (!concreteMethod.isPublic()) {
            this.problemReporter().inheritedMethodReducesVisibility(this.type, concreteMethod, abstractMethods);
        }
        if (concreteMethod.thrownExceptions != TypeConstants.NoExceptions) {
            i2 = abstractMethods.length;
            while (--i2 >= 0) {
                this.checkExceptions(concreteMethod, abstractMethods[i2]);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void checkMethods() {
        mustImplementAbstractMethods = this.type.isClass() != false && this.type.isAbstract() == false;
        methodSelectors = this.inheritedMethods.keyTable;
        s = methodSelectors.length;
        while (--s >= 0) {
            block16: {
                if (methodSelectors[s] == null) continue;
                current = (MethodBinding[])this.currentMethods.get(methodSelectors[s]);
                inherited = (MethodBinding[])this.inheritedMethods.valueTable[s];
                index = -1;
                matchingInherited = new MethodBinding[inherited.length];
                if (current == null) break block16;
                i = 0;
                length1 = current.length;
                ** GOTO lbl29
                {
                    matchingInherited[index--] = null;
                    do {
                        if (index >= 0) continue block1;
                        currentMethod = current[i];
                        j = 0;
                        length2 = inherited.length;
                        while (j < length2) {
                            if (inherited[j] != null && currentMethod.areParametersEqual(inherited[j])) {
                                matchingInherited[++index] = inherited[j];
                                inherited[j] = null;
                            }
                            ++j;
                        }
                        if (index >= 0) {
                            this.checkAgainstInheritedMethods(currentMethod, matchingInherited, index + 1);
                        }
                        ++i;
lbl29:
                        // 2 sources

                    } while (i < length1);
                }
            }
            i = 0;
            length = inherited.length;
            ** GOTO lbl57
            {
                matchingInherited[index--] = null;
                do {
                    if (index >= 0) continue block4;
                    if (inherited[i] != null) {
                        matchingInherited[++index] = inherited[i];
                        j = i + 1;
                        while (j < length) {
                            if (inherited[j] != null && inherited[i].areParametersEqual(inherited[j])) {
                                matchingInherited[++index] = inherited[j];
                                inherited[j] = null;
                            }
                            ++j;
                        }
                    }
                    if (index > 0) {
                        this.checkInheritedMethods(matchingInherited, index + 1);
                    } else if (mustImplementAbstractMethods && index == 0 && matchingInherited[0].isAbstract() && this.mustImplementAbstractMethod(matchingInherited[0])) {
                        typeDeclaration = this.type.scope.referenceContext;
                        if (typeDeclaration != null) {
                            missingAbstractMethod = typeDeclaration.addMissingAbstractMethodFor(matchingInherited[0]);
                            missingAbstractMethod.scope.problemReporter().abstractMethodMustBeImplemented(this.type, matchingInherited[0]);
                        } else {
                            this.problemReporter().abstractMethodMustBeImplemented(this.type, matchingInherited[0]);
                        }
                    }
                    ++i;
lbl57:
                    // 2 sources

                } while (i < length);
            }
        }
    }

    private void checkPackagePrivateAbstractMethod(MethodBinding abstractMethod) {
        ReferenceBinding superType = this.type.superclass();
        char[] selector = abstractMethod.selector;
        do {
            if (!superType.isValidBinding()) {
                return;
            }
            if (!superType.isAbstract()) {
                return;
            }
            MethodBinding[] methods = superType.getMethods(selector);
            int m = methods.length;
            while (--m >= 0) {
                MethodBinding method = methods[m];
                if (method.returnType != abstractMethod.returnType || !method.areParametersEqual(abstractMethod) || method.isPrivate() || method.isConstructor() || method.isDefaultAbstract() || superType.fPackage != abstractMethod.declaringClass.fPackage) continue;
                return;
            }
        } while ((superType = superType.superclass()) != abstractMethod.declaringClass);
        this.problemReporter().abstractMethodCannotBeOverridden(this.type, abstractMethod);
    }

    private void computeInheritedMethods() {
        int j;
        ReferenceBinding[] interfaces;
        this.inheritedMethods = new HashtableOfObject(51);
        ReferenceBinding[][] interfacesToVisit = new ReferenceBinding[5][];
        int lastPosition = 0;
        interfacesToVisit[lastPosition] = this.type.superInterfaces();
        ReferenceBinding superType = this.type.isClass() ? this.type.superclass() : this.type.scope.getJavaLangObject();
        MethodBinding[] nonVisibleDefaultMethods = null;
        int nonVisibleCount = 0;
        while (superType != null) {
            if (!superType.isValidBinding()) continue;
            ReferenceBinding[] itsInterfaces = superType.superInterfaces();
            if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                if (++lastPosition == interfacesToVisit.length) {
                    ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                    interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                }
                interfacesToVisit[lastPosition] = itsInterfaces;
            }
            MethodBinding[] methods = superType.methods();
            int m = methods.length;
            block1: while (--m >= 0) {
                MethodBinding[] current;
                int i;
                MethodBinding method = methods[m];
                if (method.isPrivate() || method.isConstructor() || method.isDefaultAbstract()) continue;
                MethodBinding[] existingMethods = (MethodBinding[])this.inheritedMethods.get(method.selector);
                if (existingMethods != null) {
                    i = 0;
                    int length = existingMethods.length;
                    while (i < length) {
                        if (method.returnType == existingMethods[i].returnType && method.areParametersEqual(existingMethods[i])) {
                            if (!method.isDefault() || !method.isAbstract() || method.declaringClass.fPackage == this.type.fPackage) continue block1;
                            this.checkPackagePrivateAbstractMethod(method);
                            continue block1;
                        }
                        ++i;
                    }
                }
                if (nonVisibleDefaultMethods != null) {
                    i = 0;
                    while (i < nonVisibleCount) {
                        if (method.returnType == nonVisibleDefaultMethods[i].returnType && CharOperation.equals(method.selector, nonVisibleDefaultMethods[i].selector) && method.areParametersEqual(nonVisibleDefaultMethods[i])) continue block1;
                        ++i;
                    }
                }
                if (!method.isDefault() || method.declaringClass.fPackage == this.type.fPackage) {
                    if (existingMethods == null) {
                        existingMethods = new MethodBinding[1];
                    } else {
                        MethodBinding[] methodBindingArray = existingMethods;
                        existingMethods = new MethodBinding[existingMethods.length + 1];
                        System.arraycopy(methodBindingArray, 0, existingMethods, 0, existingMethods.length - 1);
                    }
                    existingMethods[existingMethods.length - 1] = method;
                    this.inheritedMethods.put(method.selector, existingMethods);
                    continue;
                }
                if (nonVisibleDefaultMethods == null) {
                    nonVisibleDefaultMethods = new MethodBinding[10];
                } else if (nonVisibleCount == nonVisibleDefaultMethods.length) {
                    MethodBinding[] methodBindingArray = nonVisibleDefaultMethods;
                    nonVisibleDefaultMethods = new MethodBinding[nonVisibleCount * 2];
                    System.arraycopy(methodBindingArray, 0, nonVisibleDefaultMethods, 0, nonVisibleCount);
                }
                nonVisibleDefaultMethods[nonVisibleCount++] = method;
                if (method.isAbstract() && !this.type.isAbstract()) {
                    this.problemReporter().abstractMethodCannotBeOverridden(this.type, method);
                }
                if ((current = (MethodBinding[])this.currentMethods.get(method.selector)) == null) continue;
                int i2 = 0;
                int length = current.length;
                while (i2 < length) {
                    if (method.returnType == current[i2].returnType && method.areParametersEqual(current[i2])) {
                        this.problemReporter().overridesPackageDefaultMethod(current[i2], method);
                        continue block1;
                    }
                    ++i2;
                }
            }
            superType = superType.superclass();
        }
        int i = 0;
        while (i <= lastPosition) {
            interfaces = interfacesToVisit[i];
            j = 0;
            int length = interfaces.length;
            while (j < length) {
                superType = interfaces[j];
                if ((superType.tagBits & 0x800) == 0) {
                    superType.tagBits |= 0x800;
                    if (superType.isValidBinding()) {
                        ReferenceBinding[] itsInterfaces = superType.superInterfaces();
                        if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                            if (++lastPosition == interfacesToVisit.length) {
                                ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                                interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                            }
                            interfacesToVisit[lastPosition] = itsInterfaces;
                        }
                        MethodBinding[] methods = superType.methods();
                        int m = methods.length;
                        while (--m >= 0) {
                            MethodBinding method = methods[m];
                            MethodBinding[] existingMethods = (MethodBinding[])this.inheritedMethods.get(method.selector);
                            if (existingMethods == null) {
                                existingMethods = new MethodBinding[1];
                            } else {
                                MethodBinding[] methodBindingArray = existingMethods;
                                existingMethods = new MethodBinding[existingMethods.length + 1];
                                System.arraycopy(methodBindingArray, 0, existingMethods, 0, existingMethods.length - 1);
                            }
                            existingMethods[existingMethods.length - 1] = method;
                            this.inheritedMethods.put(method.selector, existingMethods);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i <= lastPosition) {
            interfaces = interfacesToVisit[i];
            j = 0;
            int length = interfaces.length;
            while (j < length) {
                interfaces[j].tagBits &= 0xFFFFF7FF;
                ++j;
            }
            ++i;
        }
    }

    private void computeMethods() {
        MethodBinding[] methods = this.type.methods();
        int size = methods.length;
        this.currentMethods = new HashtableOfObject(size == 0 ? 1 : size);
        int m = size;
        while (--m >= 0) {
            MethodBinding method = methods[m];
            if (method.isConstructor() || method.isDefaultAbstract()) continue;
            MethodBinding[] existingMethods = (MethodBinding[])this.currentMethods.get(method.selector);
            if (existingMethods == null) {
                existingMethods = new MethodBinding[1];
            } else {
                MethodBinding[] methodBindingArray = existingMethods;
                existingMethods = new MethodBinding[existingMethods.length + 1];
                System.arraycopy(methodBindingArray, 0, existingMethods, 0, existingMethods.length - 1);
            }
            existingMethods[existingMethods.length - 1] = method;
            this.currentMethods.put(method.selector, existingMethods);
        }
    }

    private ReferenceBinding errorException() {
        if (this.errorException == null) {
            this.errorException = this.type.scope.getJavaLangError();
        }
        return this.errorException;
    }

    private boolean isAsVisible(MethodBinding newMethod, MethodBinding inheritedMethod) {
        if (inheritedMethod.modifiers == newMethod.modifiers) {
            return true;
        }
        if (newMethod.isPublic()) {
            return true;
        }
        if (inheritedMethod.isPublic()) {
            return false;
        }
        if (newMethod.isProtected()) {
            return true;
        }
        if (inheritedMethod.isProtected()) {
            return false;
        }
        return !newMethod.isPrivate();
    }

    private boolean isSameClassOrSubclassOf(ReferenceBinding testClass, ReferenceBinding superclass) {
        do {
            if (testClass != superclass) continue;
            return true;
        } while ((testClass = testClass.superclass()) != null);
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean mustImplementAbstractMethod(MethodBinding abstractMethod) {
        block4: {
            block3: {
                superclass = this.type.superclass();
                declaringClass = abstractMethod.declaringClass;
                if (!declaringClass.isClass()) break block3;
                while (superclass.isAbstract() && superclass != declaringClass) {
                    superclass = superclass.superclass();
                }
                break block4;
            }
            if (!this.type.implementsInterface(declaringClass, false)) ** GOTO lbl15
            if (this.type.isAbstract()) {
                return false;
            }
            if (superclass.implementsInterface(declaringClass, true)) ** GOTO lbl15
            return true;
lbl-1000:
            // 1 sources

            {
                superclass = superclass.superclass();
lbl15:
                // 3 sources

                ** while (superclass.isAbstract() && !superclass.implementsInterface((ReferenceBinding)declaringClass, (boolean)false))
            }
        }
        return superclass.isAbstract();
    }

    private ProblemReporter problemReporter() {
        return this.type.scope.problemReporter();
    }

    private ProblemReporter problemReporter(MethodBinding currentMethod) {
        ProblemReporter reporter = this.problemReporter();
        if (currentMethod.declaringClass == this.type) {
            reporter.referenceContext = currentMethod.sourceMethod();
        }
        return reporter;
    }

    private ReferenceBinding runtimeException() {
        if (this.runtimeException == null) {
            this.runtimeException = this.type.scope.getJavaLangRuntimeException();
        }
        return this.runtimeException;
    }

    public void verify(SourceTypeBinding someType) {
        this.type = someType;
        this.computeMethods();
        this.computeInheritedMethods();
        this.checkMethods();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(10);
        buffer.append("MethodVerifier for type: ");
        buffer.append(this.type.readableName());
        buffer.append('\n');
        buffer.append("\t-inherited methods: ");
        buffer.append(this.inheritedMethods);
        return buffer.toString();
    }
}

