/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class Argument
extends LocalDeclaration {
    private static final char[] SET = "set".toCharArray();

    public Argument(char[] name, long posNom, TypeReference tr, int modifiers) {
        super(null, name, (int)(posNom >>> 32), (int)posNom);
        this.declarationSourceEnd = (int)posNom;
        this.modifiers = modifiers;
        this.type = tr;
        this.bits |= 0x40000000;
    }

    public void bind(MethodScope scope, TypeBinding typeBinding, boolean used) {
        if (this.type != null) {
            this.type.resolvedType = typeBinding;
        }
        int modifierFlag = this.modifiers;
        Binding existingVariable = scope.getBinding(this.name, 3, (InvocationSite)this);
        if (existingVariable != null && existingVariable.isValidBinding()) {
            if (existingVariable instanceof LocalVariableBinding && this.hiddenVariableDepth == 0) {
                scope.problemReporter().redefineArgument(this);
                return;
            }
            boolean isSpecialArgument = false;
            if (existingVariable instanceof FieldBinding) {
                if (scope.isInsideConstructor()) {
                    isSpecialArgument = true;
                } else {
                    AbstractMethodDeclaration methodDecl = scope.referenceMethod();
                    if (methodDecl != null && CharOperation.prefixEquals(SET, methodDecl.selector)) {
                        isSpecialArgument = true;
                    }
                }
            }
            scope.problemReporter().localVariableHiding(this, existingVariable, isSpecialArgument);
        }
        this.binding = new LocalVariableBinding(this, typeBinding, modifierFlag, true);
        scope.addLocalVariable(this.binding);
        if (typeBinding != null && this.isTypeUseDeprecated(typeBinding, scope)) {
            scope.problemReporter().deprecatedType(typeBinding, this.type);
        }
        this.binding.declaration = this;
        this.binding.useFlag = used ? 1 : 0;
    }

    public TypeBinding resolveForCatch(BlockScope scope) {
        TypeBinding tb = this.type.resolveTypeExpecting(scope, scope.getJavaLangThrowable());
        if (tb == null) {
            return null;
        }
        Binding existingVariable = scope.getBinding(this.name, 3, (InvocationSite)this);
        if (existingVariable != null && existingVariable.isValidBinding()) {
            if (existingVariable instanceof LocalVariableBinding && this.hiddenVariableDepth == 0) {
                scope.problemReporter().redefineArgument(this);
                return null;
            }
            scope.problemReporter().localVariableHiding(this, existingVariable, false);
        }
        this.binding = new LocalVariableBinding(this, tb, this.modifiers, false);
        scope.addLocalVariable(this.binding);
        this.binding.constant = AstNode.NotAConstant;
        return tb;
    }

    public String toString(int tab) {
        String s = "";
        if (this.modifiers != 0) {
            s = String.valueOf(s) + AstNode.modifiersString(this.modifiers);
        }
        s = this.type == null ? String.valueOf(s) + "<no type> " : String.valueOf(s) + this.type.toString(tab) + " ";
        s = String.valueOf(s) + new String(this.name);
        return s;
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.type != null) {
                this.type.traverse(visitor, scope);
            }
            if (this.initialization != null) {
                this.initialization.traverse(visitor, scope);
            }
        }
        visitor.endVisit(this, scope);
    }
}

