/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;

public class CompilationResult {
    public IProblem[] problems;
    public IProblem[] tasks;
    public int problemCount;
    public int taskCount;
    public ICompilationUnit compilationUnit;
    private Map problemsMap;
    private Map firstErrorsMap;
    private int maxProblemPerUnit;
    public char[][][] qualifiedReferences;
    public char[][] simpleNameReferences;
    public int[] lineSeparatorPositions;
    public Hashtable compiledTypes = new Hashtable(11);
    public int unitIndex;
    public int totalUnitsKnown;
    public boolean hasBeenAccepted = false;
    public char[] fileName;

    public CompilationResult(char[] fileName, int unitIndex, int totalUnitsKnown, int maxProblemPerUnit) {
        this.fileName = fileName;
        this.unitIndex = unitIndex;
        this.totalUnitsKnown = totalUnitsKnown;
        this.maxProblemPerUnit = maxProblemPerUnit;
    }

    public CompilationResult(ICompilationUnit compilationUnit, int unitIndex, int totalUnitsKnown, int maxProblemPerUnit) {
        this.fileName = compilationUnit.getFileName();
        this.compilationUnit = compilationUnit;
        this.unitIndex = unitIndex;
        this.totalUnitsKnown = totalUnitsKnown;
        this.maxProblemPerUnit = maxProblemPerUnit;
    }

    private int computePriority(IProblem problem) {
        ReferenceContext context;
        int priority = 1000 - problem.getSourceLineNumber();
        if (priority < 0) {
            priority = 0;
        }
        if (problem.isError()) {
            priority += 10000;
        }
        ReferenceContext referenceContext = context = this.problemsMap == null ? null : (ReferenceContext)this.problemsMap.get(problem);
        if (context != null) {
            if (context instanceof AbstractMethodDeclaration) {
                AbstractMethodDeclaration method = (AbstractMethodDeclaration)context;
                if (method.isStatic()) {
                    priority += 1000;
                }
            } else {
                priority += 4000;
            }
        } else {
            priority += 4000;
        }
        if (this.firstErrorsMap.containsKey(problem)) {
            priority += 2000;
        }
        return priority;
    }

    public IProblem[] getAllProblems() {
        int onlyTaskCount;
        IProblem[] onlyProblems = this.getProblems();
        int onlyProblemCount = onlyProblems != null ? onlyProblems.length : 0;
        IProblem[] onlyTasks = this.getTasks();
        int n = onlyTaskCount = onlyTasks != null ? onlyTasks.length : 0;
        if (onlyTaskCount == 0) {
            return onlyProblems;
        }
        if (onlyProblemCount == 0) {
            return onlyTasks;
        }
        int totalNumberOfProblem = onlyProblemCount + onlyTaskCount;
        IProblem[] allProblems = new IProblem[totalNumberOfProblem];
        int allProblemIndex = 0;
        int taskIndex = 0;
        int problemIndex = 0;
        while (taskIndex + problemIndex < totalNumberOfProblem) {
            IProblem nextTask = null;
            IProblem nextProblem = null;
            if (taskIndex < onlyTaskCount) {
                nextTask = onlyTasks[taskIndex];
            }
            if (problemIndex < onlyProblemCount) {
                nextProblem = onlyProblems[problemIndex];
            }
            IProblem currentProblem = null;
            if (nextProblem != null) {
                if (nextTask != null) {
                    if (nextProblem.getSourceStart() < nextTask.getSourceStart()) {
                        currentProblem = nextProblem;
                        ++problemIndex;
                    } else {
                        currentProblem = nextTask;
                        ++taskIndex;
                    }
                } else {
                    currentProblem = nextProblem;
                    ++problemIndex;
                }
            } else if (nextTask != null) {
                currentProblem = nextTask;
                ++taskIndex;
            }
            allProblems[allProblemIndex++] = currentProblem;
        }
        return allProblems;
    }

    public ClassFile[] getClassFiles() {
        Enumeration enumeration = this.compiledTypes.elements();
        ClassFile[] classFiles = new ClassFile[this.compiledTypes.size()];
        int index = 0;
        while (enumeration.hasMoreElements()) {
            classFiles[index++] = (ClassFile)enumeration.nextElement();
        }
        return classFiles;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public char[] getFileName() {
        return this.fileName;
    }

    public IProblem[] getErrors() {
        IProblem[] reportedProblems = this.getProblems();
        int errorCount = 0;
        int i = 0;
        while (i < this.problemCount) {
            if (reportedProblems[i].isError()) {
                ++errorCount;
            }
            ++i;
        }
        if (errorCount == this.problemCount) {
            return reportedProblems;
        }
        IProblem[] errors = new IProblem[errorCount];
        int index = 0;
        int i2 = 0;
        while (i2 < this.problemCount) {
            if (reportedProblems[i2].isError()) {
                errors[index++] = reportedProblems[i2];
            }
            ++i2;
        }
        return errors;
    }

    public IProblem[] getProblems() {
        if (this.problems != null) {
            if (this.problemCount != this.problems.length) {
                this.problems = new IProblem[this.problemCount];
                System.arraycopy(this.problems, 0, this.problems, 0, this.problemCount);
            }
            if (this.maxProblemPerUnit > 0 && this.problemCount > this.maxProblemPerUnit) {
                this.quickPrioritize(this.problems, 0, this.problemCount - 1);
                this.problemCount = this.maxProblemPerUnit;
                this.problems = new IProblem[this.problemCount];
                System.arraycopy(this.problems, 0, this.problems, 0, this.problemCount);
            }
            CompilationResult.quickSort(this.problems, 0, this.problems.length - 1);
        }
        return this.problems;
    }

    public IProblem[] getTasks() {
        if (this.tasks != null) {
            if (this.taskCount != this.tasks.length) {
                this.tasks = new IProblem[this.taskCount];
                System.arraycopy(this.tasks, 0, this.tasks, 0, this.taskCount);
            }
            CompilationResult.quickSort(this.tasks, 0, this.tasks.length - 1);
        }
        return this.tasks;
    }

    public boolean hasErrors() {
        if (this.problems != null) {
            int i = 0;
            while (i < this.problemCount) {
                if (this.problems[i].isError()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean hasProblems() {
        return this.problemCount != 0;
    }

    public boolean hasSyntaxError() {
        if (this.problems != null) {
            int i = 0;
            while (i < this.problemCount) {
                IProblem problem = this.problems[i];
                if ((problem.getID() & 0x40000000) != 0 && problem.isError()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean hasTasks() {
        return this.taskCount != 0;
    }

    public boolean hasWarnings() {
        if (this.problems != null) {
            int i = 0;
            while (i < this.problemCount) {
                if (this.problems[i].isWarning()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static void quickSort(IProblem[] list, int left, int right) {
        if (left >= right) {
            return;
        }
        int original_left = left;
        int original_right = right;
        int mid = list[(left + right) / 2].getSourceStart();
        while (true) {
            if (list[left].getSourceStart() < mid) {
                ++left;
                continue;
            }
            while (mid < list[right].getSourceStart()) {
                --right;
            }
            if (left <= right) {
                IProblem tmp = list[left];
                list[left] = list[right];
                list[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            CompilationResult.quickSort(list, original_left, right);
        }
        if (left < original_right) {
            CompilationResult.quickSort(list, left, original_right);
        }
    }

    private void quickPrioritize(IProblem[] list, int left, int right) {
        if (left >= right) {
            return;
        }
        int original_left = left;
        int original_right = right;
        int mid = this.computePriority(list[(left + right) / 2]);
        while (true) {
            if (this.computePriority(list[right]) < mid) {
                --right;
                continue;
            }
            while (mid < this.computePriority(list[left])) {
                ++left;
            }
            if (left <= right) {
                IProblem tmp = list[left];
                list[left] = list[right];
                list[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            this.quickPrioritize(list, original_left, right);
        }
        if (left < original_right) {
            this.quickPrioritize(list, left, original_right);
        }
    }

    public void record(char[] typeName, ClassFile classFile) {
        this.compiledTypes.put(typeName, classFile);
    }

    public void record(IProblem newProblem, ReferenceContext referenceContext) {
        if (newProblem.getID() == 536871362) {
            this.recordTask(newProblem);
            return;
        }
        if (this.problemCount == 0) {
            this.problems = new IProblem[5];
        } else if (this.problemCount == this.problems.length) {
            this.problems = new IProblem[this.problemCount * 2];
            System.arraycopy(this.problems, 0, this.problems, 0, this.problemCount);
        }
        this.problems[this.problemCount++] = newProblem;
        if (referenceContext != null) {
            if (this.problemsMap == null) {
                this.problemsMap = new Hashtable(5);
            }
            if (this.firstErrorsMap == null) {
                this.firstErrorsMap = new Hashtable(5);
            }
            if (newProblem.isError() && !referenceContext.hasErrors()) {
                this.firstErrorsMap.put(newProblem, newProblem);
            }
            this.problemsMap.put(newProblem, referenceContext);
        }
    }

    private void recordTask(IProblem newProblem) {
        if (this.taskCount == 0) {
            this.tasks = new IProblem[5];
        } else if (this.taskCount == this.tasks.length) {
            this.tasks = new IProblem[this.taskCount * 2];
            System.arraycopy(this.tasks, 0, this.tasks, 0, this.taskCount);
        }
        this.tasks[this.taskCount++] = newProblem;
    }

    public CompilationResult tagAsAccepted() {
        this.hasBeenAccepted = true;
        this.problemsMap = null;
        return this;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.fileName != null) {
            buffer.append("Filename : ").append(this.fileName).append('\n');
        }
        if (this.compiledTypes != null) {
            buffer.append("COMPILED type(s)\t\n");
            Enumeration typeNames = this.compiledTypes.keys();
            while (typeNames.hasMoreElements()) {
                char[] typeName = (char[])typeNames.nextElement();
                buffer.append("\t - ").append(typeName).append('\n');
            }
        } else {
            buffer.append("No COMPILED type\n");
        }
        if (this.problems != null) {
            buffer.append(this.problemCount).append(" PROBLEM(s) detected \n");
            int i = 0;
            while (i < this.problemCount) {
                buffer.append("\t - ").append(this.problems[i]).append('\n');
                ++i;
            }
        } else {
            buffer.append("No PROBLEM\n");
        }
        return buffer.toString();
    }
}

