/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;

public class QualifiedName
extends Name {
    private Name qualifier = null;
    private SimpleName name = null;

    QualifiedName(AST ast) {
        super(ast);
    }

    public int getNodeType() {
        return 40;
    }

    ASTNode clone(AST target) {
        QualifiedName result = new QualifiedName(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setQualifier((Name)this.getQualifier().clone(target));
        result.setName((SimpleName)this.getName().clone(target));
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getQualifier());
            this.acceptChild(visitor, this.getName());
        }
        visitor.endVisit(this);
    }

    public Name getQualifier() {
        if (this.qualifier == null) {
            long count = this.getAST().modificationCount();
            this.setQualifier(new SimpleName(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.qualifier;
    }

    public void setQualifier(Name qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.qualifier, qualifier, true);
        this.qualifier = qualifier;
    }

    public SimpleName getName() {
        if (this.name == null) {
            long count = this.getAST().modificationCount();
            this.setName(new SimpleName(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.name;
    }

    public void setName(SimpleName name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.name, name, false);
        this.name = name;
    }

    int memSize() {
        return 48;
    }

    int treeSize() {
        return this.memSize() + (this.name == null ? 0 : this.getName().treeSize()) + (this.qualifier == null ? 0 : this.getQualifier().treeSize());
    }
}

