/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jdbc.BaseWrapperManagedConnection;
import org.jboss.resource.adapter.jdbc.WrappedCallableStatement;
import org.jboss.resource.adapter.jdbc.WrappedPreparedStatement;
import org.jboss.resource.adapter.jdbc.WrappedStatement;

public class WrappedConnection
implements Connection {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$resource$adapter$jdbc$WrappedConnection == null ? (class$org$jboss$resource$adapter$jdbc$WrappedConnection = WrappedConnection.class$("org.jboss.resource.adapter.jdbc.WrappedConnection")) : class$org$jboss$resource$adapter$jdbc$WrappedConnection));
    private BaseWrapperManagedConnection mc;
    private HashMap statements;
    private boolean closed = false;
    private int trackStatements;
    static /* synthetic */ Class class$org$jboss$resource$adapter$jdbc$WrappedConnection;

    public WrappedConnection(BaseWrapperManagedConnection mc) {
        this.mc = mc;
        if (mc != null) {
            this.trackStatements = mc.getTrackStatements();
        }
    }

    void setManagedConnection(BaseWrapperManagedConnection mc) {
        this.mc = mc;
        if (mc != null) {
            this.trackStatements = mc.getTrackStatements();
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkStatus();
        this.mc.setJdbcReadOnly(readOnly);
    }

    public boolean isReadOnly() throws SQLException {
        this.checkStatus();
        return this.mc.isJdbcReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        this.closed = true;
        if (this.mc != null) {
            if (this.trackStatements != 0) {
                WrappedConnection wrappedConnection = this;
                synchronized (wrappedConnection) {
                    if (this.statements != null) {
                        Iterator i = this.statements.entrySet().iterator();
                        while (i.hasNext()) {
                            Map.Entry entry = i.next();
                            WrappedStatement ws = (WrappedStatement)entry.getKey();
                            if (this.trackStatements == 1) {
                                Exception stackTrace = (Exception)entry.getValue();
                                log.warn((Object)"Closing a statement you left open, please do your own housekeeping", (Throwable)stackTrace);
                            }
                            try {
                                ws.internalClose();
                            }
                            catch (Throwable t) {
                                log.warn((Object)"Exception trying to close statement:", t);
                            }
                        }
                    }
                }
            }
            this.mc.closeHandle(this);
        }
        this.mc = null;
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public Statement createStatement() throws SQLException {
        this.checkTransaction();
        try {
            return new WrappedStatement(this, this.mc.getConnection().createStatement());
        }
        catch (SQLException e) {
            this.checkException(e);
            return null;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkTransaction();
        try {
            return new WrappedStatement(this, this.mc.getConnection().createStatement(resultSetType, resultSetConcurrency));
        }
        catch (SQLException e) {
            this.checkException(e);
            return null;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkTransaction();
        try {
            return new WrappedStatement(this, this.mc.getConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (SQLException e) {
            this.checkException(e);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkTransaction();
        try {
            return new WrappedPreparedStatement(this, this.mc.prepareStatement(sql));
        }
        catch (SQLException e) {
            this.checkException(e);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkTransaction();
        try {
            return new WrappedPreparedStatement(this, this.mc.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency));
        }
        catch (SQLException e) {
            this.checkException(e);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkTransaction();
        try {
            return new WrappedPreparedStatement(this, this.mc.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (SQLException e) {
            this.checkException(e);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkTransaction();
        try {
            return new WrappedPreparedStatement(this, this.mc.getConnection().prepareStatement(sql, autoGeneratedKeys));
        }
        catch (SQLException e) {
            this.checkException(e);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkTransaction();
        try {
            return new WrappedPreparedStatement(this, this.mc.getConnection().prepareStatement(sql, columnIndexes));
        }
        catch (SQLException e) {
            this.checkException(e);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkTransaction();
        try {
            return new WrappedPreparedStatement(this, this.mc.getConnection().prepareStatement(sql, columnNames));
        }
        catch (SQLException e) {
            this.checkException(e);
            return null;
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkTransaction();
        try {
            return new WrappedCallableStatement(this, this.mc.getConnection().prepareCall(sql));
        }
        catch (SQLException e) {
            this.checkException(e);
            return null;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkTransaction();
        try {
            return new WrappedCallableStatement(this, this.mc.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency));
        }
        catch (SQLException e) {
            this.checkException(e);
            return null;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkTransaction();
        try {
            return new WrappedCallableStatement(this, this.mc.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (SQLException e) {
            this.checkException(e);
            return null;
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        this.checkTransaction();
        try {
            return this.mc.getConnection().nativeSQL(sql);
        }
        catch (SQLException e) {
            this.checkException(e);
            return null;
        }
    }

    public void setAutoCommit(boolean autocommit) throws SQLException {
        this.checkStatus();
        this.mc.setJdbcAutoCommit(autocommit);
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkStatus();
        return this.mc.isJdbcAutoCommit();
    }

    public void commit() throws SQLException {
        this.checkTransaction();
        this.mc.jdbcCommit();
    }

    public void rollback() throws SQLException {
        this.checkTransaction();
        this.mc.jdbcRollback();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkTransaction();
        this.mc.jdbcRollback(savepoint);
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkTransaction();
        try {
            return this.mc.getConnection().getMetaData();
        }
        catch (SQLException e) {
            this.checkException(e);
            return null;
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        this.checkTransaction();
        try {
            this.mc.getConnection().setCatalog(catalog);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public String getCatalog() throws SQLException {
        this.checkTransaction();
        try {
            return this.mc.getConnection().getCatalog();
        }
        catch (SQLException e) {
            this.checkException(e);
            return null;
        }
    }

    public void setTransactionIsolation(int isolationLevel) throws SQLException {
        this.checkStatus();
        this.mc.setJdbcTransactionIsolation(isolationLevel);
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkStatus();
        return this.mc.getJdbcTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkTransaction();
        return this.mc.getConnection().getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.checkTransaction();
        this.mc.getConnection().clearWarnings();
    }

    public Map getTypeMap() throws SQLException {
        this.checkTransaction();
        try {
            return this.mc.getConnection().getTypeMap();
        }
        catch (SQLException e) {
            this.checkException(e);
            return null;
        }
    }

    public void setTypeMap(Map typeMap) throws SQLException {
        this.checkTransaction();
        try {
            this.mc.getConnection().setTypeMap(typeMap);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setHoldability(int holdability) throws SQLException {
        this.checkTransaction();
        try {
            this.mc.getConnection().setHoldability(holdability);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public int getHoldability() throws SQLException {
        this.checkTransaction();
        try {
            return this.mc.getConnection().getHoldability();
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        this.checkTransaction();
        try {
            return this.mc.getConnection().setSavepoint();
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkTransaction();
        try {
            return this.mc.getConnection().setSavepoint(name);
        }
        catch (SQLException e) {
            this.checkException(e);
            throw e;
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkTransaction();
        try {
            this.mc.getConnection().releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public Connection getUnderlyingConnection() throws SQLException {
        this.checkTransaction();
        return this.mc.getConnection();
    }

    void checkTransaction() throws SQLException {
        this.checkStatus();
        this.mc.checkTransaction();
    }

    protected void checkStatus() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection handle has been closed and is unusable");
        }
        if (this.mc == null) {
            throw new SQLException("Connection handle is not currently associated with a ManagedConnection");
        }
    }

    protected void checkException(SQLException e) throws SQLException {
        if (this.mc != null) {
            this.mc.connectionError(e);
        }
        throw e;
    }

    int getTrackStatements() {
        return this.trackStatements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerStatement(WrappedStatement ws) {
        if (this.trackStatements == 0) {
            return;
        }
        WrappedConnection wrappedConnection = this;
        synchronized (wrappedConnection) {
            if (this.statements == null) {
                this.statements = new HashMap();
            }
            this.statements.put(ws, new Exception("STACKTRACE"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterStatement(WrappedStatement ws) {
        if (this.trackStatements == 0) {
            return;
        }
        WrappedConnection wrappedConnection = this;
        synchronized (wrappedConnection) {
            if (this.statements != null) {
                this.statements.remove(ws);
            }
        }
    }

    Logger getLogger() {
        return log;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

