/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import java.util.Properties;

public class ObjectUtil {
    private static Class identityHashMapClass = null;
    private static final char[] lookup = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static final String readURL(String url) throws IOException {
        String token = "file://";
        String line = "";
        InputStreamReader isr = null;
        if (url.startsWith(token)) {
            try {
                isr = new FileReader(url.substring(token.length()));
            }
            catch (Exception e) {
                System.out.println("Tried and failed to open file: " + url.substring(token.length()));
            }
        }
        if (isr == null) {
            URL u = new URL(url);
            isr = new InputStreamReader(u.openStream());
        }
        BufferedReader in = new BufferedReader(isr);
        line = in.readLine();
        in.close();
        return line;
    }

    public static Class classForName(String name) throws ClassNotFoundException, IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Class name must not be null!");
        }
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (Exception e) {
            return Class.forName(name);
        }
    }

    public static Map createIdentityHashMap() {
        if (identityHashMapClass == null) {
            try {
                identityHashMapClass = ObjectUtil.classForName("java.util.IdentityHashMap");
            }
            catch (ClassNotFoundException ex) {
                try {
                    identityHashMapClass = ObjectUtil.classForName("org.jacorb.util.IdentityHashMap");
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e.toString());
                }
            }
        }
        try {
            return (Map)identityHashMapClass.newInstance();
        }
        catch (Exception exc) {
            throw new RuntimeException(exc.toString());
        }
    }

    public static synchronized String bufToString(byte[] bs, int start, int len) {
        StringBuffer result = new StringBuffer();
        StringBuffer chars = new StringBuffer();
        for (int i = start; i < start + len; ++i) {
            if (i % 16 == 0) {
                result.append(chars.toString());
                chars = new StringBuffer();
            }
            chars.append(ObjectUtil.toAscii(bs[i]));
            result.append(ObjectUtil.toHex(bs[i]));
            if (i % 4 != 3) continue;
            chars.append(' ');
            result.append(' ');
        }
        if (len % 16 != 0) {
            int pad = 0;
            int delta_bytes = 16 - len % 16;
            pad = delta_bytes * 3;
            pad += delta_bytes / 4;
            for (int i = 0; i < pad; ++i) {
                chars.insert(0, ' ');
            }
        }
        result.append(chars.toString());
        return result.toString();
    }

    public static final String toHex(byte b) {
        StringBuffer sb = new StringBuffer();
        int upper = b >> 4 & 0xF;
        sb.append(lookup[upper]);
        int lower = b & 0xF;
        sb.append(lookup[lower]);
        sb.append(' ');
        return sb.toString();
    }

    public static final char toAscii(byte b) {
        if (b > 31 && b < 127) {
            return (char)b;
        }
        return '.';
    }

    public static Properties argsToProps(String[] args) {
        Properties props = new Properties();
        for (int i = 0; i < args.length; ++i) {
            int idx;
            if (!args[i].startsWith("-D") || (idx = args[i].indexOf(61)) < 3) continue;
            String key = args[i].substring(2, idx);
            System.out.println("putting: " + key + "," + args[i].substring(idx + 1));
            props.put(key, args[i].substring(idx + 1));
        }
        return props;
    }
}

