/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.impl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jacorb.trading.constraint.Constraint;
import org.jacorb.trading.constraint.ParseException;
import org.jacorb.trading.db.OfferDatabase;
import org.jacorb.trading.impl.OfferUtil;
import org.jacorb.trading.impl.SchemaAdapter;
import org.jacorb.trading.impl.SourceAdapter;
import org.jacorb.trading.impl.SupportAttrib;
import org.jacorb.trading.impl.TraderComp;
import org.omg.CORBA.Contained;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.Object;
import org.omg.CORBA.Repository;
import org.omg.CORBA.SystemException;
import org.omg.CosTrading.Admin;
import org.omg.CosTrading.DuplicatePropertyName;
import org.omg.CosTrading.IllegalConstraint;
import org.omg.CosTrading.IllegalOfferId;
import org.omg.CosTrading.IllegalPropertyName;
import org.omg.CosTrading.IllegalServiceType;
import org.omg.CosTrading.Link;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.MissingMandatoryProperty;
import org.omg.CosTrading.NotImplemented;
import org.omg.CosTrading.Property;
import org.omg.CosTrading.PropertyTypeMismatch;
import org.omg.CosTrading.Proxy;
import org.omg.CosTrading.ReadonlyDynamicProperty;
import org.omg.CosTrading.Register;
import org.omg.CosTrading.RegisterPOA;
import org.omg.CosTrading.RegisterPackage.IllegalTraderName;
import org.omg.CosTrading.RegisterPackage.InterfaceTypeMismatch;
import org.omg.CosTrading.RegisterPackage.InvalidObjectRef;
import org.omg.CosTrading.RegisterPackage.MandatoryProperty;
import org.omg.CosTrading.RegisterPackage.NoMatchingOffers;
import org.omg.CosTrading.RegisterPackage.OfferInfo;
import org.omg.CosTrading.RegisterPackage.ProxyOfferId;
import org.omg.CosTrading.RegisterPackage.ReadonlyProperty;
import org.omg.CosTrading.RegisterPackage.RegisterNotSupported;
import org.omg.CosTrading.RegisterPackage.UnknownPropertyName;
import org.omg.CosTrading.RegisterPackage.UnknownTraderName;
import org.omg.CosTrading.UnknownOfferId;
import org.omg.CosTrading.UnknownServiceType;
import org.omg.CosTradingRepos.ServiceTypeRepository;
import org.omg.CosTradingRepos.ServiceTypeRepositoryHelper;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropStruct;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.TypeStruct;

public class RegisterImpl
extends RegisterPOA {
    private TraderComp m_traderComp;
    private SupportAttrib m_support;
    private OfferDatabase m_db;
    private ServiceTypeRepository m_repos;
    private Repository m_interfaceRepos;

    private RegisterImpl() {
    }

    public RegisterImpl(TraderComp traderComp, SupportAttrib supportAttrib, OfferDatabase db, Repository interfaceRepos) {
        this.m_traderComp = traderComp;
        this.m_support = supportAttrib;
        this.m_db = db;
        this.m_interfaceRepos = interfaceRepos;
        Object obj = supportAttrib.getTypeRepos();
        this.m_repos = ServiceTypeRepositoryHelper.narrow(obj);
    }

    public Lookup lookup_if() {
        return this.m_traderComp.getLookupInterface();
    }

    public Register register_if() {
        return this.m_traderComp.getRegisterInterface();
    }

    public Link link_if() {
        return this.m_traderComp.getLinkInterface();
    }

    public Proxy proxy_if() {
        return this.m_traderComp.getProxyInterface();
    }

    public Admin admin_if() {
        return this.m_traderComp.getAdminInterface();
    }

    public boolean supports_modifiable_properties() {
        return this.m_support.getModifiableProperties();
    }

    public boolean supports_dynamic_properties() {
        return this.m_support.getDynamicProperties();
    }

    public boolean supports_proxy_offers() {
        return this.m_support.getProxyOffers();
    }

    public Object type_repos() {
        return this.m_support.getTypeRepos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String export(Object reference, String type, Property[] properties) throws InvalidObjectRef, IllegalServiceType, UnknownServiceType, InterfaceTypeMismatch, IllegalPropertyName, PropertyTypeMismatch, ReadonlyDynamicProperty, MissingMandatoryProperty, DuplicatePropertyName {
        String result = null;
        if (reference == null) {
            throw new InvalidObjectRef(reference);
        }
        TypeStruct ts = this.m_repos.fully_describe_type(type);
        if (ts.masked) {
            throw new UnknownServiceType(type);
        }
        this.validateInterface(reference, type, ts);
        OfferUtil.validateProperties(this.m_db, properties, type, ts);
        this.m_db.begin(1);
        try {
            result = this.m_db.create(type, reference, properties);
        }
        finally {
            this.m_db.end();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withdraw(String id) throws IllegalOfferId, UnknownOfferId, ProxyOfferId {
        if (!this.m_db.validateOfferId(id)) {
            throw new IllegalOfferId(id);
        }
        this.m_db.begin(1);
        try {
            if (!this.m_db.exists(id)) {
                throw new UnknownOfferId(id);
            }
            if (this.m_db.isProxy(id)) {
                throw new ProxyOfferId(id);
            }
            this.m_db.remove(id);
        }
        finally {
            this.m_db.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OfferInfo describe(String id) throws IllegalOfferId, UnknownOfferId, ProxyOfferId {
        OfferInfo result;
        if (!this.m_db.validateOfferId(id)) {
            throw new IllegalOfferId(id);
        }
        this.m_db.begin(0);
        try {
            if (!this.m_db.exists(id)) {
                throw new UnknownOfferId(id);
            }
            if (this.m_db.isProxy(id)) {
                throw new ProxyOfferId(id);
            }
            result = this.m_db.describe(id);
        }
        finally {
            this.m_db.end();
        }
        return result;
    }

    public void modify(String id, String[] del_list, Property[] modify_list) throws NotImplemented, IllegalOfferId, UnknownOfferId, ProxyOfferId, IllegalPropertyName, UnknownPropertyName, PropertyTypeMismatch, ReadonlyDynamicProperty, MandatoryProperty, ReadonlyProperty, DuplicatePropertyName {
        if (!this.m_support.getModifiableProperties()) {
            throw new NotImplemented();
        }
        if (!this.m_db.validateOfferId(id)) {
            throw new IllegalOfferId(id);
        }
        try {
            int i;
            this.m_db.begin(1);
            if (!this.m_db.exists(id)) {
                throw new UnknownOfferId(id);
            }
            if (this.m_db.isProxy(id)) {
                throw new ProxyOfferId(id);
            }
            String type = this.m_db.whichService(id);
            TypeStruct ts = this.m_repos.fully_describe_type(type);
            OfferInfo info = this.m_db.describe(id);
            this.checkDelete(del_list, type, ts, info);
            this.checkModify(modify_list, type, ts, info);
            Vector<Property> props = new Vector<Property>();
            for (i = 0; i < modify_list.length; ++i) {
                props.addElement(modify_list[i]);
            }
            for (i = 0; i < info.properties.length; ++i) {
                boolean found = false;
                for (int d = 0; d < del_list.length && !found; ++d) {
                    if (!info.properties[i].name.equals(del_list[d])) continue;
                    found = true;
                }
                Enumeration e = props.elements();
                while (e.hasMoreElements() && !found) {
                    Property p = (Property)e.nextElement();
                    if (!info.properties[i].name.equals(p.name)) continue;
                    found = true;
                }
                if (found) continue;
                props.addElement(info.properties[i]);
            }
            Property[] arr = new Property[props.size()];
            props.copyInto(arr);
            this.m_db.modify(id, arr);
        }
        catch (IllegalServiceType e) {
            throw new UnknownOfferId(id);
        }
        catch (UnknownServiceType e) {
            throw new UnknownOfferId(id);
        }
        finally {
            this.m_db.end();
        }
    }

    public void withdraw_using_constraint(String type, String constr) throws IllegalServiceType, UnknownServiceType, IllegalConstraint, NoMatchingOffers {
        TypeStruct ts = this.m_repos.fully_describe_type(type);
        SchemaAdapter schema = new SchemaAdapter(ts);
        Constraint c = new Constraint(schema);
        int count = 0;
        try {
            this.m_db.begin(1);
            c.parse(constr);
            Hashtable offers = this.m_db.getOffers(type);
            if (offers != null) {
                Enumeration e = offers.keys();
                while (e.hasMoreElements()) {
                    String id = (String)e.nextElement();
                    OfferInfo info = (OfferInfo)offers.get(id);
                    SourceAdapter source = new SourceAdapter(info.reference, info.properties);
                    if (!c.evaluate(source)) continue;
                    this.m_db.remove(id);
                    ++count;
                }
            }
        }
        catch (ParseException ex) {
            System.out.println("Illegal constraint '" + constr + "'");
            System.out.println(ex.getMessage());
            throw new IllegalConstraint(constr);
        }
        finally {
            this.m_db.end();
        }
        if (count == 0) {
            throw new NoMatchingOffers(constr);
        }
    }

    public Register resolve(String[] name) throws IllegalTraderName, UnknownTraderName, RegisterNotSupported {
        throw new RegisterNotSupported(name);
    }

    protected void validateInterface(Object ref, String typeName, TypeStruct type) throws InterfaceTypeMismatch {
        if (this.m_interfaceRepos != null) {
            try {
                String id;
                InterfaceDef def = InterfaceDefHelper.narrow(ref._get_interface_def());
                Contained c = this.m_interfaceRepos.lookup(type.if_name);
                if (def != null && c != null && !def.is_a(id = c.id())) {
                    throw new InterfaceTypeMismatch(typeName, ref);
                }
            }
            catch (SystemException e) {
                // empty catch block
            }
        }
    }

    protected void checkDelete(String[] del_list, String typeName, TypeStruct type, OfferInfo info) throws IllegalPropertyName, UnknownPropertyName, MandatoryProperty, ReadonlyProperty, DuplicatePropertyName {
        Hashtable<String, Property> offerProps = new Hashtable<String, Property>();
        for (int i = 0; i < info.properties.length; ++i) {
            offerProps.put(info.properties[i].name, info.properties[i]);
        }
        Hashtable<String, PropStruct> typeProps = new Hashtable<String, PropStruct>();
        for (int i = 0; i < type.props.length; ++i) {
            typeProps.put(type.props[i].name, type.props[i]);
        }
        Hashtable<String, String> deletedProps = new Hashtable<String, String>();
        for (int i = 0; i < del_list.length; ++i) {
            String propName = del_list[i];
            if (deletedProps.containsKey(propName)) {
                throw new DuplicatePropertyName(propName);
            }
            deletedProps.put(propName, propName);
            Property prop = (Property)offerProps.get(propName);
            if (prop != null) {
                PropStruct ps = (PropStruct)typeProps.get(propName);
                if (ps == null || !OfferUtil.isMandatory(ps.mode)) continue;
                throw new MandatoryProperty(typeName, propName);
            }
            throw new UnknownPropertyName(propName);
        }
    }

    protected void checkModify(Property[] modify_list, String typeName, TypeStruct type, OfferInfo info) throws IllegalPropertyName, UnknownPropertyName, PropertyTypeMismatch, ReadonlyDynamicProperty, ReadonlyProperty, DuplicatePropertyName {
        Hashtable<String, Property> modProps = new Hashtable<String, Property>();
        for (int i = 0; i < modify_list.length; ++i) {
            modProps.put(modify_list[i].name, modify_list[i]);
        }
        Hashtable<String, Property> offerProps = new Hashtable<String, Property>();
        for (int i = 0; i < info.properties.length; ++i) {
            offerProps.put(info.properties[i].name, info.properties[i]);
        }
        Hashtable<String, PropStruct> typeProps = new Hashtable<String, PropStruct>();
        for (int i = 0; i < type.props.length; ++i) {
            typeProps.put(type.props[i].name, type.props[i]);
        }
        Hashtable<String, Property> checkedProps = new Hashtable<String, Property>();
        Enumeration e = modProps.elements();
        while (e.hasMoreElements()) {
            Property prop = (Property)e.nextElement();
            if (checkedProps.containsKey(prop.name)) {
                throw new DuplicatePropertyName(prop.name);
            }
            checkedProps.put(prop.name, prop);
            PropStruct ps = (PropStruct)typeProps.get(prop.name);
            if (ps == null) {
                throw new UnknownPropertyName(prop.name);
            }
            if (offerProps.containsKey(prop.name) && OfferUtil.isReadonly(ps.mode)) {
                throw new ReadonlyProperty(typeName, prop.name);
            }
            OfferUtil.checkProperty(typeName, prop, ps);
        }
    }
}

