/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import java.io.PrintStream;
import org.jacorb.trading.constraint.ExprNode;
import org.jacorb.trading.constraint.MissingPropertyException;
import org.jacorb.trading.constraint.PropertySource;
import org.jacorb.trading.constraint.Value;
import org.jacorb.trading.constraint.ValueFactory;
import org.jacorb.trading.constraint.ValueType;

public class LiteralNode
extends ExprNode {
    private Value m_value;
    public static final int BOOLEAN = 0;
    public static final int NUMBER = 1;
    public static final int STRING = 2;

    private LiteralNode() {
    }

    public LiteralNode(int literalType, String value) {
        this.determineType(literalType, value);
        switch (this.getType().getId()) {
            case 0: {
                this.m_value = ValueFactory.createBoolean(value.equals("TRUE"));
                break;
            }
            case 6: {
                try {
                    Double d = Double.valueOf(value);
                    this.m_value = ValueFactory.createDouble(d);
                }
                catch (NumberFormatException e) {}
                break;
            }
            case 3: {
                try {
                    Integer i = Integer.valueOf(value);
                    this.m_value = ValueFactory.createLong(i);
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 8: {
                this.m_value = ValueFactory.createString(value);
            }
        }
    }

    public void print(PrintStream ps) {
        ps.println("LiteralNode: type = " + this.getType() + " value = " + this.m_value);
    }

    public Value evaluate(PropertySource source) throws MissingPropertyException {
        return this.m_value;
    }

    protected void determineType(int literalType, String value) {
        if (literalType == 0) {
            this.setType(new ValueType(0));
        } else if (literalType == 2) {
            this.setType(new ValueType(8));
        } else if (value.indexOf(46) >= 0 || value.indexOf(69) >= 0 || value.indexOf(101) >= 0) {
            this.setType(new ValueType(6));
        } else {
            this.setType(new ValueType(3));
        }
    }
}

