/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.client.proxy;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Random;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CosTrading.DuplicatePolicyName;
import org.omg.CosTrading.DuplicatePropertyName;
import org.omg.CosTrading.IllegalPropertyName;
import org.omg.CosTrading.IllegalServiceType;
import org.omg.CosTrading.InvalidLookupRef;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.LookupHelper;
import org.omg.CosTrading.MissingMandatoryProperty;
import org.omg.CosTrading.Policy;
import org.omg.CosTrading.Property;
import org.omg.CosTrading.PropertyTypeMismatch;
import org.omg.CosTrading.Proxy;
import org.omg.CosTrading.ProxyPackage.IllegalRecipe;
import org.omg.CosTrading.ReadonlyDynamicProperty;
import org.omg.CosTrading.UnknownServiceType;
import org.omg.CosTradingRepos.ServiceTypeRepository;
import org.omg.CosTradingRepos.ServiceTypeRepositoryHelper;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropStruct;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropertyMode;

public class export {
    public static void main(String[] args) {
        File targetFile;
        if (args.length != 1) {
            export.usage();
        }
        if (!(targetFile = new File(args[0])).exists()) {
            System.err.println("File " + args[0] + " does not exist");
            export.usage();
        }
        if (!targetFile.isFile()) {
            System.err.println(args[0] + " is not a file");
            export.usage();
        }
        ORB orb = null;
        Proxy proxy = null;
        Lookup target = null;
        ServiceTypeRepository repos = null;
        try {
            Object obj = null;
            orb = ORB.init(args, null);
            obj = orb.resolve_initial_references("TradingService");
            if (obj == null) {
                System.out.println("Invalid lookup object");
                System.exit(1);
            }
            Lookup lookup = LookupHelper.narrow(obj);
            proxy = lookup.proxy_if();
            repos = ServiceTypeRepositoryHelper.narrow(lookup.type_repos());
            FileReader fr = new FileReader(targetFile);
            BufferedReader in = new BufferedReader(fr);
            String targetRef = in.readLine();
            fr.close();
            obj = orb.string_to_object(targetRef);
            if (obj == null) {
                System.out.println("Invalid target object");
                System.exit(1);
            }
            target = LookupHelper.narrow(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        try {
            Random rand = new Random();
            PropStruct[] _props = new PropStruct[3];
            _props[0] = new PropStruct();
            _props[0].name = "name";
            _props[0].value_type = orb.get_primitive_tc(TCKind.tk_string);
            _props[0].mode = PropertyMode.PROP_MANDATORY;
            _props[1] = new PropStruct();
            _props[1].name = "cost";
            _props[1].value_type = orb.get_primitive_tc(TCKind.tk_double);
            _props[1].mode = PropertyMode.PROP_MANDATORY;
            _props[2] = new PropStruct();
            _props[2].name = "version";
            _props[2].value_type = orb.get_primitive_tc(TCKind.tk_string);
            _props[2].mode = PropertyMode.PROP_MANDATORY;
            repos.add_type("SubSvc", "IDL:SubSvc:1.0", _props, new String[0]);
            for (int i = 0; i < 10; ++i) {
                Property[] props = new Property[3];
                int num = 0;
                props[num] = new Property();
                props[num].name = "name";
                props[num].value = orb.create_any();
                props[num].value.insert_string("proxy #" + i);
                props[++num] = new Property();
                props[num].name = "cost";
                props[num].value = orb.create_any();
                props[num].value.insert_double(Math.abs(rand.nextDouble()));
                props[++num] = new Property();
                props[num].name = "version";
                props[num].value = orb.create_any();
                props[num].value.insert_string("1.0" + i);
                ++num;
                String recipe = "$(cost) < 1.50 && $(version) = '1.03'";
                Policy[] policies = new Policy[2];
                policies[0] = new Policy();
                policies[0].name = "policy1";
                policies[0].value = orb.create_any();
                policies[0].value.insert_boolean(true);
                policies[1] = new Policy();
                policies[1].name = "policy2";
                policies[1].value = orb.create_any();
                policies[1].value.insert_ulong(i);
                boolean ifMatchAll = i % 2 == 0;
                String id = proxy.export_proxy(target, "SubSvc", props, ifMatchAll, recipe, policies);
                System.out.println("Offer id = " + id);
            }
        }
        catch (IllegalServiceType e) {
            System.out.println("Illegal service type: " + e.type);
        }
        catch (UnknownServiceType e) {
            System.out.println("Unknown service type: " + e.type);
        }
        catch (InvalidLookupRef e) {
            System.out.println("Invalid target object");
        }
        catch (IllegalPropertyName e) {
            System.out.println("Illegal property name: " + e.name);
        }
        catch (PropertyTypeMismatch e) {
            System.out.println("Property type mismatch: " + e.prop.name);
        }
        catch (ReadonlyDynamicProperty e) {
            System.out.println("Readonly dynamic property: " + e.name);
        }
        catch (MissingMandatoryProperty e) {
            System.out.println("Missing mandatory property: " + e.name);
        }
        catch (IllegalRecipe e) {
            System.out.println("Illegal recipe: " + e.recipe);
        }
        catch (DuplicatePropertyName e) {
            System.out.println("Duplicate property: " + e.name);
        }
        catch (DuplicatePolicyName e) {
            System.out.println("Duplicate policy: " + e.name);
        }
        catch (Exception e) {
            System.out.println("Exception: " + e);
        }
        System.exit(0);
    }

    protected static void usage() {
        System.out.println("Usage: org.jacorb.trading.client.proxy.export <proxy-iorfile>");
        System.exit(1);
    }
}

