/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.jacorb.config.Configuration;
import org.jacorb.trading.db.DatabaseMgr;
import org.jacorb.trading.db.OfferDatabase;
import org.jacorb.trading.db.TypeDatabase;
import org.jacorb.trading.db.simple.SimpleDatabaseMgr;
import org.jacorb.trading.impl.AdminImpl;
import org.jacorb.trading.impl.ImportAttrib;
import org.jacorb.trading.impl.LinkAttrib;
import org.jacorb.trading.impl.LinkImpl;
import org.jacorb.trading.impl.LookupImpl;
import org.jacorb.trading.impl.ProxyImpl;
import org.jacorb.trading.impl.RegisterImpl;
import org.jacorb.trading.impl.RepositoryImpl;
import org.jacorb.trading.impl.SupportAttrib;
import org.jacorb.trading.impl.TraderComp;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CosTrading.FollowOption;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;

public class TradingService {
    private static final String s_defaultDbpath = "db";
    private static Configuration configuration = null;
    private static ORB orb;

    protected TradingService() {
    }

    public static ORB getORB() {
        return orb;
    }

    public TradingService(DatabaseMgr dbMgr, String iorfile) {
        Repository intRep = null;
        Object obj = null;
        try {
            obj = orb.resolve_initial_references("InterfaceRepository");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            POA poa = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
            poa.the_POAManager().activate();
            if (obj != null) {
                intRep = RepositoryHelper.narrow(obj);
            }
        }
        catch (InvalidName e) {
        }
        catch (SystemException e) {
        }
        catch (UserException e) {
            // empty catch block
        }
        OfferDatabase offerDb = dbMgr.getOfferDatabase();
        TypeDatabase typeDb = dbMgr.getTypeDatabase();
        RepositoryImpl typeRepos = new RepositoryImpl(typeDb, intRep);
        typeRepos._this_object(orb);
        SupportAttrib supportAttrib = new SupportAttrib();
        supportAttrib.setModifiableProperties(this.getProperty("jtrader.modifiable_properties", true));
        supportAttrib.setDynamicProperties(this.getProperty("jtrader.dynamic_properties", true));
        supportAttrib.setProxyOffers(this.getProperty("jtrader.proxy_offers", true));
        supportAttrib.setTypeRepos(typeRepos._this());
        ImportAttrib importAttrib = new ImportAttrib();
        importAttrib.setDefSearchCard(this.getProperty("jtrader.def_search_card", Integer.MAX_VALUE));
        importAttrib.setMaxSearchCard(this.getProperty("jtrader.max_search_card", Integer.MAX_VALUE));
        importAttrib.setDefMatchCard(this.getProperty("jtrader.def_match_card", Integer.MAX_VALUE));
        importAttrib.setMaxMatchCard(this.getProperty("jtrader.max_match_card", Integer.MAX_VALUE));
        importAttrib.setDefReturnCard(this.getProperty("jtrader.def_return_card", Integer.MAX_VALUE));
        importAttrib.setMaxReturnCard(this.getProperty("jtrader.max_return_card", Integer.MAX_VALUE));
        importAttrib.setMaxList(this.getProperty("jtrader.max_list", Integer.MAX_VALUE));
        importAttrib.setDefHopCount(this.getProperty("jtrader.def_hop_count", Integer.MAX_VALUE));
        importAttrib.setMaxHopCount(this.getProperty("jtrader.max_hop_count", Integer.MAX_VALUE));
        importAttrib.setDefFollowPolicy(this.getProperty("jtrader.def_follow_policy", FollowOption.always));
        importAttrib.setMaxFollowPolicy(this.getProperty("jtrader.max_follow_policy", FollowOption.always));
        LinkAttrib linkAttrib = new LinkAttrib();
        linkAttrib.setMaxLinkFollowPolicy(this.getProperty("jtrader.max_link_follow_policy", FollowOption.always));
        TraderComp traderComp = new TraderComp();
        RegisterImpl reg = new RegisterImpl(traderComp, supportAttrib, offerDb, intRep);
        reg._this_object(orb);
        traderComp.setRegisterInterface(reg._this());
        LinkImpl link = new LinkImpl(traderComp, supportAttrib, linkAttrib);
        link._this_object(orb);
        traderComp.setLinkInterface(link._this());
        LookupImpl lookup = new LookupImpl(traderComp, supportAttrib, importAttrib, offerDb, link, ((org.jacorb.orb.ORB)orb).getConfiguration());
        lookup._this_object(orb);
        traderComp.setLookupInterface(lookup._this());
        byte[] stem = orb.object_to_string(lookup._this()).getBytes();
        AdminImpl admin = new AdminImpl(traderComp, supportAttrib, importAttrib, linkAttrib, offerDb, stem);
        admin._this_object(orb);
        traderComp.setAdminInterface(admin._this());
        ProxyImpl proxy = new ProxyImpl(traderComp, supportAttrib, offerDb);
        proxy._this_object(orb);
        traderComp.setProxyInterface(proxy._this());
        if (iorfile != null) {
            try {
                FileOutputStream out = new FileOutputStream(iorfile);
                PrintWriter pw = new PrintWriter(out);
                pw.println(orb.object_to_string(lookup._this()));
                pw.flush();
                out.close();
            }
            catch (IOException e) {
                System.err.println("Unable to write IOR to file " + iorfile);
                System.exit(1);
            }
        }
    }

    public static void main(String[] args) {
        File f;
        String iorfile = null;
        String dbpath = s_defaultDbpath;
        if (args.length != 1 && args.length != 3) {
            TradingService.usage();
        }
        iorfile = args[0];
        if (args.length == 3) {
            if (args[1].equals("-d")) {
                dbpath = args[2];
            } else {
                TradingService.usage();
            }
        }
        if (!(f = new File(dbpath)).exists()) {
            System.out.println("The directory " + dbpath + " does not exist");
            System.exit(1);
        } else if (!f.isDirectory()) {
            System.out.println("The path " + dbpath + " is not a directory");
            System.exit(1);
        }
        orb = ORB.init(args, null);
        configuration = ((org.jacorb.orb.ORB)orb).getConfiguration();
        SimpleDatabaseMgr dbMgr = new SimpleDatabaseMgr(dbpath);
        new TradingService(dbMgr, iorfile);
        orb.run();
        dbMgr.shutdown();
        System.exit(0);
    }

    protected static void usage() {
        System.err.println("Usage: org.jacorb.trading.TradingService <iorfile> [-d dbpath]");
        System.exit(1);
    }

    private int getProperty(String prop_name, int default_val) {
        String _res = configuration.getAttribute(prop_name, null);
        int _value = default_val;
        if (_res != null) {
            try {
                _value = Integer.parseInt(_res);
            }
            catch (Exception _e) {
                // empty catch block
            }
        }
        return _value;
    }

    private FollowOption getProperty(String prop_name, FollowOption default_val) {
        String _res = configuration.getAttribute(prop_name, null);
        int _value = default_val.value();
        if (_res != null) {
            try {
                _value = Integer.parseInt(_res);
            }
            catch (Exception _e) {
                // empty catch block
            }
        }
        return FollowOption.from_int(_value);
    }

    private boolean getProperty(String prop_name, boolean default_val) {
        String _res = configuration.getAttribute(prop_name, null);
        boolean _value = default_val;
        if (_res != null) {
            try {
                _value = Boolean.valueOf(_res);
            }
            catch (Exception _e) {
                // empty catch block
            }
        }
        return _value;
    }
}

