/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.BufferManager;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.CodeSet;
import org.jacorb.orb.giop.ConnectionListener;
import org.jacorb.orb.giop.MessageOutputStream;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyListener;
import org.jacorb.orb.giop.ReplyOutputStream;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.StatisticsProvider;
import org.jacorb.orb.iiop.IIOPConnection;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.ETF.BufferHolder;
import org.omg.ETF.Connection;
import org.omg.ETF.Profile;
import org.omg.GIOP.ReplyStatusType_1_2;

public abstract class GIOPConnection
extends OutputStream {
    protected Profile profile = null;
    protected Connection transport = null;
    private RequestListener request_listener = null;
    private ReplyListener reply_listener = null;
    protected ConnectionListener connection_listener = null;
    protected Object connect_sync = new Object();
    private boolean writer_active = false;
    private Object write_sync = new Object();
    private org.jacorb.config.Configuration configuration;
    private Logger logger;
    private int TCS = CodeSet.getTCSDefault();
    private int TCSW = CodeSet.getTCSWDefault();
    private boolean tcs_negotiated = false;
    private Hashtable fragments = null;
    private BufferManager buf_mg = null;
    private boolean dump_incoming = false;
    private long timeout = 0L;
    private BufferHolder msg_header = new BufferHolder(new byte[12]);
    private BufferHolder inbuf = new BufferHolder();
    private static int cubby_count = 0;
    private Object[] cubbyholes = null;
    private int pending_messages = 0;
    protected boolean discard_messages = false;
    protected Object pendingUndecidedSync = new Object();
    protected boolean do_close = false;
    protected StatisticsProvider statistics_provider = null;

    public GIOPConnection(Profile profile, Connection transport, RequestListener request_listener, ReplyListener reply_listener, StatisticsProvider statistics_provider) {
        this.profile = profile;
        this.transport = transport;
        this.request_listener = request_listener;
        this.reply_listener = reply_listener;
        this.statistics_provider = statistics_provider;
        this.fragments = new Hashtable();
        this.buf_mg = BufferManager.getInstance();
        this.cubbyholes = new Object[cubby_count];
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)configuration;
        this.logger = this.configuration.getNamedLogger("jacorb.giop.conn");
        this.dump_incoming = configuration.getAttribute("jacorb.debug.dump_incoming_messages", "off").equals("on");
        this.timeout = configuration.getAttributeAsInteger("jacorb.connection.client.connect_timeout", 0);
    }

    public final void setCodeSets(int TCS, int TCSW) {
        this.TCS = TCS;
        this.TCSW = TCSW;
        this.tcs_negotiated = true;
    }

    public final int getTCS() {
        return this.TCS;
    }

    public final int getTCSW() {
        return this.TCSW;
    }

    public final void markTCSNegotiated() {
        this.tcs_negotiated = true;
    }

    public final boolean isTCSNegotiated() {
        return this.tcs_negotiated;
    }

    protected final synchronized RequestListener getRequestListener() {
        return this.request_listener;
    }

    public final synchronized void setRequestListener(RequestListener v) {
        this.request_listener = v;
    }

    private final synchronized ReplyListener getReplyListener() {
        return this.reply_listener;
    }

    public final synchronized void setReplyListener(ReplyListener v) {
        this.reply_listener = v;
    }

    public final void setConnectionListener(ConnectionListener connection_listener) {
        this.connection_listener = connection_listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Connection getTransport() {
        Object object = this.connect_sync;
        synchronized (object) {
            return this.transport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitUntilConnected() {
        Object object = this.connect_sync;
        synchronized (object) {
            while (!this.transport.is_connected() && !this.do_close) {
                try {
                    this.connect_sync.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return !this.do_close;
        }
    }

    protected abstract void readTimedOut();

    protected abstract void streamClosed();

    private byte[] getMessage() throws IOException {
        if (!this.waitUntilConnected()) {
            return null;
        }
        try {
            this.transport.read(this.msg_header, 0, 12, 12, 0L);
        }
        catch (TRANSIENT ex) {
            return null;
        }
        catch (COMM_FAILURE ex) {
            this.streamClosed();
            return null;
        }
        catch (TIMEOUT ex) {
            this.readTimedOut();
            return null;
        }
        byte[] header = this.msg_header.value;
        if ((char)header[0] == 'G' && (char)header[1] == 'I' && (char)header[2] == 'O' && (char)header[3] == 'P') {
            int msg_size = Messages.getMsgSize(header);
            if (msg_size < 0) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Negative GIOP message size: " + msg_size);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("TCP_IP_GIOPTransport.getMessage() with header: \n" + header + "\nsize : " + 12);
                }
                return null;
            }
            this.inbuf.value = this.buf_mg.getBuffer(msg_size + 12);
            System.arraycopy(header, 0, this.inbuf.value, 0, 12);
            try {
                this.transport.read(this.inbuf, 12, msg_size, msg_size, 0L);
            }
            catch (COMM_FAILURE ex) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Failed to read GIOP message");
                }
                return null;
            }
            if (this.dump_incoming && this.logger.isInfoEnabled()) {
                this.logger.info("BufferDump:\n" + ObjectUtil.bufToString(this.inbuf.value, 0, msg_size + 12));
            }
            if (this.statistics_provider != null) {
                this.statistics_provider.messageReceived(msg_size + 12);
            }
            return this.inbuf.value;
        }
        if (this.logger.isErrorEnabled()) {
            this.logger.error("Failed to read GIOP message, incorrect magic number");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GIOPConnection.getMessage()" + this.msg_header.value);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void receiveMessages() throws IOException {
        while (true) {
            byte[] message;
            if ((message = this.getMessage()) == null) {
                if (!this.do_close) continue;
                return;
            }
            Object object = this.pendingUndecidedSync;
            synchronized (object) {
                ByteArrayOutputStream b_out;
                if (this.discard_messages) {
                    this.buf_mg.returnBuffer(message);
                    continue;
                }
                if (Messages.getGIOPMajor(message) != 1) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("Invalid GIOP major version encountered: " + Messages.getGIOPMajor(message));
                    }
                    this.buf_mg.returnBuffer(message);
                    continue;
                }
                int msg_type = Messages.getMsgType(message);
                if (msg_type == 7) {
                    if (Messages.getGIOPMinor(message) == 0) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Received a GIOP 1.0 message of type Fragment");
                        }
                        MessageOutputStream out = new MessageOutputStream();
                        out.writeGIOPMsgHeader(6, 0);
                        out.insertMsgSize();
                        this.sendMessage(out);
                        this.buf_mg.returnBuffer(message);
                        continue;
                    }
                    if (Messages.getGIOPMinor(message) == 1) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Received a GIOP 1.1 Fragment message");
                        }
                        this.buf_mg.returnBuffer(message);
                        continue;
                    }
                    Integer request_id = new Integer(Messages.getRequestId(message));
                    if (!this.fragments.containsKey(request_id)) {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error("No previous Fragment to this one");
                        }
                        this.buf_mg.returnBuffer(message);
                        continue;
                    }
                    b_out = (ByteArrayOutputStream)this.fragments.get(request_id);
                    b_out.write(message, 16, Messages.getMsgSize(message) - 4);
                    if (Messages.moreFragmentsFollow(message)) {
                        this.buf_mg.returnBuffer(message);
                        continue;
                    }
                    this.buf_mg.returnBuffer(message);
                    message = b_out.toByteArray();
                    msg_type = Messages.getMsgType(message);
                    this.fragments.remove(request_id);
                } else if (Messages.moreFragmentsFollow(message)) {
                    if (Messages.getGIOPMinor(message) == 0) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Received a GIOP 1.0 message with the \"more fragments follow\" bits set");
                        }
                        MessageOutputStream out = new MessageOutputStream();
                        out.writeGIOPMsgHeader(6, 0);
                        out.insertMsgSize();
                        this.sendMessage(out);
                        this.buf_mg.returnBuffer(message);
                        continue;
                    }
                    if (Messages.getGIOPMinor(message) == 1) {
                        if (msg_type != 0 && msg_type != 1) {
                            if (this.logger.isWarnEnabled()) {
                                this.logger.warn("Received a GIOP 1.1 message of type " + msg_type + " with the \"more fragments follow\" bits set");
                            }
                            MessageOutputStream out = new MessageOutputStream();
                            out.writeGIOPMsgHeader(6, 1);
                            out.insertMsgSize();
                            this.sendMessage(out);
                            this.buf_mg.returnBuffer(message);
                            continue;
                        }
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Received a fragmented GIOP 1.1 message");
                        }
                        int giop_minor = Messages.getGIOPMinor(message);
                        ReplyOutputStream out = new ReplyOutputStream(Messages.getRequestId(message), ReplyStatusType_1_2.SYSTEM_EXCEPTION, giop_minor, false, this.logger);
                        SystemExceptionHelper.write(out, new NO_IMPLEMENT(0, CompletionStatus.COMPLETED_NO));
                        this.sendMessage(out);
                        this.buf_mg.returnBuffer(message);
                        continue;
                    }
                    if (msg_type == 2 || msg_type == 5 || msg_type == 2) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Received a GIOP message of type " + msg_type + " with the \"more fragments follow\" bits set, but this " + "message type isn't allowed to be fragmented");
                        }
                        MessageOutputStream out = new MessageOutputStream();
                        out.writeGIOPMsgHeader(6, 1);
                        out.insertMsgSize();
                        this.sendMessage(out);
                        this.buf_mg.returnBuffer(message);
                        continue;
                    }
                    Integer request_id = new Integer(Messages.getRequestId(message));
                    if (this.fragments.containsKey(request_id)) {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error("Received a message of type " + msg_type + " with the more fragments follow bit set, but there is already an fragmented, incomplete message with the same request id " + request_id + "!");
                        }
                        this.buf_mg.returnBuffer(message);
                        continue;
                    }
                    b_out = new ByteArrayOutputStream();
                    this.fragments.put(request_id, b_out);
                    b_out.write(message, 0, 12 + Messages.getMsgSize(message));
                    this.buf_mg.returnBuffer(message);
                    continue;
                }
                switch (msg_type) {
                    case 0: {
                        this.getRequestListener().requestReceived(message, this);
                        break;
                    }
                    case 1: {
                        this.getReplyListener().replyReceived(message, this);
                        break;
                    }
                    case 2: {
                        this.getRequestListener().cancelRequestReceived(message, this);
                        break;
                    }
                    case 3: {
                        this.getRequestListener().locateRequestReceived(message, this);
                        break;
                    }
                    case 4: {
                        this.getReplyListener().locateReplyReceived(message, this);
                        break;
                    }
                    case 5: {
                        this.getReplyListener().closeConnectionReceived(message, this);
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 7: {
                        break;
                    }
                    default: {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error("received message with unknown message type " + msg_type);
                        }
                        this.buf_mg.returnBuffer(message);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void getWriteLock() {
        Object object = this.write_sync;
        synchronized (object) {
            while (this.writer_active) {
                try {
                    this.write_sync.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.writer_active = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void releaseWriteLock() {
        Object object = this.write_sync;
        synchronized (object) {
            this.writer_active = false;
            this.write_sync.notifyAll();
        }
    }

    public final synchronized void incPendingMessages() {
        ++this.pending_messages;
    }

    public final synchronized void decPendingMessages() {
        --this.pending_messages;
    }

    public final synchronized boolean hasPendingMessages() {
        return this.pending_messages != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(byte[] fragment, int start, int size) {
        if (!this.transport.is_connected()) {
            Object object = this.connect_sync;
            synchronized (object) {
                this.transport.connect(this.profile, this.timeout);
                this.connect_sync.notifyAll();
            }
        }
        this.transport.write(false, false, fragment, start, size, 0L);
        if (this.getStatisticsProvider() != null) {
            this.getStatisticsProvider().messageChunkSent(size);
        }
    }

    public final void write(int i) throws IOException {
        throw new NO_IMPLEMENT();
    }

    public final void write(byte[] b) throws IOException {
        throw new NO_IMPLEMENT();
    }

    public final void flush() throws IOException {
        throw new NO_IMPLEMENT();
    }

    public final void sendRequest(MessageOutputStream out, boolean expect_reply) throws IOException {
        if (expect_reply) {
            this.incPendingMessages();
        }
        this.sendMessage(out);
    }

    public final void sendReply(MessageOutputStream out) throws IOException {
        this.decPendingMessages();
        this.sendMessage(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendMessage(MessageOutputStream out) throws IOException {
        try {
            this.getWriteLock();
            out.write_to(this);
            this.transport.flush();
            if (this.getStatisticsProvider() != null) {
                this.getStatisticsProvider().flushed();
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public final boolean isSSL() {
        if (this.transport instanceof IIOPConnection) {
            return ((IIOPConnection)this.transport).isSSL();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.connect_sync;
        synchronized (object) {
            if (this.connection_listener != null) {
                this.connection_listener.connectionClosed();
            }
            this.transport.close();
            this.do_close = true;
            this.connect_sync.notifyAll();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GIOPConnection closed (terminated).");
        }
    }

    public final StatisticsProvider getStatisticsProvider() {
        return this.statistics_provider;
    }

    public static int allocate_cubby_id() {
        return cubby_count++;
    }

    public Object get_cubby(int id) {
        if (id < 0 || id >= cubby_count) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Get bad cubby id " + id + " (max=" + cubby_count + ")");
            }
            return null;
        }
        return this.cubbyholes[id];
    }

    public void set_cubby(int id, Object obj) {
        if (id < 0 || id >= cubby_count) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Set bad cubby id " + id + " (max=" + cubby_count + ")");
            }
            return;
        }
        this.cubbyholes[id] = obj;
    }
}

