/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CONV_FRAME.CodeSetContextHelper;
import org.omg.IOP.ServiceContext;

public class CodeSet {
    public static final int ISO8859_1 = 65537;
    public static final int UTF16 = 65801;
    public static final int UTF8 = 0x5010001;

    public static String csName(int cs) {
        switch (cs) {
            case 65537: {
                return "ISO 8859-1";
            }
            case 65801: {
                return "UTF-16";
            }
            case 0x5010001: {
                return "UTF-8";
            }
        }
        return "Unknown TCS: " + Integer.toHexString(cs);
    }

    public static int getTCSDefault() {
        return 65537;
    }

    public static int getTCSWDefault() {
        return 65801;
    }

    public static int getConversionDefault() {
        return 0x5010001;
    }

    public static int selectTCS(CodeSetComponentInfo cs_info) {
        int with_native = CodeSet.selectCodeSet(cs_info.ForCharData, CodeSet.getTCSDefault());
        if (with_native == -1) {
            return CodeSet.selectCodeSet(cs_info.ForCharData, CodeSet.getConversionDefault());
        }
        return with_native;
    }

    public static int selectTCSW(CodeSetComponentInfo cs_info) {
        int with_native = CodeSet.selectCodeSet(cs_info.ForWcharData, CodeSet.getTCSWDefault());
        if (with_native == -1) {
            return CodeSet.selectCodeSet(cs_info.ForWcharData, CodeSet.getConversionDefault());
        }
        return with_native;
    }

    private static int selectCodeSet(CodeSetComponent cs_component, int native_cs) {
        if (cs_component.native_code_set == native_cs) {
            return native_cs;
        }
        for (int i = 0; i < cs_component.conversion_code_sets.length; ++i) {
            if (cs_component.conversion_code_sets[i] != native_cs) continue;
            return native_cs;
        }
        return -1;
    }

    public static ServiceContext createCodesetContext(int tcs, int tcsw) {
        CDROutputStream os = new CDROutputStream();
        os.beginEncapsulatedArray();
        CodeSetContextHelper.write(os, new CodeSetContext(tcs, tcsw));
        return new ServiceContext(1, os.getBufferCopy());
    }

    public static CodeSetContext getCodeSetContext(ServiceContext[] contexts) {
        for (int i = 0; i < contexts.length; ++i) {
            if (contexts[i].context_id != 1) continue;
            CDRInputStream is = new CDRInputStream(null, contexts[i].context_data);
            is.openEncapsulatedArray();
            return CodeSetContextHelper.read(is);
        }
        return null;
    }
}

