/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.orb.giop.ClientConnection;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.GIOPConnectionManager;
import org.jacorb.orb.giop.MessageReceptorPool;
import org.jacorb.orb.giop.NoBiDirClientRequestListener;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.TransportManager;
import org.jacorb.util.ObjectUtil;
import org.omg.ETF.Factories;
import org.omg.ETF.Profile;

public class ClientConnectionManager
implements Configurable {
    private ORB orb = null;
    private Map connections = new HashMap();
    private SocketFactory socket_factory = null;
    private SocketFactory ssl_socket_factory = null;
    private RequestListener request_listener = null;
    private MessageReceptorPool receptor_pool = null;
    private TransportManager transport_manager = null;
    private GIOPConnectionManager giop_connection_manager = null;
    private org.jacorb.config.Configuration configuration = null;
    private Logger logger = null;
    static /* synthetic */ Class class$org$jacorb$orb$ORB;

    public ClientConnectionManager(ORB orb, TransportManager transport_manager, GIOPConnectionManager giop_connection_manager) {
        this.orb = orb;
        this.transport_manager = transport_manager;
        this.giop_connection_manager = giop_connection_manager;
    }

    public void configure(Configuration myConfiguration) throws ConfigurationException {
        this.receptor_pool = MessageReceptorPool.getInstance(myConfiguration);
        this.configuration = (org.jacorb.config.Configuration)myConfiguration;
        this.logger = this.configuration.getNamedLogger("jacorb.orb.giop");
        this.request_listener = new NoBiDirClientRequestListener(this.logger);
        this.socket_factory = this.transport_manager.getSocketFactoryManager().getSocketFactory();
        if (this.configuration.getAttribute("jacorb.security.support_ssl", "off").equals("on")) {
            String s = this.configuration.getAttribute("jacorb.ssl.socket_factory", "");
            if (s.length() == 0) {
                throw new RuntimeException("SSL support is on, but the property \"jacorb.ssl.socket_factory\" is not set!");
            }
            try {
                Class ssl = ObjectUtil.classForName(s);
                Constructor constr = ssl.getConstructor(class$org$jacorb$orb$ORB == null ? (class$org$jacorb$orb$ORB = ClientConnectionManager.class$("org.jacorb.orb.ORB")) : class$org$jacorb$orb$ORB);
                this.ssl_socket_factory = (SocketFactory)constr.newInstance(this.orb);
            }
            catch (Exception e) {
                throw new RuntimeException("SSL support is on, but the ssl socket factory can't be instantiated (" + e.getMessage() + ")!");
            }
        }
    }

    public void setRequestListener(RequestListener listener) {
        this.request_listener = listener;
    }

    public synchronized ClientConnection getConnection(Profile profile) {
        ClientConnection c = (ClientConnection)this.connections.get(profile);
        if (c == null) {
            int tag = profile.tag();
            Factories factories = this.transport_manager.getFactories(tag);
            if (factories == null) {
                throw new RuntimeException("No transport plugin for profile tag " + tag);
            }
            GIOPConnection connection = this.giop_connection_manager.createClientGIOPConnection(profile, factories.create_connection(null), this.request_listener, null);
            c = new ClientConnection(connection, this.orb, this, profile, true);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("ClientConnectionManager: created new conn to target " + c.getInfo());
            }
            this.connections.put(profile, c);
            this.receptor_pool.connectionCreated(connection);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("ClientConnectionManager: found conn to target " + c.getInfo());
        }
        c.incClients();
        return c;
    }

    public synchronized void releaseConnection(ClientConnection c) {
        if (c.decClients()) {
            c.close();
            this.connections.remove(c.getRegisteredProfile());
        }
    }

    public synchronized void removeConnection(ClientConnection c) {
        this.connections.remove(c.getRegisteredProfile());
    }

    public synchronized void addConnection(GIOPConnection connection) {
        this.addConnection(connection, connection.getTransport().get_server_profile());
    }

    public synchronized void addConnection(GIOPConnection connection, Profile profile) {
        if (!this.connections.containsKey(profile)) {
            ClientConnection c = new ClientConnection(connection, this.orb, this, profile, false);
            c.incClients();
            this.connections.put(profile, c);
        }
    }

    public void shutdown() {
        Iterator i = this.connections.values().iterator();
        while (i.hasNext()) {
            ((ClientConnection)i.next()).close();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ClientConnectionManager shut down (all connections released)");
        }
        this.connections.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

