/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.dns.DNSLookup;
import org.omg.CORBA.portable.InputStream;

public class IIOPAddress
implements Configurable {
    private String hostname = null;
    private String ip = null;
    private int port;
    private org.jacorb.config.Configuration configuration;
    private boolean configured = true;
    private DNSLookup lookup;
    private Logger logger;

    public IIOPAddress(String host, int port) {
        if (host.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.lookup = new DNSLookup();
        if (IIOPAddress.isIP(host)) {
            this.ip = host;
        } else {
            this.hostname = host;
        }
        this.port = port < 0 ? port + 65536 : port;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)configuration;
        this.logger = this.configuration.getNamedLogger("jacorb.iiop.address");
        this.lookup.configure(configuration);
        this.configured = true;
    }

    public static IIOPAddress read(InputStream in) {
        String host = in.read_string();
        short port = in.read_ushort();
        IIOPAddress addr = new IIOPAddress(host, port);
        return addr;
    }

    private static boolean isIP(String host) {
        int index = 0;
        int numberStart = 0;
        int length = host.length();
        int ch = 32;
        for (int i = 0; i < 4; ++i) {
            while (index < length && (ch = (int)host.charAt(index)) != 46) {
                if (ch < 48 || ch > 57) {
                    return false;
                }
                ++index;
            }
            if (index >= length && i == 3 && index - numberStart <= 3 && index - numberStart > 0) {
                return true;
            }
            if (ch != 46 || index - numberStart > 3 || index - numberStart <= 0) {
                return false;
            }
            numberStart = ++index;
        }
        return false;
    }

    public String getIP() {
        if (this.ip == null) {
            try {
                this.ip = InetAddress.getByName(this.hostname).getHostAddress();
            }
            catch (UnknownHostException ex) {
                throw new RuntimeException("could not resolve hostname: " + this.hostname);
            }
        }
        return this.ip;
    }

    public String getHostname() {
        if (this.hostname == null) {
            if (!this.configured) {
                throw new Error("Unconfigured IIOPAddress!");
            }
            this.hostname = this.lookup.inverseLookup(this.ip);
            if (this.hostname == null) {
                this.hostname = this.ip;
            }
        }
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object other) {
        if (other instanceof IIOPAddress) {
            IIOPAddress x = (IIOPAddress)other;
            if (this.port == x.port) {
                return this.getIP().equals(x.getIP());
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.getIP().hashCode() + this.port;
    }

    public String toString() {
        if (this.hostname != null) {
            return this.hostname + ":" + this.port;
        }
        return this.ip + ":" + this.port;
    }

    public byte[] toCDR() {
        CDROutputStream out = new CDROutputStream();
        out.beginEncapsulatedArray();
        out.write_string(this.ip);
        out.write_ushort((short)this.port);
        return out.getBufferCopy();
    }

    public String getOriginalHost() {
        if (this.hostname == null) {
            return this.ip;
        }
        if (this.ip == null) {
            return this.hostname;
        }
        return this.hostname + " / " + this.ip;
    }
}

