/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.util;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;

public abstract class AbstractObjectPool
implements Runnable,
Configurable {
    public static final boolean DEBUG = false;
    public static final long SLEEP = 5000L;
    public static final int LOWER_WATERMARK_DEFAULT = 30;
    public static final int SIZE_INCREASE_DEFAULT = 30;
    public static final int INITIAL_SIZE_DEFAULT = 100;
    public static final int MAXIMUM_WATERMARK_DEFAULT = 1000;
    private static final List sPoolsToLookAfter = new ArrayList();
    private static AbstractObjectPool[] asArray;
    private static boolean modified;
    private static final AbstractObjectPool[] ARRAY_TEMPLATE;
    private static Thread sCleanerThread;
    private static ListCleaner sListCleaner;
    private String name_;
    private LinkedList pool_;
    private Set active_ = Collections.synchronizedSet(new HashSet());
    private int lowerWatermark_;
    private int maxWatermark_;
    private int sizeIncrease_;
    private int initialSize_;
    protected Logger logger_;
    protected Configuration config_;
    static /* synthetic */ Class class$org$jacorb$notification$util$AbstractObjectPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AbstractObjectPool[] getAllPools() {
        List list = sPoolsToLookAfter;
        synchronized (list) {
            if (modified) {
                asArray = sPoolsToLookAfter.toArray(ARRAY_TEMPLATE);
                modified = false;
            }
        }
        return asArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerPool(AbstractObjectPool pool) {
        List list = sPoolsToLookAfter;
        synchronized (list) {
            sPoolsToLookAfter.add(pool);
            modified = true;
            AbstractObjectPool.startListCleaner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deregisterPool(AbstractObjectPool pool) {
        List list = sPoolsToLookAfter;
        synchronized (list) {
            sPoolsToLookAfter.remove(pool);
            modified = true;
            if (sPoolsToLookAfter.isEmpty()) {
                AbstractObjectPool.getAllPools();
                AbstractObjectPool.stopListCleaner();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ListCleaner getListCleaner() {
        Class clazz = class$org$jacorb$notification$util$AbstractObjectPool == null ? (class$org$jacorb$notification$util$AbstractObjectPool = AbstractObjectPool.class$("org.jacorb.notification.util.AbstractObjectPool")) : class$org$jacorb$notification$util$AbstractObjectPool;
        synchronized (clazz) {
            if (sListCleaner == null) {
                sListCleaner = new ListCleaner();
            }
            return sListCleaner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopListCleaner() {
        Class clazz = class$org$jacorb$notification$util$AbstractObjectPool == null ? (class$org$jacorb$notification$util$AbstractObjectPool = AbstractObjectPool.class$("org.jacorb.notification.util.AbstractObjectPool")) : class$org$jacorb$notification$util$AbstractObjectPool;
        synchronized (clazz) {
            if (sCleanerThread != null) {
                sListCleaner.setInactive();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startListCleaner() {
        Class clazz = class$org$jacorb$notification$util$AbstractObjectPool == null ? (class$org$jacorb$notification$util$AbstractObjectPool = AbstractObjectPool.class$("org.jacorb.notification.util.AbstractObjectPool")) : class$org$jacorb$notification$util$AbstractObjectPool;
        synchronized (clazz) {
            if (sCleanerThread == null) {
                sCleanerThread = new Thread(AbstractObjectPool.getListCleaner());
                sCleanerThread.setName("ObjectPoolCleaner");
                sCleanerThread.setPriority(2);
                sCleanerThread.setDaemon(true);
                sCleanerThread.start();
            }
        }
    }

    public void configure(Configuration conf) {
        this.config_ = conf;
        this.logger_ = ((org.jacorb.config.Configuration)conf).getNamedLogger(this.getClass().getName());
        this.init();
        AbstractObjectPool.registerPool(this);
    }

    protected AbstractObjectPool(String name) {
        this(name, 30, 30, 100, 1000);
    }

    protected AbstractObjectPool(String name, int threshold, int sizeincrease, int initialsize, int maxsize) {
        this.name_ = name;
        this.pool_ = new LinkedList();
        this.lowerWatermark_ = threshold;
        this.sizeIncrease_ = sizeincrease;
        this.initialSize_ = initialsize;
        this.maxWatermark_ = maxsize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LinkedList linkedList = this.pool_;
        synchronized (linkedList) {
            if (this.pool_.size() > this.lowerWatermark_) {
                return;
            }
        }
        ArrayList<Object> os = new ArrayList<Object>(this.sizeIncrease_);
        for (int x = 0; x < this.sizeIncrease_; ++x) {
            Object _i = this.createInstance();
            os.add(_i);
        }
        LinkedList linkedList2 = this.pool_;
        synchronized (linkedList2) {
            this.pool_.addAll(os);
        }
    }

    private Object createInstance() {
        Object _i = this.newInstance();
        return _i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        LinkedList linkedList = this.pool_;
        synchronized (linkedList) {
            for (int x = 0; x < this.initialSize_; ++x) {
                Object _i = this.createInstance();
                this.pool_.add(_i);
            }
        }
    }

    public void dispose() {
        AbstractObjectPool.deregisterPool(this);
        this.pool_.clear();
        this.active_.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lendObject() {
        Object _ret = null;
        LinkedList linkedList = this.pool_;
        synchronized (linkedList) {
            if (!this.pool_.isEmpty()) {
                _ret = this.pool_.removeFirst();
            }
        }
        if (_ret == null) {
            _ret = this.createInstance();
        }
        try {
            ((Configurable)_ret).configure(this.config_);
        }
        catch (ClassCastException cce) {
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        this.activateObject(_ret);
        this.active_.add(_ret);
        return _ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object o) {
        if (this.active_.remove(o)) {
            this.passivateObject(o);
            if (this.pool_.size() < this.maxWatermark_) {
                LinkedList linkedList = this.pool_;
                synchronized (linkedList) {
                    this.pool_.add(o);
                    this.pool_.notifyAll();
                }
            } else {
                this.destroyObject(o);
            }
        }
    }

    public abstract Object newInstance();

    public void passivateObject(Object o) {
    }

    public void activateObject(Object o) {
    }

    public void destroyObject(Object o) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        modified = true;
        ARRAY_TEMPLATE = new AbstractObjectPool[0];
    }

    private static class ListCleaner
    extends Thread {
        private SynchronizedBoolean active_ = new SynchronizedBoolean(true);

        private ListCleaner() {
        }

        public void setInactive() {
            this.active_.set(false);
            this.interrupt();
        }

        private void ensureIsActive() throws InterruptedException {
            if (!this.active_.get()) {
                throw new InterruptedException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Class clazz;
            try {
                while (this.active_.get()) {
                    try {
                        this.runLoop();
                    }
                    catch (Exception exception) {}
                }
                Object var3_2 = null;
                clazz = class$org$jacorb$notification$util$AbstractObjectPool == null ? (class$org$jacorb$notification$util$AbstractObjectPool = AbstractObjectPool.class$("org.jacorb.notification.util.AbstractObjectPool")) : class$org$jacorb$notification$util$AbstractObjectPool;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                Class clazz2 = class$org$jacorb$notification$util$AbstractObjectPool == null ? (class$org$jacorb$notification$util$AbstractObjectPool = AbstractObjectPool.class$("org.jacorb.notification.util.AbstractObjectPool")) : class$org$jacorb$notification$util$AbstractObjectPool;
                synchronized (clazz2) {
                    sCleanerThread = null;
                }
                throw throwable;
            }
            synchronized (clazz) {
                sCleanerThread = null;
            }
        }

        private void runLoop() throws InterruptedException {
            block4: while (true) {
                try {
                    ListCleaner.sleep(5000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                this.ensureIsActive();
                AbstractObjectPool[] poolsToCheck = AbstractObjectPool.getAllPools();
                int x = 0;
                while (true) {
                    if (x >= poolsToCheck.length) continue block4;
                    try {
                        poolsToCheck[x].run();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    ++x;
                }
                break;
            }
        }
    }
}

