/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import java.util.List;
import org.jacorb.notification.CollectionsWrapper;
import org.jacorb.notification.engine.PushStructuredOperation;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageConsumer;
import org.jacorb.notification.servant.AbstractProxySupplier;
import org.omg.CORBA.Object;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyChannelAdmin.ProxySupplierHelper;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushSupplierOperations;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushSupplierPOATie;
import org.omg.CosNotifyComm.InvalidEventType;
import org.omg.CosNotifyComm.StructuredPushConsumer;
import org.omg.CosNotifyComm.StructuredPushConsumerOperations;
import org.omg.PortableServer.Servant;

public class StructuredProxyPushSupplierImpl
extends AbstractProxySupplier
implements StructuredProxyPushSupplierOperations {
    private static final StructuredPushConsumerOperations NULL_CONSUMER = new StructuredPushConsumerOperations(){

        public void push_structured_event(StructuredEvent event) {
        }

        public void disconnect_structured_push_consumer() {
        }

        public void offer_change(EventType[] added, EventType[] removed) throws InvalidEventType {
        }
    };
    private StructuredPushConsumerOperations pushConsumer_;
    private final java.lang.Object refLock_ = new java.lang.Object();

    public ProxyType MyType() {
        return ProxyType.PUSH_STRUCTURED;
    }

    public void deliverMessage(Message message) {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("deliverMessage() connected=" + this.isConnected() + " suspended=" + this.isSuspended() + " enabled=" + this.isEnabled());
        }
        if (this.isConnected()) {
            if (!this.isSuspended() && this.isEnabled()) {
                try {
                    this.pushConsumer_.push_structured_event(message.toStructuredEvent());
                    this.resetErrorCounter();
                }
                catch (Throwable e) {
                    PushStructuredOperation _failedOperation = new PushStructuredOperation(this.pushConsumer_, message);
                    this.handleFailedPushOperation(_failedOperation, e);
                }
            } else {
                this.enqueue(message);
            }
        } else {
            this.logger_.debug("Not connected");
        }
    }

    public void connect_structured_push_consumer(StructuredPushConsumer consumer) throws AlreadyConnected {
        this.assertNotConnected();
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("connect structured_push_consumer");
        }
        this.pushConsumer_ = consumer;
        this.connectClient(consumer);
    }

    public void disconnect_structured_push_supplier() {
        this.dispose();
    }

    public void deliverPendingData() {
        Message[] _events = this.getAllMessages();
        if (_events != null) {
            for (int x = 0; x < _events.length; ++x) {
                this.deliverMessage(_events[x]);
                _events[x].dispose();
            }
        }
    }

    protected void connectionResumed() {
        this.scheduleDeliverPendingMessagesOperation_.run();
    }

    protected void disconnectClient() {
        this.pushConsumer_.disconnect_structured_push_consumer();
        this.pushConsumer_ = NULL_CONSUMER;
    }

    public List getSubsequentFilterStages() {
        return CollectionsWrapper.singletonList(this);
    }

    public MessageConsumer getMessageConsumer() {
        return this;
    }

    public boolean hasMessageConsumer() {
        return true;
    }

    public synchronized Servant getServant() {
        if (this.thisServant_ == null) {
            this.thisServant_ = new StructuredProxyPushSupplierPOATie(this);
        }
        return this.thisServant_;
    }

    public Object activate() {
        return ProxySupplierHelper.narrow(this.getServant()._this_object(this.getORB()));
    }
}

