/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.ChannelContext;
import org.jacorb.notification.ChannelContextDependency;
import org.jacorb.notification.Dependant;
import org.jacorb.notification.EventChannelDependency;
import org.jacorb.notification.FilterManager;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.MessageFactoryDependency;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.ProxyEvent;
import org.jacorb.notification.interfaces.ProxyEventListener;
import org.jacorb.notification.servant.AbstractProxy;
import org.jacorb.notification.servant.ManageableServant;
import org.jacorb.notification.util.QoSPropertySet;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CosNotification.NamedPropertyRangeSeqHolder;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.QoSAdminOperations;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.InterFilterGroupOperator;
import org.omg.CosNotifyChannelAdmin.ProxyNotFound;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterAdminOperations;
import org.omg.CosNotifyFilter.FilterNotFound;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public abstract class AbstractAdmin
implements QoSAdminOperations,
FilterAdminOperations,
FilterStage,
Dependant,
ManageableServant,
ChannelContextDependency,
Configurable,
MessageFactoryDependency,
EventChannelDependency {
    protected static final InterFilterGroupOperator DEFAULT_FILTER_GROUP_OPERATOR = InterFilterGroupOperator.AND_OP;
    protected OfferManager offerManager_;
    protected SubscriptionManager subscriptionManager_;
    protected Logger logger_ = null;
    protected final Object modifyProxiesLock_ = new Object();
    protected final Map pullServants_ = new HashMap();
    protected final Map pushServants_ = new HashMap();
    private Integer id_;
    private boolean isIDPublic_;
    private POA poa_;
    private ORB orb_;
    private InterFilterGroupOperator filterGroupOperator_;
    private FilterManager filterManager_;
    private final SynchronizedInt proxyIdPool_ = new SynchronizedInt(0);
    private QoSPropertySet qosSettings_;
    private final SynchronizedBoolean disposed_ = new SynchronizedBoolean(false);
    private final List proxyEventListener_ = new ArrayList();
    private MessageFactory messageFactory_;
    private Runnable disposeHook_;
    private ChannelContext channelContext_;
    private EventChannel eventChannel_;

    public void configure(Configuration conf) {
        this.logger_ = ((org.jacorb.config.Configuration)conf).getNamedLogger(this.getClass().getName());
        this.filterManager_.configure(conf);
        this.qosSettings_ = new QoSPropertySet(conf, 1);
    }

    public final void setMessageFactory(MessageFactory factory) {
        this.messageFactory_ = factory;
    }

    public void setDisposeHook(Runnable disposeHook) {
        this.disposeHook_ = disposeHook;
    }

    public void setInterFilterGroupOperator(InterFilterGroupOperator op) {
        this.filterGroupOperator_ = op;
    }

    public void setID(Integer id) {
        this.id_ = id;
    }

    public void setIsIDPublic(boolean isIDPublic) {
        this.isIDPublic_ = isIDPublic;
    }

    protected POA getPOA() {
        return this.poa_;
    }

    public void setPOA(POA poa) {
        this.poa_ = poa;
    }

    protected ORB getORB() {
        return this.orb_;
    }

    public void setORB(ORB orb) {
        this.orb_ = orb;
        this.filterManager_ = new FilterManager(orb);
        this.configure((Configuration)((org.jacorb.orb.ORB)this.getORB()).getConfiguration());
    }

    protected MessageFactory getMessageFactory() {
        return this.messageFactory_;
    }

    public POA _default_POA() {
        return this.getPOA();
    }

    int getProxyID() {
        return this.proxyIdPool_.increment();
    }

    public List getFilters() {
        return this.filterManager_.getFilters();
    }

    public int add_filter(Filter aFilter) {
        return this.filterManager_.add_filter(aFilter);
    }

    public void remove_filter(int aFilterId) throws FilterNotFound {
        this.filterManager_.remove_filter(aFilterId);
    }

    public Filter get_filter(int aFilterId) throws FilterNotFound {
        return this.filterManager_.get_filter(aFilterId);
    }

    public int[] get_all_filters() {
        return this.filterManager_.get_all_filters();
    }

    public void remove_all_filters() {
        this.filterManager_.remove_all_filters();
    }

    public final InterFilterGroupOperator MyOperator() {
        return this.filterGroupOperator_;
    }

    public final EventChannel MyChannel() {
        return this.eventChannel_;
    }

    public final void setEventChannel(EventChannel channel) {
        this.eventChannel_ = channel;
    }

    public final int MyID() {
        return this.getID();
    }

    public Property[] get_qos() {
        return this.qosSettings_.get_qos();
    }

    public void set_qos(Property[] props) throws UnsupportedQoS {
        this.qosSettings_.validate_qos(props, new NamedPropertyRangeSeqHolder());
        this.qosSettings_.set_qos(props);
    }

    public void validate_qos(Property[] props, NamedPropertyRangeSeqHolder propertyRangeSeqHolder) throws UnsupportedQoS {
        this.qosSettings_.validate_qos(props, propertyRangeSeqHolder);
    }

    public void destroy() {
        this.dispose();
    }

    private void checkDisposalStatus() throws OBJECT_NOT_EXIST {
        if (this.disposed_.get()) {
            throw new OBJECT_NOT_EXIST();
        }
        this.disposed_.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeProxies() {
        Object object = this.modifyProxiesLock_;
        synchronized (object) {
            Disposable _d;
            this.logger_.debug("dispose PushServants");
            Iterator _i = this.pushServants_.values().iterator();
            while (_i.hasNext()) {
                try {
                    _d = (Disposable)_i.next();
                    _i.remove();
                    _d.dispose();
                }
                catch (Exception e) {
                    this.logger_.warn("Error disposing a PushServant", (Throwable)e);
                }
            }
            this.pushServants_.clear();
            this.logger_.debug("dispose PullServants");
            _i = this.pullServants_.values().iterator();
            while (_i.hasNext()) {
                try {
                    _d = (Disposable)_i.next();
                    _i.remove();
                    _d.dispose();
                }
                catch (Exception e) {
                    this.logger_.warn("Error disposing a PullServant", (Throwable)e);
                }
            }
            this.pullServants_.clear();
        }
    }

    public void dispose() {
        this.checkDisposalStatus();
        this.deactivate();
        this.remove_all_filters();
        this.disposeProxies();
        this.disposeHook_.run();
    }

    public void deactivate() {
        this.logger_.debug("deactivate Admin");
        try {
            byte[] _oid = this.getPOA().servant_to_id(this.getServant());
            this.getPOA().deactivate_object(_oid);
        }
        catch (Exception e) {
            this.logger_.fatalError("Couldn't deactivate Admin", (Throwable)e);
        }
    }

    public abstract Servant getServant();

    public Integer getID() {
        return this.id_;
    }

    public boolean isDisposed() {
        return this.disposed_.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCreateProxyRequestEvent() throws AdminLimitExceeded {
        List list = this.proxyEventListener_;
        synchronized (list) {
            ProxyEvent _event = new ProxyEvent(this);
            Iterator _i = this.proxyEventListener_.iterator();
            while (_i.hasNext()) {
                ProxyEventListener _listener = (ProxyEventListener)_i.next();
                _listener.actionProxyCreationRequest(_event);
            }
        }
    }

    public boolean hasLifetimeFilter() {
        return false;
    }

    public boolean hasPriorityFilter() {
        return false;
    }

    public MappingFilter getLifetimeFilter() {
        throw new UnsupportedOperationException();
    }

    public MappingFilter getPriorityFilter() {
        throw new UnsupportedOperationException();
    }

    public void setOfferManager(OfferManager offerManager) {
        this.offerManager_ = offerManager;
    }

    public void setSubscriptionManager(SubscriptionManager subscriptionManager) {
        this.subscriptionManager_ = subscriptionManager;
    }

    public boolean hasInterFilterGroupOperatorOR() {
        return this.filterGroupOperator_ != null && this.filterGroupOperator_.value() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractProxy getProxy(int id) throws ProxyNotFound {
        Integer _id = new Integer(id);
        AbstractProxy _servant = null;
        Object object = this.modifyProxiesLock_;
        synchronized (object) {
            _servant = (AbstractProxy)this.pullServants_.get(_id);
            if (_servant == null) {
                _servant = (AbstractProxy)this.pushServants_.get(_id);
            }
        }
        if (_servant == null) {
            throw new ProxyNotFound("The proxy with ID=" + id + " does not exist");
        }
        if (!_servant.isIDPublic()) {
            throw new ProxyNotFound("The proxy with ID=" + id + " is a EventStyle proxy and therefor not accessible by ID");
        }
        return _servant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] get_all_notify_proxies(Map map, Object lock) {
        ArrayList _allIDsList = new ArrayList();
        Object object = lock;
        synchronized (object) {
            Iterator _i = map.entrySet().iterator();
            while (_i.hasNext()) {
                Map.Entry _entry = _i.next();
                if (!((AbstractProxy)_entry.getValue()).isIDPublic()) continue;
                _allIDsList.add(_entry.getKey());
            }
        }
        int[] _allIDsArray = new int[_allIDsList.size()];
        for (int x = 0; x < _allIDsArray.length; ++x) {
            _allIDsArray[x] = (Integer)_allIDsList.get(x);
        }
        return _allIDsArray;
    }

    protected void configureEventStyleID(AbstractProxy proxy) {
        proxy.setID(new Integer(this.getProxyID()), false);
        this.channelContext_.resolveDependencies(proxy);
        proxy.setFilterManager(FilterManager.EMPTY_FILTER_MANAGER);
    }

    protected void configureNotifyStyleID(AbstractProxy proxy) {
        proxy.setID(new Integer(this.getProxyID()), true);
        this.channelContext_.resolveDependencies(proxy);
    }

    protected void configureQoS(AbstractProxy proxy) throws UnsupportedQoS {
        proxy.set_qos(this.qosSettings_.get_qos());
    }

    protected void configureInterFilterGroupOperator(AbstractProxy proxy) {
        if (this.filterGroupOperator_ != null && this.filterGroupOperator_.value() == 1) {
            proxy.setInterFilterGroupOperatorOR(true);
        }
    }

    protected void configureManagers(AbstractProxy proxy) {
        proxy.setOfferManager(this.offerManager_);
        proxy.setSubscriptionManager(this.subscriptionManager_);
    }

    public void preActivate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProxyEventListener(ProxyEventListener l) {
        List list = this.proxyEventListener_;
        synchronized (list) {
            this.proxyEventListener_.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProxyEventListener(ProxyEventListener listener) {
        List list = this.proxyEventListener_;
        synchronized (list) {
            this.proxyEventListener_.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProxyRemoved(AbstractProxy proxy) {
        List list = this.proxyEventListener_;
        synchronized (list) {
            Iterator i = this.proxyEventListener_.iterator();
            ProxyEvent e = new ProxyEvent(proxy);
            while (i.hasNext()) {
                ((ProxyEventListener)i.next()).actionProxyDisposed(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProxyCreated(AbstractProxy proxy) {
        List list = this.proxyEventListener_;
        synchronized (list) {
            Iterator i = this.proxyEventListener_.iterator();
            ProxyEvent e = new ProxyEvent(proxy);
            while (i.hasNext()) {
                ((ProxyEventListener)i.next()).actionProxyCreated(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addProxyToMap(final AbstractProxy proxy, final Map map, final Object lock) {
        Object object = lock;
        synchronized (object) {
            map.put(proxy.getID(), proxy);
            this.fireProxyCreated(proxy);
        }
        proxy.setDisposeHook(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = lock;
                synchronized (object) {
                    map.remove(proxy.getID());
                    AbstractAdmin.this.fireProxyRemoved(proxy);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List getProxies() {
        ArrayList _list = new ArrayList();
        Object object = this.modifyProxiesLock_;
        synchronized (object) {
            _list.addAll(this.pullServants_.values());
            _list.addAll(this.pushServants_.values());
        }
        return _list;
    }

    public final void setChannelContext(ChannelContext context) {
        this.channelContext_ = context;
    }

    public ChannelContext getChannelContext() {
        return this.channelContext_;
    }
}

