/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.queue;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.jacorb.notification.queue.AbstractBoundedEventQueue;
import org.jacorb.notification.queue.BoundedDeadlineEventQueue;
import org.jacorb.notification.queue.BoundedFifoEventQueue;
import org.jacorb.notification.queue.BoundedPriorityEventQueue;
import org.jacorb.notification.queue.EventQueue;
import org.jacorb.notification.queue.EventQueueOverflowStrategy;
import org.jacorb.notification.util.QoSPropertySet;
import org.omg.CosNotification.UnsupportedQoS;

public class EventQueueFactory
implements Configurable {
    private static final short UNKNOWN_POLICY = Short.MIN_VALUE;
    private static final Map mapOrderPolicyNameToValue = new HashMap();
    private static final Map mapDiscardPolicyNameToValue = new HashMap();
    private static final String[] mapOrderPolicyValueToName;
    private static final String[] mapDiscardPolicyValueToName;
    private String orderPolicy_;
    private String discardPolicy_;

    public void configure(Configuration conf) {
        this.orderPolicy_ = conf.getAttribute("jacorb.notification.order_policy", "PriorityOrder");
        this.discardPolicy_ = conf.getAttribute("jacorb.notification.discard_policy", "PriorityOrder");
    }

    /*
     * WARNING - void declaration
     */
    public EventQueue newEventQueue(QoSPropertySet qosProperties) throws UnsupportedQoS {
        void var5_6;
        int maxEventsPerConsumer;
        short shortOrderPolicy = EventQueueFactory.orderPolicyNameToValue(this.orderPolicy_);
        short shortDiscardPolicy = EventQueueFactory.discardPolicyNameToValue(this.discardPolicy_);
        try {
            maxEventsPerConsumer = qosProperties.get("MaxEventsPerConsumer").extract_long();
        }
        catch (Exception e) {
            maxEventsPerConsumer = 100;
        }
        if (qosProperties.containsKey("OrderPolicy")) {
            shortOrderPolicy = qosProperties.get("OrderPolicy").extract_short();
        }
        if (qosProperties.containsKey("DiscardPolicy")) {
            shortDiscardPolicy = qosProperties.get("DiscardPolicy").extract_short();
        }
        switch (shortOrderPolicy) {
            case 0: 
            case 1: {
                AbstractBoundedEventQueue queue = new BoundedFifoEventQueue(maxEventsPerConsumer);
                break;
            }
            case 2: {
                AbstractBoundedEventQueue queue = new BoundedPriorityEventQueue(maxEventsPerConsumer);
                break;
            }
            case 3: {
                AbstractBoundedEventQueue queue = new BoundedDeadlineEventQueue(maxEventsPerConsumer);
                break;
            }
            default: {
                throw new IllegalArgumentException("Orderpolicy: " + this.orderPolicy_ + " OrderPolicyValue: " + shortOrderPolicy + " unknown");
            }
        }
        switch (shortDiscardPolicy) {
            case 0: 
            case 1: {
                var5_6.setOverflowStrategy(EventQueueOverflowStrategy.FIFO);
                break;
            }
            case 4: {
                var5_6.setOverflowStrategy(EventQueueOverflowStrategy.LIFO);
                break;
            }
            case 2: {
                var5_6.setOverflowStrategy(EventQueueOverflowStrategy.LEAST_PRIORITY);
                break;
            }
            case 3: {
                var5_6.setOverflowStrategy(EventQueueOverflowStrategy.EARLIEST_TIMEOUT);
                break;
            }
            default: {
                throw new IllegalArgumentException("Discardpolicy: " + this.discardPolicy_ + "DiscardPolicyValue: " + shortDiscardPolicy + " unknown");
            }
        }
        return var5_6;
    }

    public static short orderPolicyNameToValue(String orderPolicyName) {
        if (mapOrderPolicyNameToValue.containsKey(orderPolicyName)) {
            return (Short)mapOrderPolicyNameToValue.get(orderPolicyName);
        }
        return Short.MIN_VALUE;
    }

    public static short discardPolicyNameToValue(String discardPolicyName) {
        if (mapDiscardPolicyNameToValue.containsKey(discardPolicyName)) {
            return (Short)mapDiscardPolicyNameToValue.get(discardPolicyName);
        }
        return Short.MIN_VALUE;
    }

    static {
        mapOrderPolicyNameToValue.put("AnyOrder", new Short(0));
        mapOrderPolicyNameToValue.put("FifoOrder", new Short(1));
        mapOrderPolicyNameToValue.put("PriorityOrder", new Short(2));
        mapOrderPolicyNameToValue.put("DeadlineOrder", new Short(3));
        mapOrderPolicyValueToName = new String[]{"AnyOrder", "FifoOrder", "PriorityOrder", "DeadlineOrder"};
        mapDiscardPolicyNameToValue.put("AnyOrder", new Short(0));
        mapDiscardPolicyNameToValue.put("FifoOrder", new Short(1));
        mapDiscardPolicyNameToValue.put("LifoOrder", new Short(4));
        mapDiscardPolicyNameToValue.put("PriorityOrder", new Short(2));
        mapDiscardPolicyNameToValue.put("DeadlineOrder", new Short(3));
        mapDiscardPolicyValueToName = new String[]{"AnyOrder", "FifoOrder", "PriorityOrder", "DeadlineOrder", "LifoOrder"};
    }
}

