/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.queue;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.queue.AbstractBoundedEventQueue;
import org.jacorb.notification.queue.EventQueueOverflowStrategy;
import org.jacorb.notification.queue.QueueUtil;

public class BoundedFifoEventQueue
extends AbstractBoundedEventQueue {
    private LinkedList linkedList_ = new LinkedList();

    public BoundedFifoEventQueue(int maxSize, EventQueueOverflowStrategy overflowStrategy) {
        super(maxSize, overflowStrategy);
    }

    BoundedFifoEventQueue(int maxSize) {
        super(maxSize);
    }

    public boolean isEmpty() {
        return this.linkedList_.isEmpty();
    }

    public int getSize() {
        return this.linkedList_.size();
    }

    protected Message getEarliestTimeout() {
        List _sorted = (List)this.linkedList_.clone();
        Collections.sort(_sorted, QueueUtil.ASCENDING_TIMEOUT_COMPARATOR);
        Message _event = (Message)_sorted.get(0);
        this.linkedList_.remove(_event);
        return _event;
    }

    protected Message getLeastPriority() {
        List _sorted = (List)this.linkedList_.clone();
        Collections.sort(_sorted, QueueUtil.ASCENDING_PRIORITY_COMPARATOR);
        Message _event = (Message)_sorted.get(0);
        this.linkedList_.remove(_event);
        return _event;
    }

    protected Message getNextElement() {
        return this.getOldestElement();
    }

    protected Message getOldestElement() {
        return (Message)this.linkedList_.removeFirst();
    }

    protected Message getYoungestElement() {
        return (Message)this.linkedList_.removeLast();
    }

    protected Message[] getAllElements() {
        return this.linkedList_.toArray(QueueUtil.NOTIFICATION_EVENT_ARRAY_TEMPLATE);
    }

    protected void addElement(Message e) {
        this.linkedList_.add(e);
    }

    protected Iterator getListIterator() {
        return this.linkedList_.iterator();
    }

    protected void removeElement(Message e) {
        this.linkedList_.remove(e);
    }

    protected Message[] getElements(int max) {
        int _retSize = max > this.linkedList_.size() ? this.linkedList_.size() : max;
        Message[] _ret = new Message[_retSize];
        for (int x = 0; x < _retSize; ++x) {
            _ret[x] = (Message)this.linkedList_.removeFirst();
        }
        return _ret;
    }
}

