/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter.etcl;

import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.etcl.AbstractTCLNode;
import org.jacorb.notification.filter.etcl.ArrayOperator;
import org.jacorb.notification.filter.etcl.AssocOperator;
import org.jacorb.notification.filter.etcl.IdentValue;
import org.jacorb.notification.filter.etcl.ImplicitOperator;
import org.jacorb.notification.filter.etcl.ImplicitOperatorNode;
import org.jacorb.notification.filter.etcl.NumberValue;
import org.jacorb.notification.filter.etcl.UnionPositionOperator;
import org.omg.CORBA.Any;

public class MessageUtils {
    private MessageUtils() {
    }

    public static EvaluationResult extractFromAny(AbstractTCLNode expr, Any any, EvaluationContext evaluationContext, String rootName) throws EvaluationException {
        EvaluationResult _ret = null;
        Any _result = null;
        Any _currentAny = any;
        StringBuffer _currentPath = new StringBuffer(rootName);
        for (AbstractTCLNode _currentOperator = expr; _currentOperator != null; _currentOperator = (AbstractTCLNode)_currentOperator.getNextSibling()) {
            _currentPath.append(_currentOperator.toString());
            _result = evaluationContext.lookupAny(_currentPath.toString());
            if (_result == null) {
                switch (_currentOperator.getType()) {
                    case 6: {
                        break;
                    }
                    case 32: {
                        UnionPositionOperator _upo = (UnionPositionOperator)_currentOperator;
                        if (_upo.isDefault()) {
                            _result = evaluationContext.getDynamicEvaluator().evaluateUnion(_currentAny);
                            break;
                        }
                        _result = evaluationContext.getDynamicEvaluator().evaluateUnion(_currentAny, _upo.getPosition());
                        break;
                    }
                    case 11: {
                        String _identifer = ((IdentValue)_currentOperator).getIdentifier();
                        _result = evaluationContext.getDynamicEvaluator().evaluateIdentifier(_currentAny, _identifer);
                        break;
                    }
                    case 21: {
                        int _pos = ((NumberValue)_currentOperator).getNumber().intValue();
                        _result = evaluationContext.getDynamicEvaluator().evaluateIdentifier(_currentAny, _pos);
                        break;
                    }
                    case 33: {
                        ImplicitOperator _op = ((ImplicitOperatorNode)_currentOperator).getOperator();
                        _result = _op.evaluateImplicit(evaluationContext, _currentAny);
                        _ret = EvaluationResult.fromAny(_result);
                        _ret.addAny(_currentAny);
                        return _ret;
                    }
                    case 30: {
                        int _arrayIndex = ((ArrayOperator)_currentOperator).getArrayIndex();
                        _result = evaluationContext.getDynamicEvaluator().evaluateArrayIndex(_currentAny, _arrayIndex);
                        break;
                    }
                    case 31: {
                        String _assocName = ((AssocOperator)_currentOperator).getAssocName();
                        _result = evaluationContext.getDynamicEvaluator().evaluateNamedValueList(_currentAny, _assocName);
                        break;
                    }
                    default: {
                        throw new RuntimeException("unexpected operator: " + AbstractTCLNode.getNameForType(_currentOperator.getType()));
                    }
                }
            }
            if (_result == null) continue;
            evaluationContext.storeAny(_currentPath.toString(), _result);
            _currentAny = _result;
        }
        _ret = EvaluationResult.fromAny(_result);
        return _ret;
    }

    public static EvaluationException getException(Exception e) {
        return new EvaluationException();
    }

    public static EvaluationException getException() {
        return new EvaluationException();
    }
}

