/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter.etcl;

import antlr.Token;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.etcl.AbstractTCLVisitor;
import org.jacorb.notification.filter.etcl.BinaryOperator;
import org.jacorb.notification.filter.etcl.VisitorException;

public class EqOperator
extends BinaryOperator {
    private static final String VALUE = "==";

    public EqOperator(Token tok) {
        super(tok);
    }

    public EvaluationResult evaluate(EvaluationContext context, EvaluationResult left, EvaluationResult right) throws EvaluationException {
        if (left.compareTo(right) == 0) {
            return EvaluationResult.BOOL_TRUE;
        }
        return EvaluationResult.BOOL_FALSE;
    }

    public String toString() {
        return VALUE;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void acceptInOrder(AbstractTCLVisitor visitor) throws VisitorException {
        this.left().acceptInOrder(visitor);
        visitor.visitEq(this);
        this.right().acceptInOrder(visitor);
    }

    public void acceptPreOrder(AbstractTCLVisitor visitor) throws VisitorException {
        visitor.visitEq(this);
        this.left().acceptPreOrder(visitor);
        this.right().acceptPreOrder(visitor);
    }

    public void acceptPostOrder(AbstractTCLVisitor visitor) throws VisitorException {
        this.left().acceptPostOrder(visitor);
        this.right().acceptPostOrder(visitor);
        visitor.visitEq(this);
    }
}

