/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.jacorb.notification.engine.AbstractDeliverTask;
import org.jacorb.notification.engine.AbstractTaskPool;
import org.jacorb.notification.engine.FilterConsumerAdminTask;
import org.jacorb.notification.engine.FilterProxyConsumerTask;
import org.jacorb.notification.engine.FilterProxySupplierTask;
import org.jacorb.notification.engine.FilterSupplierAdminTask;
import org.jacorb.notification.engine.PushToConsumerTask;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.Message;

public class TaskFactory
implements Disposable,
Configurable {
    private TaskProcessor taskProcessor_;
    private AbstractTaskPool filterProxyConsumerTaskPool_ = new AbstractTaskPool("FilterProxyConsumerTaskPool"){

        public Object newInstance() {
            return new FilterProxyConsumerTask(TaskFactory.this.taskProcessor_.getFilterTaskExecutor(), TaskFactory.this.taskProcessor_, TaskFactory.this);
        }
    };
    private AbstractTaskPool filterSupplierAdminTaskPool_ = new AbstractTaskPool("FilterSupplierAdminTaskPool"){

        public Object newInstance() {
            return new FilterSupplierAdminTask(TaskFactory.this.taskProcessor_.getFilterTaskExecutor(), TaskFactory.this.taskProcessor_, TaskFactory.this);
        }
    };
    private AbstractTaskPool filterConsumerAdminTaskPool_ = new AbstractTaskPool("FilterConsumerAdminTaskPool"){

        public Object newInstance() {
            return new FilterConsumerAdminTask(TaskFactory.this.taskProcessor_.getFilterTaskExecutor(), TaskFactory.this.taskProcessor_, TaskFactory.this);
        }
    };
    private AbstractTaskPool filterProxySupplierTaskPool_ = new AbstractTaskPool("FilterProxySupplierTaskPool"){

        public Object newInstance() {
            return new FilterProxySupplierTask(TaskFactory.this.taskProcessor_.getFilterTaskExecutor(), TaskFactory.this.taskProcessor_, TaskFactory.this);
        }
    };
    private AbstractTaskPool deliverTaskPool_ = new AbstractTaskPool("PushToConsumerTaskPool"){

        public Object newInstance() {
            PushToConsumerTask _task = new PushToConsumerTask(TaskFactory.this.taskProcessor_);
            return _task;
        }
    };

    public TaskFactory(TaskProcessor taskProcessor) {
        this.taskProcessor_ = taskProcessor;
    }

    public void configure(Configuration conf) {
        this.filterProxyConsumerTaskPool_.configure(conf);
        this.filterProxySupplierTaskPool_.configure(conf);
        this.filterConsumerAdminTaskPool_.configure(conf);
        this.filterSupplierAdminTaskPool_.configure(conf);
        this.deliverTaskPool_.configure(conf);
    }

    public void dispose() {
        this.filterProxyConsumerTaskPool_.dispose();
        this.filterProxySupplierTaskPool_.dispose();
        this.filterConsumerAdminTaskPool_.dispose();
        this.filterSupplierAdminTaskPool_.dispose();
        this.deliverTaskPool_.dispose();
    }

    private FilterProxyConsumerTask newFilterProxyConsumerTask() {
        return (FilterProxyConsumerTask)this.filterProxyConsumerTaskPool_.lendObject();
    }

    FilterProxyConsumerTask newFilterProxyConsumerTask(Message message) {
        FilterProxyConsumerTask task = this.newFilterProxyConsumerTask();
        task.setMessage(message);
        task.setCurrentFilterStage(new FilterStage[]{message.getInitialFilterStage()});
        return task;
    }

    private FilterSupplierAdminTask newFilterSupplierAdminTask() {
        return (FilterSupplierAdminTask)this.filterSupplierAdminTaskPool_.lendObject();
    }

    FilterSupplierAdminTask newFilterSupplierAdminTask(FilterProxyConsumerTask t) {
        FilterSupplierAdminTask task = this.newFilterSupplierAdminTask();
        if (t.getFilterStageToBeProcessed().length != 1) {
            throw new RuntimeException();
        }
        task.setMessage(t.removeMessage());
        task.setCurrentFilterStage(t.getFilterStageToBeProcessed());
        task.setSkip(t.getSkip());
        return task;
    }

    private FilterConsumerAdminTask newFilterConsumerAdminTask() {
        return (FilterConsumerAdminTask)this.filterConsumerAdminTaskPool_.lendObject();
    }

    FilterConsumerAdminTask newFilterConsumerAdminTask(FilterSupplierAdminTask t) {
        FilterConsumerAdminTask task = this.newFilterConsumerAdminTask();
        task.setMessage(t.removeMessage());
        task.setCurrentFilterStage(t.getFilterStageToBeProcessed());
        return task;
    }

    private FilterProxySupplierTask newFilterProxySupplierTask() {
        return (FilterProxySupplierTask)this.filterProxySupplierTaskPool_.lendObject();
    }

    FilterProxySupplierTask newFilterProxySupplierTask(FilterConsumerAdminTask task) {
        FilterProxySupplierTask _newTask = this.newFilterProxySupplierTask();
        _newTask.setMessage(task.removeMessage());
        FilterStage[] _filterStageList = task.getFilterStageToBeProcessed();
        _newTask.setCurrentFilterStage(_filterStageList);
        return _newTask;
    }

    AbstractDeliverTask[] newPushToConsumerTask(FilterStage[] nodes, Message event) {
        return this.newPushToConsumerTask(nodes, event, FilterProxySupplierTask.EMPTY_MAP);
    }

    private AbstractDeliverTask[] newPushToConsumerTask(FilterStage[] filterStagesWithMessageConsumer, Message defaultMessage, FilterProxySupplierTask.AlternateMessageMap map) {
        AbstractDeliverTask[] _seqPushToConsumerTask = new AbstractDeliverTask[filterStagesWithMessageConsumer.length];
        for (int x = 0; x < filterStagesWithMessageConsumer.length; ++x) {
            _seqPushToConsumerTask[x] = (AbstractDeliverTask)this.deliverTaskPool_.lendObject();
            _seqPushToConsumerTask[x].setMessageConsumer(filterStagesWithMessageConsumer[x].getMessageConsumer());
            Message _alternateEvent = map.getAlternateMessage(filterStagesWithMessageConsumer[x]);
            if (_alternateEvent != null) {
                _seqPushToConsumerTask[x].setMessage(_alternateEvent);
                continue;
            }
            if (x == 0) {
                _seqPushToConsumerTask[x].setMessage(defaultMessage);
                continue;
            }
            _seqPushToConsumerTask[x].setMessage((Message)defaultMessage.clone());
        }
        return _seqPushToConsumerTask;
    }

    AbstractDeliverTask[] newPushToConsumerTask(FilterProxySupplierTask task) {
        Message _notificationEvent = task.removeMessage();
        FilterStage[] _seqFilterStageToBeProcessed = task.getFilterStageToBeProcessed();
        AbstractDeliverTask[] _deliverTasks = this.newPushToConsumerTask(_seqFilterStageToBeProcessed, _notificationEvent, task.changedMessages_);
        return _deliverTasks;
    }
}

