/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.DirectExecutor;
import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import org.jacorb.notification.interfaces.Disposable;

public class TaskExecutor
implements Executor,
Disposable {
    private static final TaskExecutor DIRECT_EXECUTOR = new TaskExecutor("Direct", 0);
    private Executor executor_;
    private LinkedQueue channel_;

    public static TaskExecutor getDefaultExecutor() {
        return DIRECT_EXECUTOR;
    }

    public TaskExecutor(String name, int numberOfThreads) {
        this(name, numberOfThreads, false);
    }

    public TaskExecutor(final String name, int numberOfThreads, boolean mayDie) {
        if (numberOfThreads < 0) {
            throw new IllegalArgumentException();
        }
        if (numberOfThreads == 0) {
            this.executor_ = new DirectExecutor();
        } else {
            ThreadFactory _threadFactory = new ThreadFactory(){
                private int counter_ = 0;

                public synchronized Thread newThread(Runnable task) {
                    Thread _thread = new Thread(task);
                    _thread.setDaemon(true);
                    _thread.setName(name + "#" + this.counter_++);
                    return _thread;
                }
            };
            this.channel_ = new LinkedQueue();
            PooledExecutor _executor = new PooledExecutor((Channel)this.channel_);
            _executor.setThreadFactory(_threadFactory);
            if (!mayDie) {
                _executor.setKeepAliveTime(-1L);
            }
            _executor.createThreads(numberOfThreads);
            this.executor_ = _executor;
        }
    }

    public boolean isTaskQueued() {
        if (this.channel_ != null) {
            return !this.channel_.isEmpty();
        }
        return false;
    }

    public void dispose() {
        if (this.executor_ instanceof PooledExecutor) {
            ((PooledExecutor)this.executor_).shutdownNow();
            ((PooledExecutor)this.executor_).interruptAll();
        }
    }

    public void execute(Runnable r) throws InterruptedException {
        this.executor_.execute(r);
    }
}

