/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jacorb.notification.engine.AbstractDeliverTask;
import org.jacorb.notification.engine.AbstractFilterTask;
import org.jacorb.notification.engine.FilterProxySupplierTask;
import org.jacorb.notification.engine.TaskExecutor;
import org.jacorb.notification.engine.TaskFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.FilterStage;

public class FilterConsumerAdminTask
extends AbstractFilterTask {
    private static final FilterStage[] NO_CURRENT_FILTER_STAGE = new FilterStage[0];
    private static int sCount = 0;
    private int id_ = ++sCount;
    protected List listOfFilterStageWithMessageConsumer_ = new ArrayList();

    FilterConsumerAdminTask(TaskExecutor te, TaskProcessor tp, TaskFactory tc) {
        super(te, tp, tc);
    }

    public String toString() {
        return "[FilterConsumerAdminTask#" + this.id_ + "]";
    }

    public void setFilterStage(AbstractFilterTask other) {
        this.arrayCurrentFilterStage_ = other.getFilterStageToBeProcessed();
    }

    public FilterStage[] getFilterStagesWithMessageConsumer() {
        return this.listOfFilterStageWithMessageConsumer_.toArray(FILTERSTAGE_ARRAY_TEMPLATE);
    }

    private void clearFilterStagesWithMessageConsumer() {
        this.listOfFilterStageWithMessageConsumer_.clear();
    }

    public void reset() {
        super.reset();
        this.clearFilterStagesWithMessageConsumer();
        this.arrayCurrentFilterStage_ = NO_CURRENT_FILTER_STAGE;
    }

    public void doWork() throws InterruptedException {
        this.logger_.debug("doWork");
        if (this.arrayCurrentFilterStage_.length > 0) {
            this.filter();
            this.pushToConsumers();
        } else {
            this.logger_.debug("No ConsumerAdmin connected");
            this.message_.dispose();
        }
        this.dispose();
    }

    private void pushToConsumers() throws InterruptedException {
        FilterStage[] _filterStagesWithMessageConsumer = this.getFilterStagesWithMessageConsumer();
        FilterProxySupplierTask _filterTaskToBeScheduled = null;
        if (_filterStagesWithMessageConsumer.length > 0) {
            AbstractDeliverTask[] _listOfPushToConsumerTaskToBeScheduled = null;
            _listOfPushToConsumerTaskToBeScheduled = this.getTaskFactory().newPushToConsumerTask(_filterStagesWithMessageConsumer, this.copyMessage());
            AbstractDeliverTask.scheduleTasks(_listOfPushToConsumerTaskToBeScheduled);
        }
        _filterTaskToBeScheduled = this.getTaskFactory().newFilterProxySupplierTask(this);
        _filterTaskToBeScheduled.schedule();
    }

    private void filter() throws InterruptedException {
        for (int x = 0; x < this.arrayCurrentFilterStage_.length; ++x) {
            this.checkInterrupt();
            boolean _filterForCurrentFilterStageMatched = false;
            if (!this.arrayCurrentFilterStage_[x].isDisposed()) {
                _filterForCurrentFilterStageMatched = this.message_.match(this.arrayCurrentFilterStage_[x]);
            }
            if (_filterForCurrentFilterStageMatched) {
                if (this.arrayCurrentFilterStage_[x].hasInterFilterGroupOperatorOR()) {
                    this.listOfFilterStageWithMessageConsumer_.addAll(this.arrayCurrentFilterStage_[x].getSubsequentFilterStages());
                    continue;
                }
                this.addFilterStage(this.arrayCurrentFilterStage_[x].getSubsequentFilterStages());
                continue;
            }
            Iterator _i = this.arrayCurrentFilterStage_[x].getSubsequentFilterStages().iterator();
            while (_i.hasNext()) {
                FilterStage _n = (FilterStage)_i.next();
                if (!_n.hasInterFilterGroupOperatorOR()) continue;
                this.addFilterStage(_n);
            }
        }
    }
}

