/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jacorb.notification.engine.AbstractTask;
import org.jacorb.notification.engine.TaskExecutor;
import org.jacorb.notification.engine.TaskFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.FilterStage;

abstract class AbstractFilterTask
extends AbstractTask {
    private TaskFactory taskFactory_;
    private static final boolean STRICT_CHECKING = true;
    protected static final FilterStage[] FILTERSTAGE_ARRAY_TEMPLATE = new FilterStage[0];
    protected FilterStage[] arrayCurrentFilterStage_;
    private List listOfFilterStageToBeProcessed_ = new ArrayList();

    AbstractFilterTask(TaskExecutor executor, TaskProcessor tp, TaskFactory tc) {
        super(tp);
        this.setTaskExecutor(executor);
        this.taskFactory_ = tc;
    }

    protected TaskFactory getTaskFactory() {
        return this.taskFactory_;
    }

    protected boolean isFilterStageListEmpty() {
        return this.listOfFilterStageToBeProcessed_.isEmpty();
    }

    protected void addFilterStage(FilterStage s) {
        this.listOfFilterStageToBeProcessed_.add(s);
    }

    protected void addFilterStage(List s) {
        Iterator i = s.iterator();
        while (i.hasNext()) {
            if (i.next() instanceof FilterStage) continue;
            throw new IllegalArgumentException();
        }
        this.listOfFilterStageToBeProcessed_.addAll(s);
    }

    public void setCurrentFilterStage(FilterStage[] currentFilterStage) {
        this.arrayCurrentFilterStage_ = currentFilterStage;
    }

    public FilterStage[] getFilterStageToBeProcessed() {
        return this.listOfFilterStageToBeProcessed_.toArray(FILTERSTAGE_ARRAY_TEMPLATE);
    }

    public void clearFilterStageToBeProcessed() {
        this.listOfFilterStageToBeProcessed_.clear();
    }

    public synchronized void reset() {
        super.reset();
        this.clearFilterStageToBeProcessed();
    }

    public void handleTaskError(AbstractTask task, Throwable error) {
        this.logger_.fatalError("Error while Filtering in Task:" + task, error);
    }

    public void schedule() throws InterruptedException {
        this.schedule(!this.getTaskExecutor().isTaskQueued());
    }
}

