/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.jacorb.notification.AnyMessage;
import org.jacorb.notification.StructuredEventMessage;
import org.jacorb.notification.TypedEventMessage;
import org.jacorb.notification.interfaces.AbstractPoolable;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.servant.AbstractProxyConsumerI;
import org.jacorb.notification.util.AbstractObjectPool;
import org.omg.CORBA.Any;
import org.omg.CORBA.Bounds;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotification.StructuredEventHelper;

public class MessageFactory
implements Disposable,
Configurable {
    private AbstractObjectPool typedEventMessagePool_ = new AbstractObjectPool("TypedEventMessagePool"){

        public Object newInstance() {
            return new TypedEventMessage();
        }

        public void activateObject(Object o) {
            AbstractPoolable obj = (AbstractPoolable)o;
            obj.reset();
            obj.setObjectPool(this);
        }
    };
    private AbstractObjectPool anyMessagePool_ = new AbstractObjectPool("AnyMessagePool"){

        public Object newInstance() {
            return new AnyMessage();
        }

        public void activateObject(Object o) {
            AbstractPoolable obj = (AbstractPoolable)o;
            obj.reset();
            obj.setObjectPool(this);
        }
    };
    private AbstractObjectPool structuredEventMessagePool_ = new AbstractObjectPool("StructuredEventMessagePool"){

        public Object newInstance() {
            return new StructuredEventMessage();
        }

        public void activateObject(Object o) {
            AbstractPoolable obj = (AbstractPoolable)o;
            obj.reset();
            obj.setObjectPool(this);
        }
    };

    public void configure(Configuration conf) {
        this.anyMessagePool_.configure(conf);
        this.structuredEventMessagePool_.configure(conf);
        this.typedEventMessagePool_.configure(conf);
    }

    public void dispose() {
        this.structuredEventMessagePool_.dispose();
        this.anyMessagePool_.dispose();
        this.typedEventMessagePool_.dispose();
    }

    public Message newMessage(Any any, AbstractProxyConsumerI consumer) {
        if (StructuredEventHelper.type().equals(any.type())) {
            return this.newMessage(StructuredEventHelper.extract(any), consumer);
        }
        Message _mesg = this.newMessage(any);
        _mesg.setInitialFilterStage(consumer.getFirstStage());
        return _mesg;
    }

    public Message newMessage(StructuredEvent structuredEvent, AbstractProxyConsumerI consumer) {
        String _typeName = structuredEvent.header.fixed_header.event_type.type_name;
        if ("%ANY".equals(_typeName)) {
            return this.newMessage(structuredEvent.remainder_of_body, consumer);
        }
        StructuredEventMessage _mesg = (StructuredEventMessage)this.structuredEventMessagePool_.lendObject();
        _mesg.setFilterStage(consumer.getFirstStage());
        _mesg.setStructuredEvent(structuredEvent, consumer.isStartTimeSupported(), consumer.isTimeOutSupported());
        return _mesg.getHandle();
    }

    public Message newMessage(String interfaceName, String operationName, NVList args, AbstractProxyConsumerI consumer) {
        try {
            TypedEventMessage _mesg = (TypedEventMessage)this.typedEventMessagePool_.lendObject();
            Property[] _props = new Property[args.count()];
            for (int x = 0; x < _props.length; ++x) {
                NamedValue _nv = args.item(x);
                _props[x] = new Property(_nv.name(), _nv.value());
            }
            _mesg.setTypedEvent(interfaceName, operationName, _props);
            Message _handle = _mesg.getHandle();
            _handle.setInitialFilterStage(consumer.getFirstStage());
            return _handle;
        }
        catch (Bounds e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public Message newMessage(Property[] props) {
        TypedEventMessage _mesg = (TypedEventMessage)this.typedEventMessagePool_.lendObject();
        _mesg.setTypedEvent(props);
        return _mesg.getHandle();
    }

    public Message newMessage(Any any) {
        if (StructuredEventHelper.type().equals(any.type())) {
            return this.newMessage(StructuredEventHelper.extract(any));
        }
        AnyMessage _mesg = (AnyMessage)this.anyMessagePool_.lendObject();
        _mesg.setAny(any);
        return _mesg.getHandle();
    }

    public Message newMessage(StructuredEvent structuredEvent) {
        String _typeName = structuredEvent.header.fixed_header.event_type.type_name;
        if ("%ANY".equals(_typeName)) {
            return this.newMessage(structuredEvent.remainder_of_body);
        }
        StructuredEventMessage _mesg = (StructuredEventMessage)this.structuredEventMessagePool_.lendObject();
        _mesg.setStructuredEvent(structuredEvent, false, false);
        return _mesg.getHandle();
    }
}

