/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import java.util.Properties;
import org.jacorb.notification.AbstractChannelFactory;

public class ConsoleMain {
    private static void help() {
        System.out.println("Usage: ntfy [-printIOR] [-printCorbaloc] [-writeIOR <filename>] [-registerName <nameId>[.<nameKind>]] [-port <oaPort>] [-channels <channels>] [-help]");
        System.exit(0);
    }

    public static AbstractChannelFactory newFactory(String[] args) throws Exception {
        CmdLineParser _cmdLineParser = new CmdLineParser(args);
        if (_cmdLineParser.getDoHelp()) {
            ConsoleMain.help();
            System.exit(0);
        }
        Properties props = _cmdLineParser.getProps();
        AbstractChannelFactory _factory = AbstractChannelFactory.newFactory(props);
        return _factory;
    }

    public static final void main(String[] args) throws Exception {
        ConsoleMain.newFactory(args);
    }

    private static class CmdLineParser {
        private boolean doHelp = false;
        private Properties props = new Properties();

        public boolean getDoHelp() {
            return this.doHelp;
        }

        public Properties getProps() {
            return this.props;
        }

        CmdLineParser(String[] args) {
            this.perform(args);
        }

        private void perform(String[] args) throws IllegalArgumentException {
            try {
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].equals("-printIOR")) {
                        this.props.put("jacorb.notification.print_ior", "on");
                        continue;
                    }
                    if (args[i].equals("-printCorbaloc")) {
                        this.props.put("jacorb.notification.print_corbaloc", "on");
                        continue;
                    }
                    if (args[i].equals("-help")) {
                        this.doHelp = true;
                        continue;
                    }
                    if (args[i].equals("-port")) {
                        this.props.put("OAPort", args[++i]);
                        continue;
                    }
                    if (args[i].equals("-channels")) {
                        this.props.put("jacorb.notification.start_channels", args[++i]);
                        continue;
                    }
                    if (args[i].equals("-writeIOR")) {
                        this.props.put("jacorb.notification.ior_file", args[++i]);
                        continue;
                    }
                    if (args[i].equals("-registerName")) {
                        String name = args[++i];
                        int index = name.indexOf(".");
                        if (name.lastIndexOf(".") != index) {
                            throw new IllegalArgumentException(name + ": argument to -registerName should be " + "<nameId> or <nameId>.<nameKind>");
                        }
                        if (index != -1) {
                            this.props.put("jacorb.notification.register_name.id", name.substring(0, index));
                            this.props.put("jacorb.notification.register_name.kind", name.substring(index + 1));
                            continue;
                        }
                        this.props.put("jacorb.notification.register_name.id", name);
                        continue;
                    }
                    if (args[i].equals("-typed")) {
                        this.props.put("jacorb.notification.enable_typed_channel", "on");
                        continue;
                    }
                    System.out.println("Unknown argument: " + args[i]);
                    this.doHelp = true;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.doHelp = true;
            }
        }
    }
}

