/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.jacorb.notification.NoTranslationException;
import org.jacorb.notification.filter.ComponentName;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.RuntimeVariable;
import org.jacorb.notification.interfaces.AbstractPoolable;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.Message;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnyHolder;
import org.omg.CORBA.ORB;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;

public abstract class AbstractMessage
extends AbstractPoolable {
    int x;
    static final ORB sOrb = ORB.init();
    protected boolean proxyConsumerFiltered_;
    protected boolean supplierAdminFiltered_;
    protected boolean consumerAdminFiltered_;
    protected boolean proxySupplierFiltered_;
    private FilterStage currentFilterStage_;
    protected int referenced_ = 0;

    public abstract String getConstraintKey();

    public abstract Any toAny();

    public abstract Property[] toTypedEvent() throws NoTranslationException;

    public abstract StructuredEvent toStructuredEvent();

    public abstract int getType();

    public void reset() {
        this.referenced_ = 0;
        this.currentFilterStage_ = null;
    }

    public synchronized void addReference() {
        ++this.referenced_;
    }

    protected synchronized void removeReference() {
        if (this.referenced_ > 0) {
            --this.referenced_;
        }
        if (this.referenced_ == 0) {
            super.dispose();
        }
    }

    public void setFilterStage(FilterStage node) {
        this.currentFilterStage_ = node;
    }

    public FilterStage getFilterStage() {
        return this.currentFilterStage_;
    }

    public EvaluationResult extractValue(EvaluationContext context, ComponentName componentRootNode, RuntimeVariable runtimeVariable) throws EvaluationException {
        EvaluationResult _ret = null;
        String _completePath = componentRootNode.getComponentName();
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("extractValue: " + _completePath);
            this.logger_.debug("runtimeVariable=" + runtimeVariable);
        }
        if ((_ret = context.lookupResult(_completePath)) == null) {
            _ret = runtimeVariable.evaluate(context);
            _ret = context.extractFromMessage(this, _ret, componentRootNode, runtimeVariable);
            context.storeResult(_completePath, _ret);
        }
        if (_ret == null) {
            throw new EvaluationException("Could not resolve " + _completePath);
        }
        return _ret;
    }

    public abstract EvaluationResult extractFilterableData(EvaluationContext var1, ComponentName var2, String var3) throws EvaluationException;

    public abstract EvaluationResult extractVariableHeader(EvaluationContext var1, ComponentName var2, String var3) throws EvaluationException;

    public EvaluationResult extractValue(EvaluationContext evaluationContext, ComponentName componentRootNode) throws EvaluationException {
        EvaluationResult _ret = null;
        String _completeExpr = componentRootNode.getComponentName();
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("extractValue path: " + componentRootNode.toStringTree() + "\n\tcomplete Expression=" + _completeExpr);
        }
        _ret = evaluationContext.lookupResult(_completeExpr);
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("Cache READ: " + _ret);
        }
        if (_ret == null) {
            this.logger_.debug("Cache MISS");
            _ret = evaluationContext.extractFromMessage(this, componentRootNode);
            if (_ret != null) {
                if (this.logger_.isDebugEnabled()) {
                    this.logger_.debug("Cache WRITE: " + _completeExpr + " => " + _ret);
                }
                evaluationContext.storeResult(_completeExpr, _ret);
            }
        }
        if (_ret == null) {
            throw new EvaluationException("Could not resolve " + _completeExpr);
        }
        return _ret;
    }

    public Message getHandle() {
        return new MessageHandle();
    }

    public abstract boolean hasStartTime();

    public abstract Date getStartTime();

    public abstract boolean hasStopTime();

    public abstract Date getStopTime();

    public abstract boolean hasTimeout();

    public abstract long getTimeout();

    public abstract int getPriority();

    public abstract boolean match(Filter var1) throws UnsupportedFilterableData;

    public boolean match(FilterStage filterStage) {
        List _filterList = filterStage.getFilters();
        if (_filterList.isEmpty()) {
            return true;
        }
        Iterator _filterIterator = _filterList.iterator();
        while (_filterIterator.hasNext()) {
            try {
                Filter _filter = (Filter)_filterIterator.next();
                if (!this.match(_filter)) continue;
                return true;
            }
            catch (UnsupportedFilterableData e) {
                this.logger_.info("unsupported filterable data. match result defaults to false.", (Throwable)e);
            }
        }
        return false;
    }

    public abstract boolean match(MappingFilter var1, AnyHolder var2) throws UnsupportedFilterableData;

    class MessageHandle
    implements Message,
    Disposable {
        private Message.MessageStateListener eventStateListener_;
        private boolean isInvalid_ = false;
        private boolean isDisposed_ = false;
        private boolean isPrioritySet_ = false;
        private int priority_;
        private boolean isTimeoutSet_ = false;
        private long timeOut_;

        MessageHandle() {
            AbstractMessage.this.addReference();
        }

        private MessageHandle(int priority, boolean priorityOverride, long timeout, boolean timeoutOverride) {
            AbstractMessage.this.addReference();
            this.priority_ = priority;
            this.isPrioritySet_ = priorityOverride;
            this.timeOut_ = timeout;
            this.isTimeoutSet_ = timeoutOverride;
        }

        public void setInitialFilterStage(FilterStage s) {
            AbstractMessage.this.setFilterStage(s);
        }

        public FilterStage getInitialFilterStage() {
            return AbstractMessage.this.getFilterStage();
        }

        public String getConstraintKey() {
            return AbstractMessage.this.getConstraintKey();
        }

        public Any toAny() {
            return AbstractMessage.this.toAny();
        }

        public Property[] toTypedEvent() throws NoTranslationException {
            return AbstractMessage.this.toTypedEvent();
        }

        public StructuredEvent toStructuredEvent() {
            return AbstractMessage.this.toStructuredEvent();
        }

        public int getType() {
            return AbstractMessage.this.getType();
        }

        public EvaluationResult extractValue(EvaluationContext context, ComponentName componentName, RuntimeVariable runtimeVariable) throws EvaluationException {
            return AbstractMessage.this.extractValue(context, componentName, runtimeVariable);
        }

        public EvaluationResult extractValue(EvaluationContext context, ComponentName componentName) throws EvaluationException {
            return AbstractMessage.this.extractValue(context, componentName);
        }

        public EvaluationResult extractFilterableData(EvaluationContext context, ComponentName componentRootNode, String variable) throws EvaluationException {
            return AbstractMessage.this.extractFilterableData(context, componentRootNode, variable);
        }

        public EvaluationResult extractVariableHeader(EvaluationContext context, ComponentName componentName, String s) throws EvaluationException {
            return AbstractMessage.this.extractVariableHeader(context, componentName, s);
        }

        public boolean hasStartTime() {
            return AbstractMessage.this.hasStartTime();
        }

        public Date getStartTime() {
            return AbstractMessage.this.getStartTime();
        }

        public boolean hasStopTime() {
            return AbstractMessage.this.hasStopTime();
        }

        public Date getStopTime() {
            return AbstractMessage.this.getStopTime();
        }

        public boolean hasTimeout() {
            return this.isTimeoutSet_ || AbstractMessage.this.hasTimeout();
        }

        public long getTimeout() {
            if (this.isTimeoutSet_) {
                return this.timeOut_;
            }
            return AbstractMessage.this.getTimeout();
        }

        public void setTimeout(long timeout) {
            this.timeOut_ = timeout;
            this.isTimeoutSet_ = true;
            if (this.eventStateListener_ != null) {
                this.eventStateListener_.actionLifetimeChanged(timeout);
            }
        }

        public void setPriority(int priority) {
            this.isPrioritySet_ = true;
            this.priority_ = priority;
        }

        public int getPriority() {
            if (this.isPrioritySet_) {
                return this.priority_;
            }
            return AbstractMessage.this.getPriority();
        }

        public boolean match(FilterStage s) {
            return AbstractMessage.this.match(s);
        }

        public boolean match(MappingFilter m, AnyHolder r) throws UnsupportedFilterableData {
            return AbstractMessage.this.match(m, r);
        }

        public Object clone() {
            try {
                this.checkInvalid();
                return new MessageHandle(this.priority_, this.isPrioritySet_, this.timeOut_, this.isTimeoutSet_);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public void dispose() {
            AbstractMessage.this.removeReference();
        }

        public synchronized boolean isInvalid() {
            return this.isInvalid_;
        }

        public void setMessageStateListener(Message.MessageStateListener l) {
            this.eventStateListener_ = l;
        }

        public Message.MessageStateListener removeMessageStateListener() {
            Message.MessageStateListener _l = this.eventStateListener_;
            this.eventStateListener_ = null;
            return _l;
        }

        public synchronized void actionTimeout() {
            this.isInvalid_ = true;
        }

        public String toString() {
            return "[Message/" + AbstractMessage.this + "]";
        }

        private void checkInvalid() throws IllegalArgumentException {
            if (this.isInvalid()) {
                throw new IllegalArgumentException("This Notification has been invalidated");
            }
        }
    }
}

