/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.AbstractEventChannel;
import org.jacorb.notification.ApplicationContext;
import org.jacorb.notification.ChannelContext;
import org.jacorb.notification.ChannelManager;
import org.jacorb.notification.EventChannelFactoryImpl;
import org.jacorb.notification.FilterFactoryImpl;
import org.jacorb.notification.TypedEventChannelFactoryImpl;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.queue.EventQueueFactory;
import org.jacorb.notification.servant.ManageableServant;
import org.jacorb.notification.util.AdminPropertySet;
import org.jacorb.notification.util.PropertySet;
import org.jacorb.notification.util.QoSPropertySet;
import org.omg.CORBA.Any;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.PropertyError;
import org.omg.CosNotification.PropertyRange;
import org.omg.CosNotification.QoSError_code;
import org.omg.CosNotification.UnsupportedAdmin;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.ChannelNotFound;
import org.omg.CosNotifyFilter.FilterFactory;
import org.omg.CosNotifyFilter.FilterFactoryHelper;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;

public abstract class AbstractChannelFactory
implements ManageableServant,
Disposable {
    private static final String STANDARD_IMPL_NAME = "JacORB-NotificationService";
    private static final long SHUTDOWN_INTERVAL = 1000L;
    public static final String EVENTCHANNEL_FACTORY_POA_NAME = "EventChannelFactoryPOA";
    protected Object thisRef_;
    protected Logger logger_ = null;
    protected ChannelContext defaultChannelContext_ = new ChannelContext();
    protected POA rootPOA_;
    protected POA eventChannelFactoryPOA_;
    protected ApplicationContext applicationContext_;
    protected final SynchronizedBoolean filterFactoryStarted_ = new SynchronizedBoolean(false);
    private Servant thisServant_;
    private String ior_;
    private String corbaLoc_;
    private ORB orb_;
    private FilterFactory defaultFilterFactory_;
    private FilterFactoryImpl defaultFilterFactoryServant_;
    private ChannelManager channelManager_ = new ChannelManager();
    private Configuration config_;
    private final SynchronizedInt eventChannelIDPool_ = new SynchronizedInt(-1);
    private NameComponent[] registeredName_ = null;
    private NamingContext namingContext_;
    private Runnable destroyMethod_ = new Runnable(){

        public void run() {
            AbstractChannelFactory.this.dispose();
        }
    };
    static /* synthetic */ Class class$org$jacorb$notification$util$PatternWrapper;

    protected abstract AbstractEventChannel newEventChannel();

    protected abstract Object create_abstract_channel(Property[] var1, Property[] var2, IntHolder var3) throws UnsupportedAdmin, UnsupportedQoS;

    protected abstract String getObjectName();

    protected abstract String getShortcut();

    protected abstract Servant getServant();

    protected int getLocalPort() {
        org.jacorb.orb.ORB jorb = (org.jacorb.orb.ORB)this.getORB();
        return jorb.getBasicAdapter().getPort();
    }

    protected String getLocalAddress() {
        org.jacorb.orb.ORB jorb = (org.jacorb.orb.ORB)this.getORB();
        return jorb.getBasicAdapter().getAddress();
    }

    private String createCorbaLoc(String poaName, byte[] id) {
        StringBuffer _corbaLoc = new StringBuffer("corbaloc::");
        _corbaLoc.append(this.getLocalAddress());
        _corbaLoc.append(":");
        _corbaLoc.append(this.getLocalPort());
        _corbaLoc.append("/");
        _corbaLoc.append(this.getShortcut());
        return _corbaLoc.toString();
    }

    public synchronized Object activate() {
        if (this.thisRef_ == null) {
            try {
                byte[] oid = this.getObjectName().getBytes();
                this.eventChannelFactoryPOA_.activate_object_with_id(oid, this.getServant());
                this.thisRef_ = this.eventChannelFactoryPOA_.id_to_reference(oid);
                if (this.logger_.isDebugEnabled()) {
                    this.logger_.debug("activated EventChannelFactory with OID '" + new String(oid) + "' on '" + this.eventChannelFactoryPOA_.the_name() + "'");
                }
                this.ior_ = this.getORB().object_to_string(this.eventChannelFactoryPOA_.id_to_reference(oid));
                this.corbaLoc_ = this.createCorbaLoc(this.eventChannelFactoryPOA_.the_name(), oid);
                ((org.jacorb.orb.ORB)this.getORB()).addObjectKey(this.getShortcut(), this.ior_);
                this.defaultChannelContext_.setEventChannelFactory(this);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.thisRef_;
    }

    public void setDestroyMethod(Runnable destroyMethod) {
        this.destroyMethod_ = destroyMethod;
    }

    public void setORB(ORB orb) {
        this.orb_ = orb;
        org.jacorb.orb.ORB jorb = (org.jacorb.orb.ORB)this.orb_;
        try {
            Object obj = orb.resolve_initial_references("RootPOA");
            this.rootPOA_ = POAHelper.narrow(obj);
            this.applicationContext_ = new ApplicationContext(orb, this.rootPOA_);
            Policy[] _policies = new Policy[]{this.rootPOA_.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID)};
            this.eventChannelFactoryPOA_ = this.rootPOA_.create_POA(EVENTCHANNEL_FACTORY_POA_NAME, this.rootPOA_.the_POAManager(), _policies);
            for (int x = 0; x < _policies.length; ++x) {
                _policies[x].destroy();
            }
            this.rootPOA_.the_POAManager().activate();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    protected ORB getORB() {
        return this.orb_;
    }

    public void setPOA(POA POA2) {
    }

    public final void deactivate() {
        try {
            this.eventChannelFactoryPOA_.deactivate_object(this.eventChannelFactoryPOA_.servant_to_id(this.getServant()));
        }
        catch (Exception e) {
            this.logger_.fatalError("unable to deactivate object", (Throwable)e);
            throw new RuntimeException();
        }
    }

    public void preActivate() throws Exception {
    }

    public final void configure(Configuration conf) throws ConfigurationException {
        this.config_ = conf;
        this.logger_ = ((org.jacorb.config.Configuration)conf).getNamedLogger(this.getClass().getName());
        this.defaultChannelContext_.configure(conf);
        this.applicationContext_.configure(conf);
        String _filterFactoryConf = conf.getAttribute("jacorb.notification.default_filter_factory", "builtin");
        try {
            this.setUpDefaultFilterFactory(_filterFactoryConf);
        }
        catch (InvalidName ex) {
            this.logger_.error("FilterFactory setup failed", (Throwable)ex);
            throw new ConfigurationException("jacorb.notification.default_filter_factory");
        }
    }

    private void setUpDefaultFilterFactory(String filterFactoryConf) throws InvalidName, ConfigurationException {
        if (!filterFactoryConf.equals("builtin")) {
            try {
                if (this.logger_.isInfoEnabled()) {
                    this.logger_.info("try to set default_filter_factory to '" + filterFactoryConf + "'");
                }
                this.defaultFilterFactory_ = FilterFactoryHelper.narrow(this.getORB().string_to_object(filterFactoryConf));
            }
            catch (Throwable e) {
                this.logger_.error("Could not resolve FilterFactory: '" + filterFactoryConf + "'. Will default to builtin FilterFactory.", e);
            }
        }
        if (this.defaultFilterFactory_ == null) {
            (class$org$jacorb$notification$util$PatternWrapper == null ? (class$org$jacorb$notification$util$PatternWrapper = AbstractChannelFactory.class$("org.jacorb.notification.util.PatternWrapper")) : class$org$jacorb$notification$util$PatternWrapper).getName();
            this.logger_.info("Create FilterFactory");
            this.defaultFilterFactoryServant_ = new FilterFactoryImpl(this.applicationContext_);
            this.defaultFilterFactoryServant_.configure(this.config_);
            this.defaultFilterFactoryServant_.preActivate();
            this.defaultFilterFactory_ = FilterFactoryHelper.narrow(this.defaultFilterFactoryServant_.activate());
            this.filterFactoryStarted_.set(true);
        }
    }

    protected Configuration getConfiguration() {
        return this.config_;
    }

    protected FilterFactory getDefaultFilterFactory() {
        return this.defaultFilterFactory_;
    }

    public void dispose() {
        try {
            this.unregisterName();
        }
        catch (Exception e) {
            this.logger_.error("unable to unregister NameService registration", (Throwable)e);
        }
        this.channelManager_.dispose();
        if (this.defaultFilterFactoryServant_ != null) {
            this.defaultFilterFactoryServant_.dispose();
        }
        this.applicationContext_.dispose();
        this.getORB().shutdown(true);
    }

    protected void addToChannels(int id, AbstractEventChannel channel) {
        this.channelManager_.add_channel(id, channel);
    }

    protected int[] getAllChannels() {
        return this.channelManager_.get_all_channels();
    }

    protected AbstractEventChannel get_event_channel_servant(int id) throws ChannelNotFound {
        return this.channelManager_.get_channel_servant(id);
    }

    protected Iterator getChannelIterator() {
        return this.channelManager_.getChannelIterator();
    }

    protected AbstractEventChannel create_channel_servant(IntHolder id, Property[] qosProps, Property[] adminProps) throws UnsupportedAdmin, UnsupportedQoS, ConfigurationException {
        int _channelID;
        id.value = _channelID = this.createChannelIdentifier();
        if (this.logger_.isInfoEnabled()) {
            this.logger_.debug("create channel_servant id=" + _channelID);
        }
        AdminPropertySet _adminSettings = new AdminPropertySet(this.getConfiguration());
        _adminSettings.set_admin(adminProps);
        QoSPropertySet _qosSettings = new QoSPropertySet(this.getConfiguration(), 1);
        _qosSettings.set_qos(qosProps);
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("uniqueQoSProps: " + _qosSettings);
            this.logger_.debug("uniqueAdminProps: " + _adminSettings);
        }
        this.checkQoSSettings(_qosSettings);
        ChannelContext _channelContext = (ChannelContext)this.defaultChannelContext_.clone();
        _channelContext.setORB(this.getORB());
        _channelContext.setPOA(this.rootPOA_);
        _channelContext.setMessageFactory(this.applicationContext_.getMessageFactory());
        _channelContext.setTaskProcessor(this.applicationContext_.getTaskProcessor());
        EventQueueFactory _factory = new EventQueueFactory();
        _factory.configure((Configuration)((org.jacorb.orb.ORB)this.getORB()).getConfiguration());
        _channelContext.setEventQueueFactory(_factory);
        AbstractEventChannel _eventChannelServant = this.newEventChannel();
        _eventChannelServant.setDefaultFilterFactory(this.getDefaultFilterFactory());
        _channelContext.resolveDependencies(_eventChannelServant);
        try {
            org.jacorb.orb.ORB jorb = (org.jacorb.orb.ORB)this.getORB();
            _eventChannelServant.configure((Configuration)jorb.getConfiguration());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage());
        }
        _eventChannelServant.setKey(_channelID);
        _eventChannelServant.set_qos(_qosSettings.toArray());
        _eventChannelServant.set_admin(_adminSettings.toArray());
        _eventChannelServant.setORB(this.getORB());
        _eventChannelServant.setPOA(this.rootPOA_);
        return _eventChannelServant;
    }

    private int createChannelIdentifier() {
        return this.eventChannelIDPool_.increment();
    }

    private void checkQoSSettings(PropertySet uniqueQoSProperties) throws UnsupportedQoS {
        if (uniqueQoSProperties.containsKey("EventReliability")) {
            short _eventReliabilty = uniqueQoSProperties.get("EventReliability").extract_short();
            switch (_eventReliabilty) {
                case 0: {
                    this.logger_.info("EventReliability=BestEffort");
                    break;
                }
                case 1: {
                    this.throwPersistentNotSupported("EventReliability");
                }
                default: {
                    this.throwBadValue("EventReliability");
                }
            }
        }
        short _connectionReliability = 0;
        if (uniqueQoSProperties.containsKey("ConnectionReliability")) {
            _connectionReliability = uniqueQoSProperties.get("ConnectionReliability").extract_short();
            switch (_connectionReliability) {
                case 0: {
                    this.logger_.info("ConnectionReliability=BestEffort");
                    break;
                }
                case 1: {
                    this.throwPersistentNotSupported("ConnectionReliability");
                    break;
                }
                default: {
                    this.throwBadValue("ConnectionReliability");
                }
            }
        }
    }

    private void throwPersistentNotSupported(String property) throws UnsupportedQoS {
        Any _lowVal = this.getORB().create_any();
        Any _highVal = this.getORB().create_any();
        _lowVal.insert_short((short)0);
        _highVal.insert_short((short)0);
        UnsupportedQoS _e = new UnsupportedQoS(new PropertyError[]{new PropertyError(QoSError_code.UNSUPPORTED_VALUE, property, new PropertyRange(_lowVal, _highVal))});
        throw _e;
    }

    private void throwBadValue(String property) throws UnsupportedQoS {
        Any _lowVal = this.getORB().create_any();
        Any _highVal = this.getORB().create_any();
        _lowVal.insert_short((short)0);
        _highVal.insert_short((short)0);
        UnsupportedQoS _e = new UnsupportedQoS("The specified Property Value is not supported", new PropertyError[]{new PropertyError(QoSError_code.BAD_VALUE, property, new PropertyRange(_lowVal, _highVal))});
        throw _e;
    }

    public void destroy() {
        Thread _shutdown = new Thread(){

            public void run() {
                try {
                    AbstractChannelFactory.this.logger_.info("Notification Service is going down in 1000 ms");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                AbstractChannelFactory.this.destroyMethod_.run();
            }
        };
        _shutdown.start();
    }

    public void shutdown(ShutdownCallback cb) {
        int _numberOfClients = 0;
        Iterator i = this.getChannelIterator();
        while (i.hasNext()) {
            AbstractEventChannel _channel = (AbstractEventChannel)((Map.Entry)i.next()).getValue();
            _numberOfClients += _channel.getNumberOfConnectedClients();
        }
        int _connectionTimeout = 4000;
        int _estimatedShutdowntime = _numberOfClients * _connectionTimeout;
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("Connected Clients: " + _numberOfClients);
            this.logger_.info("Connection Timeout: " + _connectionTimeout + " ms");
            this.logger_.info("Estimated Shutdowntime: " + _estimatedShutdowntime + " ms");
        }
        cb.needTime(_estimatedShutdowntime);
        this.logger_.info("NotificationService is going down");
        this.dispose();
        this.logger_.info("NotificationService down");
        cb.shutdownComplete();
    }

    public String getIOR() {
        return this.ior_;
    }

    public String getCorbaLoc() {
        return this.corbaLoc_;
    }

    private static AbstractChannelFactory newChannelFactory(boolean typed) {
        if (typed) {
            return new TypedEventChannelFactoryImpl();
        }
        return new EventChannelFactoryImpl();
    }

    public static AbstractChannelFactory newFactory(final ORB orb, boolean startThread, Properties props) throws Exception {
        AbstractChannelFactory _factory = AbstractChannelFactory.newChannelFactory("on".equals(props.get("jacorb.notification.enable_typed_channel")));
        _factory.setORB(orb);
        _factory.configure((Configuration)((org.jacorb.orb.ORB)orb).getConfiguration());
        _factory.preActivate();
        _factory.activate();
        _factory.printIOR(props);
        _factory.printCorbaLoc(props);
        _factory.writeFile(props);
        _factory.registerName(props);
        _factory.startChannels(props);
        if (startThread) {
            Thread _orbThread = new Thread(new Runnable(){

                public void run() {
                    orb.run();
                }
            });
            _orbThread.setName("Notification ORB Runner Thread");
            _orbThread.setDaemon(false);
            _orbThread.start();
        }
        return _factory;
    }

    public static AbstractChannelFactory newFactory(Properties props) throws Exception {
        props.put("jacorb.implname", STANDARD_IMPL_NAME);
        ORB _orb = ORB.init(new String[0], props);
        return AbstractChannelFactory.newFactory(_orb, true, props);
    }

    private void registerName(Properties props) throws Exception {
        this.registerName(props.getProperty("jacorb.notification.register_name.id"), props.getProperty("jacorb.notification.register_name.kind", ""));
    }

    private synchronized void registerName(String nameId, String nameKind) throws Exception {
        if (nameId == null) {
            return;
        }
        this.namingContext_ = NamingContextHelper.narrow(this.getORB().resolve_initial_references("NameService"));
        if (this.namingContext_ == null) {
            throw new ConfigurationException("could not resolve initial reference 'NameService'");
        }
        NameComponent[] _name = new NameComponent[]{new NameComponent(nameId, nameKind)};
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("namingContext.rebind(" + nameId + (nameKind != null && nameKind.length() > 0 ? "." + nameKind : "") + " => " + this.getCorbaLoc() + ")");
        }
        this.namingContext_.rebind(_name, this.thisRef_);
        this.registeredName_ = _name;
    }

    private synchronized void unregisterName() throws Exception {
        if (this.namingContext_ != null && this.registeredName_ != null) {
            this.namingContext_.unbind(this.registeredName_);
            this.registeredName_ = null;
        }
    }

    private void startChannels(Properties props) throws UnsupportedQoS, UnsupportedAdmin {
        if (props.containsKey("jacorb.notification.start_channels")) {
            this.startChannels(Integer.parseInt((String)props.get("jacorb.notification.start_channels")));
        }
    }

    private void startChannels(int channels) throws UnsupportedQoS, UnsupportedAdmin {
        for (int i = 0; i < channels; ++i) {
            IntHolder ih = new IntHolder();
            this.create_abstract_channel(new Property[0], new Property[0], ih);
        }
    }

    private void printIOR(Properties props) {
        if ("on".equals(props.get("jacorb.notification.print_ior"))) {
            System.out.println(this.getIOR());
        }
    }

    private void printCorbaLoc(Properties props) {
        if ("on".equals(props.get("jacorb.notification.print_corbaloc"))) {
            System.out.println(this.getCorbaLoc());
        }
    }

    private void writeFile(Properties props) {
        String _iorFileName = (String)props.get("jacorb.notification.ior_file");
        if (_iorFileName != null) {
            try {
                PrintWriter out = new PrintWriter(new FileWriter(_iorFileName));
                out.println(this.getIOR());
                out.flush();
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static interface ShutdownCallback {
        public void needTime(int var1);

        public void shutdownComplete();
    }
}

