/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.naming;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.naming.BindingIteratorImpl;
import org.jacorb.naming.Name;
import org.jacorb.orb.util.CorbaLoc;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingIteratorHelper;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextExtPOA;
import org.omg.CosNaming.NamingContextExtPackage.InvalidAddress;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import org.omg.PortableServer.POA;

public class NamingContextImpl
extends NamingContextExtPOA
implements Serializable,
Configurable {
    private Hashtable names = new Hashtable();
    private Hashtable contexts = new Hashtable();
    private org.jacorb.config.Configuration configuration = null;
    private boolean noPing = false;
    private boolean doPurge = false;
    private static Logger logger = null;
    private transient POA poa;
    private static POA rootPoa;
    private static ORB orb;
    private int child_count;
    private boolean destroyed = false;

    public void configure(Configuration myConfiguration) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)myConfiguration;
        logger = this.configuration.getNamedLogger("jacorb.naming");
        this.doPurge = this.configuration.getAttribute("jacorb.naming.purge", "off").equals("on");
        this.noPing = this.configuration.getAttribute("jacorb.naming.noping", "off").equals("on");
    }

    public void bind(NameComponent[] nc, Object obj) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (this.destroyed) {
            throw new CannotProceed();
        }
        if (nc == null || nc.length == 0) {
            throw new InvalidName();
        }
        if (obj == null) {
            throw new BAD_PARAM();
        }
        Name n = new Name(nc);
        Name ctx = n.ctxName();
        NameComponent nb = n.baseNameComponent();
        if (ctx == null) {
            if (this.names.containsKey(n)) {
                Object s = (Object)this.names.get(n);
                if (this.isDead(s)) {
                    this.rebind(n.components(), obj);
                    return;
                }
                throw new AlreadyBound();
            }
            if (this.contexts.containsKey(n)) {
                Object s = (Object)this.contexts.get(n);
                if (this.isDead(s)) {
                    this.unbind(n.components());
                }
                throw new AlreadyBound();
            }
            if (this.names.put(n, obj) != null) {
                throw new CannotProceed(this._this(), n.components());
            }
            if (logger.isInfoEnabled()) {
                logger.info("Bound name: " + n.toString());
            }
        } else {
            NameComponent[] ncx = new NameComponent[]{nb};
            NamingContextExtHelper.narrow(this.resolve(ctx.components())).bind(ncx, obj);
        }
    }

    public void rebind(NameComponent[] nc, Object obj) throws NotFound, CannotProceed, InvalidName {
        if (this.destroyed) {
            throw new CannotProceed();
        }
        if (nc == null || nc.length == 0) {
            throw new InvalidName();
        }
        if (obj == null) {
            throw new BAD_PARAM();
        }
        Name n = new Name(nc);
        Name ctx = n.ctxName();
        NameComponent nb = n.baseNameComponent();
        if (this.contexts.containsKey(n)) {
            throw new NotFound(NotFoundReason.not_object, new NameComponent[]{nb});
        }
        Object _o = (Object)this.names.remove(n);
        if (_o != null) {
            _o._release();
        }
        if (ctx == null) {
            this.names.put(n, obj);
            if (logger.isInfoEnabled()) {
                logger.info("re-Bound name: " + n.toString());
            }
        } else {
            NameComponent[] ncx = new NameComponent[]{nb};
            NamingContextExt nce = NamingContextExtHelper.narrow(this.resolve(ctx.components()));
            if (nce == null) {
                throw new CannotProceed();
            }
            nce.rebind(ncx, obj);
        }
    }

    public void rebind_context(NameComponent[] nc, NamingContext obj) throws NotFound, CannotProceed, InvalidName {
        if (this.destroyed) {
            throw new CannotProceed();
        }
        if (nc == null || nc.length == 0) {
            throw new InvalidName();
        }
        if (obj == null) {
            throw new BAD_PARAM();
        }
        Name n = new Name(nc);
        Name ctx = n.ctxName();
        NameComponent nb = n.baseNameComponent();
        if (this.names.containsKey(n)) {
            throw new NotFound(NotFoundReason.not_context, new NameComponent[]{nb});
        }
        Object _o = (Object)this.contexts.remove(n);
        if (_o != null) {
            _o._release();
        }
        if (ctx == null) {
            this.contexts.put(n, obj);
            if (logger.isInfoEnabled()) {
                logger.info("Re-Bound context: " + n.baseNameComponent().id);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void bind_context(NameComponent[] nc, NamingContext obj) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (this.destroyed) {
            throw new CannotProceed();
        }
        Name n = new Name(nc);
        Name ctx = n.ctxName();
        NameComponent nb = n.baseNameComponent();
        if (ctx == null) {
            if (this.names.containsKey(n)) {
                Object s = (Object)this.names.get(n);
                if (!this.isDead(s)) throw new AlreadyBound();
                this.unbind(n.components());
            } else if (this.contexts.containsKey(n)) {
                Object s = (Object)this.contexts.get(n);
                if (!this.isDead(s)) throw new AlreadyBound();
                this.rebind_context(n.components(), obj);
                return;
            }
            if (this.contexts.put(n, obj) != null) {
                throw new CannotProceed(this._this(), n.components());
            }
            this.contexts.put(n, obj);
            if (!logger.isInfoEnabled()) return;
            logger.info("Bound context: " + n.toString());
            return;
        } else {
            NameComponent[] ncx = new NameComponent[]{nb};
            NamingContextExtHelper.narrow(this.resolve(ctx.components())).bind_context(ncx, obj);
        }
    }

    public NamingContext bind_new_context(NameComponent[] nc) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (this.destroyed) {
            throw new CannotProceed();
        }
        if (nc == null || nc.length == 0) {
            throw new InvalidName();
        }
        NamingContextExt ns = NamingContextExtHelper.narrow(this.new_context());
        this.bind_context(nc, ns);
        if (ns == null) {
            throw new CannotProceed();
        }
        return ns;
    }

    private void cleanup() {
        Name _n;
        if (!this.doPurge) {
            return;
        }
        Vector<Name> deletionVector = new Vector<Name>();
        Enumeration n = this.names.keys();
        while (n.hasMoreElements()) {
            _n = (Name)n.nextElement();
            if (!this.isDead((Object)this.names.get(_n))) continue;
            if (logger.isInfoEnabled()) {
                logger.info("Removing name " + _n.baseNameComponent().id);
            }
            deletionVector.addElement(_n);
        }
        if (deletionVector.size() > 0) {
            int i = deletionVector.size();
            while (i-- > 0) {
                this.names.remove((Name)deletionVector.elementAt(i));
            }
            deletionVector.removeAllElements();
        }
        Enumeration c = this.contexts.keys();
        while (c.hasMoreElements()) {
            _n = (Name)c.nextElement();
            if (!this.isDead((Object)this.contexts.get(_n))) continue;
            if (logger.isInfoEnabled()) {
                logger.info("Removing context " + _n.baseNameComponent().id);
            }
            deletionVector.addElement(_n);
        }
        if (deletionVector.size() > 0) {
            int i = deletionVector.size();
            while (i-- > 0) {
                this.contexts.remove((Name)deletionVector.elementAt(i));
            }
            deletionVector.removeAllElements();
        }
    }

    public void destroy() throws NotEmpty {
        if (this.destroyed) {
            return;
        }
        if (!this.names.isEmpty() || !this.contexts.isEmpty()) {
            throw new NotEmpty();
        }
        this.names = null;
        this.contexts = null;
        this.destroyed = true;
    }

    public int how_many() {
        if (this.destroyed) {
            return 0;
        }
        return this.names.size() + this.contexts.size();
    }

    private Binding[] list() {
        int how_many;
        this.cleanup();
        Enumeration n = this.names.keys();
        Enumeration c = this.contexts.keys();
        Binding[] result = new Binding[how_many];
        for (how_many = this.how_many(); n.hasMoreElements() && how_many > 0; --how_many) {
            result[how_many - 1] = new Binding(((Name)n.nextElement()).components(), BindingType.nobject);
        }
        while (c.hasMoreElements() && how_many > 0) {
            result[how_many - 1] = new Binding(((Name)c.nextElement()).components(), BindingType.ncontext);
            --how_many;
        }
        return result;
    }

    public void list(int how_many, BindingListHolder bl, BindingIteratorHolder bi) {
        Binding[] result;
        int size;
        if (this.destroyed) {
            return;
        }
        this.cleanup();
        Enumeration n = this.names.keys();
        Enumeration c = this.contexts.keys();
        if (how_many < size) {
            int how_many_ctr;
            result = new Binding[how_many];
            for (how_many_ctr = how_many; n.hasMoreElements() && how_many_ctr > 0; --how_many_ctr) {
                result[how_many_ctr - 1] = new Binding(((Name)n.nextElement()).components(), BindingType.nobject);
            }
            while (c.hasMoreElements() && how_many_ctr > 0) {
                result[how_many_ctr - 1] = new Binding(((Name)c.nextElement()).components(), BindingType.ncontext);
                --how_many_ctr;
            }
            Binding[] rest = new Binding[size -= how_many];
            while (n.hasMoreElements() && size > 0) {
                rest[size - 1] = new Binding(((Name)n.nextElement()).components(), BindingType.nobject);
                --size;
            }
            while (c.hasMoreElements() && size > 0) {
                rest[size - 1] = new Binding(((Name)c.nextElement()).components(), BindingType.ncontext);
                --size;
            }
            Object o = null;
            try {
                byte[] oid = rootPoa.activate_object(new BindingIteratorImpl(rest));
                o = rootPoa.id_to_reference(oid);
            }
            catch (Exception ue) {
                ue.printStackTrace();
            }
            bi.value = BindingIteratorHelper.narrow(o);
        } else {
            result = new Binding[size];
            for (size = this.how_many(); n.hasMoreElements() && size > 0; --size) {
                result[size - 1] = new Binding(((Name)n.nextElement()).components(), BindingType.nobject);
            }
            while (c.hasMoreElements() && size > 0) {
                result[size - 1] = new Binding(((Name)c.nextElement()).components(), BindingType.ncontext);
                --size;
            }
        }
        bl.value = result;
    }

    public NamingContext new_context() {
        if (this.destroyed) {
            return null;
        }
        Object ctx = null;
        try {
            byte[] oid = (new String(this.poa.servant_to_id(this)) + "_ctx" + ++this.child_count).getBytes();
            ctx = this.poa.create_reference_with_id(oid, "IDL:omg.org/CosNaming/NamingContextExt:1.0");
            if (logger.isInfoEnabled()) {
                logger.info("New context.");
            }
        }
        catch (Exception ue) {
            ue.printStackTrace();
            System.exit(1);
        }
        return NamingContextExtHelper.narrow(ctx);
    }

    public Object resolve(NameComponent[] nc) throws NotFound, CannotProceed, InvalidName {
        if (this.destroyed) {
            throw new CannotProceed();
        }
        if (nc == null || nc.length == 0) {
            throw new InvalidName();
        }
        Name n = new Name(nc[0]);
        if (nc.length > 1) {
            NamingContextExt next_context = NamingContextExtHelper.narrow((Object)this.contexts.get(n));
            if (next_context == null || this.isDead(next_context)) {
                throw new NotFound(NotFoundReason.missing_node, nc);
            }
            NameComponent[] nc_prime = new NameComponent[nc.length - 1];
            for (int i = 1; i < nc.length; ++i) {
                nc_prime[i - 1] = nc[i];
            }
            return next_context.resolve(nc_prime);
        }
        Object result = null;
        result = (Object)this.contexts.get(n);
        if (result == null) {
            result = (Object)this.names.get(n);
        }
        if (result == null) {
            throw new NotFound(NotFoundReason.missing_node, n.components());
        }
        if (!this.noPing && this.isDead(result)) {
            throw new NotFound(NotFoundReason.missing_node, n.components());
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void unbind(NameComponent[] nc) throws NotFound, CannotProceed, InvalidName {
        if (this.destroyed) {
            throw new CannotProceed();
        }
        if (nc == null) throw new InvalidName();
        if (nc.length == 0) {
            throw new InvalidName();
        }
        Name n = new Name(nc);
        Name ctx = n.ctxName();
        NameComponent nb = n.baseNameComponent();
        if (ctx != null) {
            NameComponent[] ncx = new NameComponent[]{nb};
            NamingContextExtHelper.narrow(this.resolve(ctx.components())).unbind(ncx);
            return;
        }
        if (this.names.containsKey(n)) {
            Object o = (Object)this.names.remove(n);
            o._release();
            if (!logger.isInfoEnabled()) return;
            logger.info("Unbound: " + n.toString());
            return;
        }
        if (this.contexts.containsKey(n)) {
            Object o = (Object)this.contexts.remove(n);
            o._release();
            if (!logger.isInfoEnabled()) return;
            logger.info("Unbound: " + n.toString());
            return;
        }
        if (!logger.isWarnEnabled()) throw new NotFound(NotFoundReason.not_context, n.components());
        logger.warn("Unbind failed for " + n.toString());
        throw new NotFound(NotFoundReason.not_context, n.components());
    }

    public POA default_POA() {
        return this.poa;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Object o;
        Name key;
        Enumeration e = this.contexts.keys();
        while (e.hasMoreElements()) {
            key = (Name)e.nextElement();
            o = (Object)this.contexts.remove(key);
            this.contexts.put(key, orb.object_to_string(o));
        }
        e = this.names.keys();
        while (e.hasMoreElements()) {
            key = (Name)e.nextElement();
            o = (Object)this.names.remove(key);
            this.names.put(key, orb.object_to_string(o));
        }
        out.defaultWriteObject();
    }

    public static void init(ORB orb, POA rootPoa) {
        NamingContextImpl.orb = orb;
        NamingContextImpl.rootPoa = rootPoa;
    }

    void init(POA poa) {
        String ref;
        Name key;
        this.poa = poa;
        Enumeration e = this.contexts.keys();
        while (e.hasMoreElements()) {
            key = (Name)e.nextElement();
            ref = (String)this.contexts.remove(key);
            this.contexts.put(key, orb.string_to_object(ref));
        }
        e = this.names.keys();
        while (e.hasMoreElements()) {
            key = (Name)e.nextElement();
            ref = (String)this.names.remove(key);
            this.names.put(key, orb.string_to_object(ref));
        }
    }

    public String to_string(NameComponent[] n) throws InvalidName {
        return Name.toString(n);
    }

    public NameComponent[] to_name(String sn) throws InvalidName {
        return Name.toName(sn);
    }

    public String to_url(String addr, String sn) throws InvalidAddress, InvalidName {
        try {
            CorbaLoc corbaLoc = new CorbaLoc((org.jacorb.orb.ORB)orb, addr);
            return corbaLoc.toCorbaName(sn);
        }
        catch (IllegalArgumentException ia) {
            throw new InvalidAddress();
        }
    }

    public Object resolve_str(String n) throws NotFound, CannotProceed, InvalidName {
        return this.resolve(this.to_name(n));
    }

    private boolean isDead(Object o) {
        boolean non_exist = true;
        try {
            non_exist = o._non_existent();
        }
        catch (SystemException e) {
            non_exist = true;
        }
        return non_exist;
    }
}

