/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir.gui.typesystem;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jacorb.ir.gui.typesystem.AbstractContainer;
import org.jacorb.ir.gui.typesystem.ModelParticipant;
import org.jacorb.ir.gui.typesystem.NodeMapper;
import org.jacorb.ir.gui.typesystem.TypeAssociator;
import org.jacorb.ir.gui.typesystem.TypeSystemNode;

public class ModelBuilder
implements Runnable,
TreeExpansionListener,
TreeModelListener {
    private Hashtable threadArguments = new Hashtable();
    protected Hashtable expandedModParts = new Hashtable();
    protected Hashtable treeViewsToUpdate = new Hashtable();
    protected Hashtable treeNodesAndTableModels = new Hashtable();
    private Hashtable treeModelsListenedTo = new Hashtable();
    private static ModelBuilder singleton = new ModelBuilder();

    public DefaultTreeModel buildTreeModel(ModelParticipant rootModPart) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootModPart);
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        treeModel.setAsksAllowsChildren(true);
        rootModPart.buildTree(treeModel, null);
        return treeModel;
    }

    public DefaultTreeModel buildTreeModelAsync(ModelParticipant rootModPart) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootModPart);
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        treeModel.setAsksAllowsChildren(true);
        Thread thread = new Thread(this);
        this.threadArguments.put(thread.getName(), treeModel);
        thread.start();
        return treeModel;
    }

    public DefaultTreeModel createTreeModelRoot(ModelParticipant rootModPart) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootModPart);
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        rootModPart.addToParent(treeModel, null);
        treeModel.setAsksAllowsChildren(true);
        return treeModel;
    }

    private synchronized void expandModPart(ModelParticipant modPart, DefaultTreeModel treeModel) {
        modPart.expand(treeModel);
    }

    public static ModelBuilder getSingleton() {
        return singleton;
    }

    public synchronized DefaultTableModel getTableModel(DefaultTreeModel treeModel, DefaultMutableTreeNode treeNode) {
        DefaultTableModel tableModel = new DefaultTableModel();
        Object[] colIdentifiers = new Object[]{"Item", "Type", "Name"};
        tableModel.setColumnIdentifiers(colIdentifiers);
        if (treeNode != null && treeNode.getUserObject() instanceof AbstractContainer) {
            Vector tableModels;
            if (!this.treeModelsListenedTo.containsKey(treeModel)) {
                treeModel.addTreeModelListener(this);
                this.treeModelsListenedTo.put(treeModel, treeModel);
            }
            if (this.treeNodesAndTableModels.containsKey(treeNode)) {
                tableModels = (Vector)this.treeNodesAndTableModels.get(treeNode);
                tableModels.addElement(tableModel);
            } else {
                tableModels = new Vector();
                tableModels.addElement(tableModel);
                this.treeNodesAndTableModels.put(treeNode, tableModels);
            }
            if (!this.expandedModParts.containsKey(treeNode)) {
                this.startExpandNode(treeModel, treeNode);
            } else {
                for (int i = 0; i < treeModel.getChildCount(treeNode); ++i) {
                    this.insertTableRow(tableModel, (DefaultMutableTreeNode)treeNode.getChildAt(i), i);
                }
            }
        }
        return tableModel;
    }

    public TreeExpansionListener getTreeExpansionListener(TreeModel treeModel) {
        return this;
    }

    private void insertTableRow(DefaultTableModel tableModel, DefaultMutableTreeNode treeNode, int index) {
        TypeSystemNode typeSystemNode = (TypeSystemNode)treeNode.getUserObject();
        String type = "";
        if (typeSystemNode instanceof TypeAssociator) {
            type = ((TypeAssociator)((Object)typeSystemNode)).getAssociatedType();
        }
        Object[] row = new Object[]{new NodeMapper(typeSystemNode, typeSystemNode.getInstanceNodeTypeName()), new NodeMapper(typeSystemNode, type), new NodeMapper(typeSystemNode, typeSystemNode.getName())};
        tableModel.insertRow(index, row);
    }

    public void run() {
        Object argument = this.threadArguments.get(Thread.currentThread().getName());
        if (argument instanceof DefaultTreeModel) {
            DefaultTreeModel treeModel = (DefaultTreeModel)argument;
            ModelParticipant root = (ModelParticipant)((DefaultMutableTreeNode)treeModel.getRoot()).getUserObject();
            root.buildTree(treeModel, null);
        }
        if (argument instanceof Object[]) {
            Object[] args = (Object[])argument;
            DefaultTreeModel treeModel = (DefaultTreeModel)args[0];
            ModelParticipant modPart = (ModelParticipant)args[1];
            this.expandModPart(modPart, treeModel);
        }
    }

    private void startExpandNode(DefaultTreeModel treeModel, DefaultMutableTreeNode treeNode) {
        ModelParticipant modPart = (ModelParticipant)treeNode.getUserObject();
        if (!this.expandedModParts.containsKey(treeNode)) {
            System.out.println("expanding node: " + treeNode);
            Thread thread = new Thread(this);
            Object[] args = new Object[]{treeModel, modPart};
            this.threadArguments.put(thread.getName(), args);
            thread.start();
        }
    }

    public void treeCollapsed(TreeExpansionEvent e) {
    }

    public synchronized void treeExpanded(TreeExpansionEvent e) {
        JTree jTree = (JTree)e.getSource();
        DefaultTreeModel treeModel = (DefaultTreeModel)jTree.getModel();
        TreePath path = e.getPath();
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 1);
        this.treeViewsToUpdate.put(treeNode, jTree);
        this.startExpandNode(treeModel, treeNode);
    }

    public void treeNodesChanged(TreeModelEvent te) {
    }

    public void treeNodesInserted(TreeModelEvent te) {
        DefaultTreeModel treeModel = (DefaultTreeModel)te.getSource();
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)te.getTreePath().getLastPathComponent();
        Vector tableModels = (Vector)this.treeNodesAndTableModels.get(treeNode);
        Object[] children = te.getChildren();
        int[] indices = te.getChildIndices();
        if (tableModels != null) {
            for (int i = 0; i < indices.length; ++i) {
                Enumeration e = tableModels.elements();
                while (e.hasMoreElements()) {
                    DefaultTableModel tableModel = (DefaultTableModel)e.nextElement();
                    this.insertTableRow(tableModel, (DefaultMutableTreeNode)treeNode.getChildAt(indices[i]), indices[i]);
                }
            }
        }
    }

    public void treeNodesRemoved(TreeModelEvent te) {
    }

    public void treeStructureChanged(TreeModelEvent te) {
    }
}

