/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.SequencedHashMap;
import org.hibernate.type.LiteralType;
import org.hibernate.util.StringHelper;

public class Update {
    private String tableName;
    private String[] primaryKeyColumnNames;
    private String versionColumnName;
    private String where;
    private String comment;
    private Map columns = new SequencedHashMap();
    private Map whereColumns = new SequencedHashMap();

    public Update setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public Update addColumns(String[] columnNames) {
        for (int i = 0; i < columnNames.length; ++i) {
            this.addColumn(columnNames[i]);
        }
        return this;
    }

    public Update addColumns(String[] columnNames, boolean[] updateable) {
        for (int i = 0; i < columnNames.length; ++i) {
            if (!updateable[i]) continue;
            this.addColumn(columnNames[i]);
        }
        return this;
    }

    public Update addColumns(String[] columnNames, String value) {
        for (int i = 0; i < columnNames.length; ++i) {
            this.addColumn(columnNames[i], value);
        }
        return this;
    }

    public Update addColumn(String columnName) {
        return this.addColumn(columnName, "?");
    }

    public Update addColumn(String columnName, String value) {
        this.columns.put(columnName, value);
        return this;
    }

    public Update addColumn(String columnName, Object value, LiteralType type) throws Exception {
        return this.addColumn(columnName, type.objectToSQLString(value));
    }

    public Update addWhereColumns(String[] columnNames) {
        for (int i = 0; i < columnNames.length; ++i) {
            this.addWhereColumn(columnNames[i]);
        }
        return this;
    }

    public Update addWhereColumns(String[] columnNames, String value) {
        for (int i = 0; i < columnNames.length; ++i) {
            this.addWhereColumn(columnNames[i], value);
        }
        return this;
    }

    public Update addWhereColumn(String columnName) {
        return this.addWhereColumn(columnName, "=?");
    }

    public Update addWhereColumn(String columnName, String value) {
        this.whereColumns.put(columnName, value);
        return this;
    }

    public Update setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public Update setWhere(String where) {
        this.where = where;
        return this;
    }

    public String toStatementString() {
        Map.Entry e;
        StringBuffer buf = new StringBuffer(this.columns.size() * 15 + this.tableName.length() + 10);
        if (this.comment != null) {
            buf.append("/*").append(this.comment).append("*/");
        }
        buf.append("update ").append(this.tableName).append(" set ");
        Iterator iter = this.columns.entrySet().iterator();
        while (iter.hasNext()) {
            e = iter.next();
            buf.append(e.getKey()).append('=').append(e.getValue());
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(" where ").append(StringHelper.join("=? and ", this.primaryKeyColumnNames)).append("=?");
        if (this.where != null) {
            buf.append(" and ").append(this.where);
        }
        iter = this.whereColumns.entrySet().iterator();
        while (iter.hasNext()) {
            e = iter.next();
            buf.append(" and ").append(e.getKey()).append(e.getValue());
        }
        if (this.versionColumnName != null) {
            buf.append(" and ").append(this.versionColumnName).append("=?");
        }
        return buf.toString();
    }

    public Update setPrimaryKeyColumnNames(String[] primaryKeyColumnNames) {
        this.primaryKeyColumnNames = primaryKeyColumnNames;
        return this;
    }

    public Update setVersionColumnName(String versionColumnName) {
        this.versionColumnName = versionColumnName;
        return this;
    }
}

