/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.StaleStateException;
import org.hibernate.jdbc.AbstractBatcher;
import org.hibernate.jdbc.JDBCContext;

public class NonBatchingBatcher
extends AbstractBatcher {
    public NonBatchingBatcher(JDBCContext jdbcContext) {
        super(jdbcContext);
    }

    public void addToBatch(int expectedRowCount) throws SQLException, HibernateException {
        int rowCount = this.getStatement().executeUpdate();
        if (expectedRowCount > 0) {
            if (expectedRowCount < rowCount) {
                throw new StaleStateException("Unexpected row count: " + rowCount + " expected: " + expectedRowCount);
            }
            if (expectedRowCount > rowCount) {
                throw new HibernateException("Unexpected row count: " + rowCount + " expected: " + expectedRowCount);
            }
        }
    }

    protected void doExecuteBatch(PreparedStatement ps) throws SQLException, HibernateException {
    }
}

