/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.action.EntityIdentityInsertAction;
import org.hibernate.action.EntityInsertAction;
import org.hibernate.classic.Lifecycle;
import org.hibernate.classic.Validatable;
import org.hibernate.engine.Cascades;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.Nullability;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.engine.Versioning;
import org.hibernate.event.def.AbstractReassociateEventListener;
import org.hibernate.event.def.WrapVisitor;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;

public abstract class AbstractSaveEventListener
extends AbstractReassociateEventListener {
    protected static final int PERSISTENT = 0;
    protected static final int TRANSIENT = 1;
    protected static final int DETACHED = 2;
    protected static final int DELETED = 3;
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$event$def$AbstractSaveEventListener == null ? (class$org$hibernate$event$def$AbstractSaveEventListener = AbstractSaveEventListener.class$("org.hibernate.event.def.AbstractSaveEventListener")) : class$org$hibernate$event$def$AbstractSaveEventListener));
    static /* synthetic */ Class class$org$hibernate$event$def$AbstractSaveEventListener;

    protected Serializable saveWithRequestedId(Object entity, Serializable requestedId, String entityName, Object anything, SessionImplementor source) throws HibernateException {
        return this.performSave(entity, requestedId, source.getEntityPersister(entityName, entity), false, anything, source);
    }

    protected Serializable saveWithGeneratedId(Object entity, String entityName, Object anything, SessionImplementor source) throws HibernateException {
        EntityPersister persister = source.getEntityPersister(entityName, entity);
        Serializable generatedId = persister.getIdentifierGenerator().generate(source, entity);
        if (log.isDebugEnabled()) {
            log.debug((Object)("generated identifier: " + persister.getIdentifierType().toLoggableString(generatedId, source.getFactory()) + ", using strategy: " + persister.getIdentifierGenerator().getClass().getName()));
        }
        if (generatedId == null) {
            throw new IdentifierGenerationException("null id generated for:" + entity.getClass());
        }
        if (generatedId == IdentifierGeneratorFactory.SHORT_CIRCUIT_INDICATOR) {
            return source.getIdentifier(entity);
        }
        if (generatedId == IdentifierGeneratorFactory.POST_INSERT_INDICATOR) {
            return this.performSave(entity, null, persister, true, anything, source);
        }
        return this.performSave(entity, generatedId, persister, false, anything, source);
    }

    protected Serializable performSave(Object entity, Serializable id, EntityPersister persister, boolean useIdentityColumn, Object anything, SessionImplementor source) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("saving " + MessageHelper.infoString(persister, id, source.getFactory())));
        }
        if (!useIdentityColumn) {
            Object old = source.getPersistenceContext().getEntity(new EntityKey(id, persister, source.getEntityMode()));
            if (old != null) {
                if (source.getPersistenceContext().getEntry(old).getStatus() == Status.DELETED) {
                    source.forceFlush(source.getPersistenceContext().getEntry(old));
                } else {
                    throw new NonUniqueObjectException(id, persister.getEntityName());
                }
            }
            persister.setIdentifier(entity, id, source.getEntityMode());
        }
        if (persister.implementsLifecycle(source.getEntityMode())) {
            log.debug((Object)"calling onSave()");
            if (((Lifecycle)entity).onSave(source)) {
                log.debug((Object)"insertion vetoed by onSave()");
                return id;
            }
        }
        return this.performSaveOrReplicate(entity, id, persister, useIdentityColumn, anything, source);
    }

    protected Serializable performSaveOrReplicate(Object entity, Serializable id, EntityPersister persister, boolean useIdentityColumn, Object anything, SessionImplementor source) throws HibernateException {
        if (persister.implementsValidatable(source.getEntityMode())) {
            ((Validatable)entity).validate();
        }
        if (useIdentityColumn) {
            log.trace((Object)"executing insertions");
            source.getActionQueue().executeInserts();
        }
        source.getPersistenceContext().addEntry(entity, Status.SAVING, null, null, id, null, LockMode.WRITE, useIdentityColumn, persister, false);
        this.cascadeBeforeSave(source, persister, entity, anything);
        Object[] values = persister.getPropertyValuesToInsert(entity, source);
        Type[] types = persister.getPropertyTypes();
        boolean substitute = this.substituteValuesIfNecessary(entity, id, values, persister, source);
        if (persister.hasCollections()) {
            boolean bl = substitute = substitute || this.visitCollections(id, values, types, source);
        }
        if (substitute) {
            persister.setPropertyValues(entity, values, source.getEntityMode());
        }
        TypeFactory.deepCopy(values, types, persister.getPropertyUpdateability(), values, source);
        new ForeignKeys.Nullifier(entity, false, useIdentityColumn, source).nullifyTransientReferences(values, types);
        new Nullability(source).checkNullability(values, persister, false);
        if (useIdentityColumn) {
            EntityIdentityInsertAction insert = new EntityIdentityInsertAction(values, entity, persister, source);
            source.getActionQueue().execute(insert);
            id = insert.getGeneratedId();
            persister.setIdentifier(entity, id, source.getEntityMode());
            source.getPersistenceContext().checkUniqueness(id, persister, entity);
        }
        Object version = Versioning.getVersion(values, persister);
        source.getPersistenceContext().addEntity(entity, Status.MANAGED, values, id, version, LockMode.WRITE, useIdentityColumn, persister, this.isVersionIncrementDisabled());
        if (!useIdentityColumn) {
            source.getActionQueue().addAction(new EntityInsertAction(id, values, entity, version, persister, source));
        }
        this.cascadeAfterSave(source, persister, entity, anything);
        return id;
    }

    protected boolean isVersionIncrementDisabled() {
        return false;
    }

    protected boolean visitCollections(Serializable id, Object[] values, Type[] types, SessionImplementor source) {
        WrapVisitor visitor = new WrapVisitor(source);
        visitor.processEntityPropertyValues(values, types);
        return visitor.isSubstitutionRequired();
    }

    protected boolean substituteValuesIfNecessary(Object entity, Serializable id, Object[] values, EntityPersister persister, SessionImplementor source) {
        boolean substitute = source.getInterceptor().onSave(entity, id, values, persister.getPropertyNames(), persister.getPropertyTypes());
        if (persister.isVersioned()) {
            substitute = Versioning.seedVersion(values, persister.getVersionProperty(), persister.getVersionType()) || substitute;
        }
        return substitute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeBeforeSave(SessionImplementor source, EntityPersister persister, Object entity, Object anything) throws HibernateException {
        source.getPersistenceContext().incrementCascadeLevel();
        try {
            Cascades.cascade(source, persister, entity, this.getCascadeAction(), 2, anything);
        }
        finally {
            source.getPersistenceContext().decrementCascadeLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeAfterSave(SessionImplementor source, EntityPersister persister, Object entity, Object anything) throws HibernateException {
        source.getPersistenceContext().incrementCascadeLevel();
        try {
            Cascades.cascade(source, persister, entity, this.getCascadeAction(), 1, anything);
        }
        finally {
            source.getPersistenceContext().decrementCascadeLevel();
        }
    }

    protected abstract Cascades.CascadingAction getCascadeAction();

    protected int getEntityState(Object entity, String entityName, EntityEntry entry, SessionImplementor source) {
        if (entry != null) {
            if (entry.getStatus() != Status.DELETED) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("persistent instance of: " + this.getLoggableName(entityName, entity)));
                }
                return 0;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("deleted instance of: " + this.getLoggableName(entityName, entity)));
            }
            return 3;
        }
        if (ForeignKeys.isTransient(entityName, entity, this.getAssumedUnsaved(), source)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("transient instance of: " + this.getLoggableName(entityName, entity)));
            }
            return 1;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("detached instance of: " + this.getLoggableName(entityName, entity)));
        }
        return 2;
    }

    private String getLoggableName(String entityName, Object entity) {
        return entityName == null ? entity.getClass().getName() : entityName;
    }

    protected Boolean getAssumedUnsaved() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

