/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.tm.GlobalId;
import org.jboss.tm.JBossXAException;
import org.jboss.tm.JBossXATerminator;
import org.jboss.tm.LocalId;
import org.jboss.tm.TransactionImpl;
import org.jboss.tm.TransactionLocal;
import org.jboss.tm.TransactionLocalDelegate;
import org.jboss.tm.TransactionPropagationContextFactory;
import org.jboss.tm.TransactionPropagationContextImporter;
import org.jboss.tm.TransactionTimeoutConfiguration;
import org.jboss.tm.XidImpl;
import org.jboss.util.UnexpectedThrowable;
import org.jboss.util.UnreachableStatementException;

public class TxManager
implements TransactionManager,
TransactionPropagationContextImporter,
TransactionPropagationContextFactory,
TransactionLocalDelegate,
TransactionTimeoutConfiguration,
JBossXATerminator {
    private boolean globalIdsEnabled = false;
    private boolean interruptThreads = false;
    private Logger log = Logger.getLogger(this.getClass());
    private boolean trace = this.log.isTraceEnabled();
    private long timeOut = 300000L;
    private volatile int commitCount;
    private volatile int rollbackCount;
    private static TxManager singleton = new TxManager();
    private ThreadLocal threadTx = new ThreadLocal();
    private Map localIdTx = Collections.synchronizedMap(new HashMap());
    private Map globalIdTx = Collections.synchronizedMap(new HashMap());

    public static TxManager getInstance() {
        return singleton;
    }

    private TxManager() {
        TransactionImpl.defaultXidFactory();
    }

    public void setGlobalIdsEnabled(boolean newValue) {
        XidImpl.setTrulyGlobalIdsEnabled(newValue);
        this.globalIdsEnabled = newValue;
    }

    public boolean getGlobalIdsEnabled() {
        return this.globalIdsEnabled;
    }

    public void setInterruptThreads(boolean interruptThreads) {
        this.interruptThreads = interruptThreads;
    }

    public boolean isInterruptThreads() {
        return this.interruptThreads;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.trace = this.log.isTraceEnabled();
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            if (current.isDone()) {
                this.disassociateThread(ti);
            } else {
                throw new NotSupportedException("Transaction already active, cannot nest transactions.");
            }
        }
        long timeout = ti.timeout == 0L ? this.timeOut : ti.timeout;
        TransactionImpl tx = new TransactionImpl(timeout);
        this.associateThread(ti, tx);
        this.localIdTx.put(tx.getLocalId(), tx);
        if (this.globalIdsEnabled) {
            this.globalIdTx.put(tx.getGlobalId(), tx);
        }
        if (this.trace) {
            this.log.trace((Object)("began tx: " + tx));
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            current.commit();
            this.disassociateThread(ti);
            if (this.trace) {
                this.log.trace((Object)("commited tx: " + current));
            }
        } else {
            throw new IllegalStateException("No transaction.");
        }
    }

    public int getStatus() throws SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            if (current.isDone()) {
                this.disassociateThread(ti);
            } else {
                return current.getStatus();
            }
        }
        return 6;
    }

    public Transaction getTransaction() throws SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null && current.isDone()) {
            current = null;
            this.disassociateThread(ti);
        }
        return current;
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (transaction != null && !(transaction instanceof TransactionImpl)) {
            throw new RuntimeException("Not a TransactionImpl, but a " + transaction.getClass().getName());
        }
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            if (current.isDone()) {
                ti.tx = null;
                current = null;
            } else {
                throw new IllegalStateException("Already associated with a tx");
            }
        }
        if (current != transaction) {
            this.associateThread(ti, (TransactionImpl)transaction);
        }
        if (this.trace) {
            this.log.trace((Object)("resumed tx: " + ti.tx));
        }
    }

    public Transaction suspend() throws SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            ti.tx = null;
            if (this.trace) {
                this.log.trace((Object)("suspended tx: " + current));
            }
            if (current.isDone()) {
                current = null;
            }
        }
        return current;
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            if (!current.isDone()) {
                current.rollback();
                if (this.trace) {
                    this.log.trace((Object)("rolled back tx: " + current));
                }
                return;
            }
            this.disassociateThread(ti);
        }
        throw new IllegalStateException("No transaction.");
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            if (!current.isDone()) {
                current.setRollbackOnly();
                if (this.trace) {
                    this.log.trace((Object)("tx marked for rollback only: " + current));
                }
                return;
            }
            ti.tx = null;
        }
        throw new IllegalStateException("No transaction.");
    }

    public int getTransactionTimeout() {
        return (int)(this.getThreadInfo().timeout / 1000L);
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.getThreadInfo().timeout = 1000 * seconds;
        if (this.trace) {
            this.log.trace((Object)("tx timeout is now: " + seconds + "s"));
        }
    }

    public void setDefaultTransactionTimeout(int seconds) {
        this.timeOut = 1000L * (long)seconds;
        if (this.trace) {
            this.log.trace((Object)("default tx timeout is now: " + seconds + "s"));
        }
    }

    public int getDefaultTransactionTimeout() {
        return (int)(this.timeOut / 1000L);
    }

    public Transaction disassociateThread() {
        return this.disassociateThread(this.getThreadInfo());
    }

    private Transaction disassociateThread(ThreadInfo ti) {
        TransactionImpl current = ti.tx;
        ti.tx = null;
        current.disassociateCurrentThread();
        return current;
    }

    public void associateThread(Transaction transaction) {
        if (transaction != null && !(transaction instanceof TransactionImpl)) {
            throw new RuntimeException("Not a TransactionImpl, but a " + transaction.getClass().getName());
        }
        TransactionImpl transactionImpl = (TransactionImpl)transaction;
        ThreadInfo ti = this.getThreadInfo();
        ti.tx = transactionImpl;
        transactionImpl.associateCurrentThread();
    }

    private void associateThread(ThreadInfo ti, TransactionImpl transaction) {
        ti.tx = transaction;
        transaction.associateCurrentThread();
    }

    public int getTransactionCount() {
        return this.localIdTx.size();
    }

    public long getCommitCount() {
        return this.commitCount;
    }

    public long getRollbackCount() {
        return this.rollbackCount;
    }

    public Transaction importTransactionPropagationContext(Object tpc) {
        if (tpc instanceof LocalId) {
            LocalId id = (LocalId)tpc;
            return (Transaction)this.localIdTx.get(id);
        }
        if (this.globalIdsEnabled && tpc instanceof GlobalId) {
            GlobalId id = (GlobalId)tpc;
            Transaction tx = (Transaction)this.globalIdTx.get(id);
            if (this.trace) {
                if (tx != null) {
                    this.log.trace((Object)("Successfully imported transaction context " + tpc));
                } else {
                    this.log.trace((Object)("Could not import transaction context " + tpc));
                }
            }
            return tx;
        }
        this.log.warn((Object)("Cannot import transaction propagation context: " + tpc));
        return null;
    }

    public Object getTransactionPropagationContext() {
        return this.getTransactionPropagationContext(this.getThreadInfo().tx);
    }

    public Object getTransactionPropagationContext(Transaction tx) {
        if (tx == null) {
            return null;
        }
        if (!(tx instanceof TransactionImpl)) {
            this.log.warn((Object)("Cannot export transaction propagation context: " + tx));
            return null;
        }
        return ((TransactionImpl)tx).getLocalId();
    }

    public void registerWork(Work work, Xid xid, long timeout) throws WorkCompletedException {
        if (this.trace) {
            this.log.trace((Object)("registering work=" + work + " xid=" + xid + " timeout=" + timeout));
        }
        try {
            TransactionImpl tx = this.importExternalTransaction(xid, timeout);
            tx.setWork(work);
        }
        catch (WorkCompletedException e) {
            throw e;
        }
        catch (Throwable t) {
            WorkCompletedException e = new WorkCompletedException("Error registering work", t);
            e.setErrorCode("3");
            throw e;
        }
        if (this.trace) {
            this.log.trace((Object)("registered work= " + work + " xid=" + xid + " timeout=" + timeout));
        }
    }

    public void startWork(Work work, Xid xid) throws WorkCompletedException {
        if (this.trace) {
            this.log.trace((Object)("starting work=" + work + " xid=" + xid));
        }
        TransactionImpl tx = this.getExternalTransaction(xid);
        this.associateThread(tx);
        if (this.trace) {
            this.log.trace((Object)("started work= " + work + " xid=" + xid));
        }
    }

    public void endWork(Work work, Xid xid) {
        if (this.trace) {
            this.log.trace((Object)("ending work=" + work + " xid=" + xid));
        }
        try {
            TransactionImpl tx = this.getExternalTransaction(xid);
            tx.setWork(null);
            this.disassociateThread();
        }
        catch (WorkCompletedException e) {
            this.log.error((Object)"Unexpected error from endWork ", (Throwable)e);
            throw new UnexpectedThrowable(e.toString());
        }
        if (this.trace) {
            this.log.trace((Object)("ended work=" + work + " xid=" + xid));
        }
    }

    public void cancelWork(Work work, Xid xid) {
        if (this.trace) {
            this.log.trace((Object)("cancling work=" + work + " xid=" + xid));
        }
        try {
            TransactionImpl tx = this.getExternalTransaction(xid);
            tx.setWork(null);
        }
        catch (WorkCompletedException e) {
            this.log.error((Object)"Unexpected error from cancelWork ", (Throwable)e);
            throw new UnexpectedThrowable(e.toString());
        }
        if (this.trace) {
            this.log.trace((Object)("cancled work=" + work + " xid=" + xid));
        }
    }

    public int prepare(Xid xid) throws XAException {
        if (this.trace) {
            this.log.trace((Object)("preparing xid=" + xid));
        }
        try {
            TransactionImpl tx = this.getExternalTransaction(xid);
            int result = tx.prepare();
            if (this.trace) {
                this.log.trace((Object)("prepared xid=" + xid + " result=" + result));
            }
            return result;
        }
        catch (Throwable t) {
            JBossXAException.rethrowAsXAException("Error during prepare", t);
            throw new UnreachableStatementException();
        }
    }

    public void rollback(Xid xid) throws XAException {
        if (this.trace) {
            this.log.trace((Object)("rolling back xid=" + xid));
        }
        try {
            TransactionImpl tx = this.getExternalTransaction(xid);
            tx.rollback();
        }
        catch (Throwable t) {
            JBossXAException.rethrowAsXAException("Error during rollback", t);
        }
        if (this.trace) {
            this.log.trace((Object)("rolled back xid=" + xid));
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (this.trace) {
            this.log.trace((Object)("committing xid=" + xid + " onePhase=" + onePhase));
        }
        try {
            TransactionImpl tx = this.getExternalTransaction(xid);
            tx.commit(onePhase);
        }
        catch (Throwable t) {
            JBossXAException.rethrowAsXAException("Error during commit", t);
        }
        if (this.trace) {
            this.log.trace((Object)("committed xid=" + xid));
        }
    }

    public void forget(Xid xid) throws XAException {
        if (this.trace) {
            this.log.trace((Object)("forgetting xid=" + xid));
        }
        try {
            TransactionImpl tx = this.getExternalTransaction(xid);
            tx.rollback();
        }
        catch (Throwable t) {
            JBossXAException.rethrowAsXAException("Error during forget", t);
        }
        if (this.trace) {
            this.log.trace((Object)("forgot xid=" + xid));
        }
    }

    public Xid[] recover(int flag) throws XAException {
        return new Xid[0];
    }

    TransactionImpl importExternalTransaction(Xid xid, long timeOut) {
        GlobalId gid = new GlobalId(xid);
        TransactionImpl tx = (TransactionImpl)this.globalIdTx.get(gid);
        if (tx != null) {
            if (this.trace) {
                this.log.trace((Object)("imported existing transaction xid: " + xid + " tx=" + tx));
            }
        } else {
            ThreadInfo ti = this.getThreadInfo();
            long timeout = ti.timeout == 0L ? timeOut : ti.timeout;
            tx = new TransactionImpl(gid, timeout);
            this.localIdTx.put(tx.getLocalId(), tx);
            if (this.globalIdsEnabled) {
                this.globalIdTx.put(gid, tx);
            }
            if (this.trace) {
                this.log.trace((Object)("imported new transaction xid: " + xid + " tx=" + tx + " timeout=" + timeout));
            }
        }
        return tx;
    }

    TransactionImpl getExternalTransaction(Xid xid) throws WorkCompletedException {
        GlobalId gid = new GlobalId(xid);
        TransactionImpl tx = (TransactionImpl)this.globalIdTx.get(gid);
        if (tx == null) {
            throw new WorkCompletedException("Xid not found " + xid, "3");
        }
        return tx;
    }

    public Object getValue(TransactionLocal local, Transaction tx) {
        TransactionImpl tximpl = (TransactionImpl)tx;
        return tximpl.getTransactionLocalValue(local);
    }

    public void storeValue(TransactionLocal local, Transaction tx, Object value) {
        TransactionImpl tximpl = (TransactionImpl)tx;
        tximpl.putTransactionLocalValue(local, value);
    }

    public boolean containsValue(TransactionLocal local, Transaction tx) {
        TransactionImpl tximpl = (TransactionImpl)tx;
        return tximpl.containsTransactionLocal(local);
    }

    void releaseTransactionImpl(TransactionImpl tx) {
        this.localIdTx.remove(tx.getLocalId());
        if (this.globalIdsEnabled) {
            this.globalIdTx.remove(tx.getGlobalId());
        }
    }

    void incCommitCount() {
        ++this.commitCount;
    }

    void incRollbackCount() {
        ++this.rollbackCount;
    }

    private ThreadInfo getThreadInfo() {
        ThreadInfo ret = (ThreadInfo)this.threadTx.get();
        if (ret == null) {
            ret = new ThreadInfo();
            ret.timeout = this.timeOut;
            this.threadTx.set(ret);
        }
        return ret;
    }

    static class ThreadInfo {
        long timeout;
        TransactionImpl tx;

        ThreadInfo() {
        }
    }
}

