/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.aop.AOPClassPool;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.MethodExecutionTransformer;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.standalone.Compiler;

public class ConstructorExecutionTransformer {
    private Instrumentor instrumentor;
    private AspectManager manager;

    public ConstructorExecutionTransformer(Instrumentor instrumentor, AspectManager manager) {
        this.instrumentor = instrumentor;
        this.manager = manager;
    }

    public static String constructorFactory(String className) {
        return className + "_new_" + "$aop";
    }

    public boolean replaceConstructorAccess(ClassAdvisor sourceAdvisor, CtClass source) throws NotFoundException {
        if (!ConstructorExecutionTransformer.isAdvisableConstructor(source, sourceAdvisor)) {
            return false;
        }
        this.instrumentor.converter.replaceNew(source, source, ConstructorExecutionTransformer.constructorFactory(source.getSimpleName()));
        return true;
    }

    public void buildConstructorWrappers(CtClass clazz, ClassAdvisor advisor) throws Exception {
        if (!ConstructorExecutionTransformer.isAdvisableConstructor(clazz, advisor)) {
            return;
        }
        this.instrumentor.setupBasics(clazz);
        List constructors = this.instrumentor.getConstructors(clazz);
        Iterator it = constructors.iterator();
        int index = 0;
        while (it.hasNext()) {
            CtConstructor constructor = (CtConstructor)it.next();
            int mod = 8;
            mod = (constructor.getModifiers() & 1) != 0 ? (mod |= 1) : ((constructor.getModifiers() & 4) != 0 ? (mod |= 4) : ((constructor.getModifiers() & 2) != 0 ? (mod |= 2) : (mod |= 1)));
            CtClass[] exceptions = constructor.getExceptionTypes();
            String name = clazz.getSimpleName();
            CtClass type = constructor.getDeclaringClass();
            if (AspectManager.optimize) {
                this.createOptimizedWrapper(type, name, constructor, exceptions, clazz, mod, advisor, index);
            } else {
                this.createWrapper(type, name, constructor, exceptions, clazz, mod, advisor, index);
            }
            ++index;
        }
    }

    private void createWrapper(CtClass type, String name, CtConstructor constructor, CtClass[] exceptions, CtClass clazz, int mod, ClassAdvisor advisor, int index) throws CannotCompileException, NotFoundException {
        CtMethod wmethod = CtNewMethod.make((CtClass)type, (String)ConstructorExecutionTransformer.constructorFactory(name), (CtClass[])constructor.getParameterTypes(), (CtClass[])exceptions, null, (CtClass)clazz);
        wmethod.setModifiers(mod);
        String code = null;
        if (ConstructorExecutionTransformer.isAdvisableConstructor(constructor, advisor)) {
            String args = "(Object[])null";
            if (constructor.getParameterTypes().length > 0) {
                args = "$args";
            }
            code = "{     org.jboss.aop.advice.Interceptor[] interceptors = aop$classAdvisor$aop.getConstructorInterceptors()[" + index + "]; " + "    if (interceptors != (org.jboss.aop.advice.Interceptor[])null) " + "    { " + "       return ($r)" + "aop$classAdvisor$aop" + ".invokeNew(" + args + ", (int)" + index + "); " + "    } " + "    return new " + clazz.getName() + "($$); " + "}";
        } else {
            code = "{     return new " + clazz.getName() + "($$); " + "}";
        }
        wmethod.setBody(code);
        clazz.addMethod(wmethod);
    }

    private void createOptimizedWrapper(CtClass type, String name, CtConstructor constructor, CtClass[] exceptions, CtClass clazz, int mod, ClassAdvisor advisor, int index) throws Exception {
        String invocationClass = this.createOptimizedInvocationClass(type, constructor, index);
        CtMethod wmethod = CtNewMethod.make((CtClass)type, (String)ConstructorExecutionTransformer.constructorFactory(name), (CtClass[])constructor.getParameterTypes(), (CtClass[])exceptions, null, (CtClass)clazz);
        wmethod.setModifiers(mod);
        String code = null;
        code = ConstructorExecutionTransformer.isAdvisableConstructor(constructor, advisor) ? "{     org.jboss.aop.advice.Interceptor[] interceptors = aop$classAdvisor$aop.getConstructorInterceptors()[" + index + "]; " + "    if (interceptors != (org.jboss.aop.advice.Interceptor[])null) " + "    { " + "       " + invocationClass + " invocation = new " + invocationClass + "(interceptors); " + "       invocation.setConstructor(" + "aop$classAdvisor$aop" + ".getConstructors()[" + index + "]); " + MethodExecutionTransformer.setArguments(constructor.getParameterTypes()) + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       return ($r)invocation.invokeNext(); " + "    } " + "    return new " + clazz.getName() + "($$); " + "}" : "{     return new " + clazz.getName() + "($$); " + "}";
        try {
            wmethod.setBody(code);
        }
        catch (CannotCompileException e) {
            System.out.println(code);
            throw new RuntimeException(e);
        }
        clazz.addMethod(wmethod);
    }

    public static boolean isAdvisableConstructor(CtClass clazz, ClassAdvisor advisor) throws NotFoundException {
        CtConstructor[] constructors = clazz.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            if (!ConstructorExecutionTransformer.isAdvisableConstructor(constructors[i], advisor)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAdvisableConstructor(CtConstructor con, ClassAdvisor advisor) throws NotFoundException {
        Iterator pointcuts = advisor.getManager().getPointcuts().values().iterator();
        while (pointcuts.hasNext()) {
            Pointcut pointcut = (Pointcut)pointcuts.next();
            if (!pointcut.matchesExecution((Advisor)advisor, con)) continue;
            return true;
        }
        return false;
    }

    protected String createOptimizedInvocationClass(CtClass clazz, CtConstructor con, int index) throws Exception {
        CtClass invocation;
        boolean makeInnerClass;
        AOPClassPool pool = (AOPClassPool)this.instrumentor.getClassPool();
        CtClass conInvocation = pool.get("org.jboss.aop.joinpoint.ConstructorInvocation");
        CtClass untransformable = pool.get("org.jboss.aop.instrument.Untransformable");
        String className = con.getDeclaringClass().getName() + index + "OptimizedConstructorInvocation";
        boolean bl = makeInnerClass = !Modifier.isPublic((int)con.getModifiers());
        if (makeInnerClass) {
            String innerClassName = className.substring(className.lastIndexOf(46) + 1);
            boolean classStatic = true;
            invocation = clazz.makeNestedClass(innerClassName, classStatic);
            invocation.setSuperclass(conInvocation);
        } else {
            invocation = pool.makeClass(className, conInvocation);
        }
        invocation.addInterface(untransformable);
        CtConstructor template = conInvocation.getDeclaredConstructors()[0];
        CtConstructor icon = CtNewConstructor.make((CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), (CtClass)invocation);
        invocation.addConstructor(icon);
        CtClass[] params = con.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            CtField field = new CtField(params[i], "arg" + i, invocation);
            field.setModifiers(1);
            invocation.addField(field);
        }
        CtMethod in = conInvocation.getDeclaredMethod("invokeNext");
        CtMethod invokeNext = CtNewMethod.make((CtClass)in.getReturnType(), (String)"invokeNext", (CtClass[])in.getParameterTypes(), (CtClass[])in.getExceptionTypes(), null, (CtClass)invocation);
        invokeNext.setModifiers(in.getModifiers());
        String code = "{    if (currentInterceptor < interceptors.length)    {       try         {          return interceptors[currentInterceptor++].invoke(this);       }        catch (Throwable t)        {           currentInterceptor--;           throw t;       }    } ";
        code = code + "return new " + con.getDeclaringClass().getName() + "(";
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                code = code + ", ";
            }
            code = code + "arg" + i;
        }
        code = code + ");  ";
        code = code + "}";
        try {
            invokeNext.setBody(code);
        }
        catch (CannotCompileException e) {
            System.out.println(code);
            throw e;
        }
        invocation.addMethod(invokeNext);
        TransformerCommon.addGetArguments(pool, invocation, con.getParameterTypes());
        this.addCopy(pool, invocation, con.getParameterTypes());
        if (Compiler.loader != null) {
            URL url = Compiler.loader.getResource(con.getDeclaringClass().getName().replace('.', '/') + ".class");
            String path = url.toString();
            path = path.substring(0, path.lastIndexOf(47) + 1);
            path = path + invocation.getSimpleName() + ".class";
            URI newUrl = new URI(path);
            File file = new File(newUrl);
            FileOutputStream fp = new FileOutputStream(file);
            fp.write(invocation.toBytecode());
            fp.close();
        } else {
            invocation.toClass();
        }
        return invocation.getName();
    }

    private void addCopy(ClassPool pool, CtClass invocation, CtClass[] params) throws Exception {
        CtClass methodInvocation = pool.get("org.jboss.aop.joinpoint.ConstructorInvocation");
        CtMethod template = methodInvocation.getDeclaredMethod("copy");
        CtMethod copy = CtNewMethod.make((CtClass)template.getReturnType(), (String)"copy", (CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), null, (CtClass)invocation);
        copy.setModifiers(template.getModifiers());
        String code = "{    " + invocation.getName() + " wrapper = new " + invocation.getName() + "(this.interceptors); " + "   wrapper.constructor = this.constructor; " + "   wrapper.arguments = this.arguments; " + "   wrapper.metadata = this.metadata; " + "   wrapper.currentInterceptor = this.currentInterceptor; ";
        for (int i = 0; i < params.length; ++i) {
            code = code + "   wrapper.arg" + i + " = this.arg" + i + "; ";
        }
        code = code + "   return wrapper; }";
        copy.setBody(code);
        invocation.addMethod(copy);
    }
}

