/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc.codeunit;

import java.io.File;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import xjavadoc.Named;
import xjavadoc.NodePrinter;
import xjavadoc.SimpleNode;
import xjavadoc.SourceClass;
import xjavadoc.Type;
import xjavadoc.XClass;
import xjavadoc.XConstructor;
import xjavadoc.XExecutableMember;
import xjavadoc.XField;
import xjavadoc.XJavaDoc;
import xjavadoc.XMethod;
import xjavadoc.XParameter;
import xjavadoc.XProgramElement;

public abstract class CodeTestCase
extends TestCase {
    private XJavaDoc _xJavaDoc = new XJavaDoc();

    public void assertEquals(File expected, File actual) {
        this.assertAstEquals(expected, actual);
        this.assertApiEquals(expected, actual);
    }

    public void assertAstEquals(File expected, File actual) {
        SourceClass expectedClass = new SourceClass(this._xJavaDoc, expected, true, this._xJavaDoc.getTagFactory());
        SourceClass actualClass = new SourceClass(this._xJavaDoc, actual, true, this._xJavaDoc.getTagFactory());
        this.assertAstEquals(expectedClass.getCompilationUnit(), actualClass.getCompilationUnit());
    }

    public void assertApiEquals(File expected, File actual) {
        SourceClass expectedClass = new SourceClass(this._xJavaDoc, expected, false, this._xJavaDoc.getTagFactory());
        SourceClass actualClass = new SourceClass(this._xJavaDoc, actual, false, this._xJavaDoc.getTagFactory());
        this.assertApiEquals(expectedClass, actualClass);
    }

    private void assertAstEquals(SimpleNode expected, SimpleNode actual) {
        boolean sameNumberOfChildren;
        boolean sameNodeType = expected.getType().equals(actual.getType());
        boolean bl = sameNumberOfChildren = expected.jjtGetNumChildren() == actual.jjtGetNumChildren();
        if (!sameNodeType || !sameNumberOfChildren) {
            StringWriter expectedWriter = new StringWriter();
            NodePrinter.print(expected, expectedWriter);
            StringWriter actualWriter = new StringWriter();
            NodePrinter.print(actual, actualWriter);
            CodeTestCase.assertEquals((String)expectedWriter.toString(), (String)expectedWriter.toString(), (String)actualWriter.toString());
        }
        for (int i = 0; i < expected.jjtGetNumChildren(); ++i) {
            SimpleNode expectedChild = (SimpleNode)expected.jjtGetChild(i);
            SimpleNode actualChild = (SimpleNode)actual.jjtGetChild(i);
            this.assertAstEquals(expectedChild, actualChild);
        }
    }

    private void assertApiEquals(SourceClass expected, SourceClass actual) {
        this.assertModifiersEqual("Class modifiers are equal", expected, actual);
        this.assertNameEquals("Class modifiers are equal", expected, actual);
        this.assertSuperclassEquals(expected, actual);
        this.assertInterfacesEqual(expected, actual);
        this.assertFieldsEqual(expected, actual);
        this.assertConstructorsEqual(expected, actual);
        this.assertMethodsEqual(expected, actual);
    }

    private void assertFieldsEqual(XClass expected, XClass actual) {
        CodeTestCase.assertEquals((String)"Number of fields are equal", (int)expected.getFields().size(), (int)actual.getFields().size());
        Iterator expectedFields = expected.getFields().iterator();
        Iterator actualFields = actual.getFields().iterator();
        while (expectedFields.hasNext()) {
            XField expectedField = (XField)expectedFields.next();
            XField actualField = (XField)actualFields.next();
            this.assertFieldEquals(expectedField, actualField);
        }
    }

    private void assertConstructorsEqual(XClass expected, XClass actual) {
        CodeTestCase.assertEquals((String)"Number of constructors are equal", (int)expected.getConstructors().size(), (int)actual.getConstructors().size());
        Iterator expectedConstructors = expected.getConstructors().iterator();
        Iterator actualConstructors = actual.getConstructors().iterator();
        while (expectedConstructors.hasNext()) {
            XConstructor expectedConstructor = (XConstructor)expectedConstructors.next();
            XConstructor actualConstructor = (XConstructor)actualConstructors.next();
            this.assertConstructorEquals(expectedConstructor, actualConstructor);
        }
    }

    private void assertMethodsEqual(XClass expected, XClass actual) {
        CodeTestCase.assertEquals((String)"Number of methods are equal", (int)expected.getMethods().size(), (int)actual.getMethods().size());
        Iterator expectedMethods = expected.getMethods().iterator();
        Iterator actualMethods = actual.getMethods().iterator();
        while (expectedMethods.hasNext()) {
            XMethod expectedMethod = (XMethod)expectedMethods.next();
            XMethod actualMethod = (XMethod)actualMethods.next();
            this.assertMethodEquals(expectedMethod, actualMethod);
        }
    }

    private void assertFieldEquals(XField expected, XField actual) {
        this.assertTypeEquals("Field types are equal", expected, actual);
        this.assertNameEquals("Field names are equal", expected, actual);
        this.assertModifiersEqual("Field modifiers are equal", expected, actual);
    }

    private void assertConstructorEquals(XConstructor expected, XConstructor actual) {
        this.assertNameEquals("Constructor names are equal", expected, actual);
        this.assertModifiersEqual("Constructor modifiers are equal", expected, actual);
        this.assertNameWithSignatureEquals("Constructor signatures are equal", expected, actual);
        this.assertParametersEqual("Constructor parameters are equal", expected, actual);
        this.assertThrownExceptionsEqual("Constructor exceptions are equal", expected, actual);
    }

    private void assertMethodEquals(XMethod expected, XMethod actual) {
        this.assertTypeEquals("Method types are equal", expected.getReturnType(), actual.getReturnType());
        this.assertNameEquals("Method names are equal", expected, actual);
        this.assertModifiersEqual("Method modifiers are equal", expected, actual);
        this.assertNameWithSignatureEquals("Method signatures are equal", expected, actual);
        this.assertParametersEqual("Method parameters are equal", expected, actual);
        this.assertThrownExceptionsEqual("Method exceptions are equal", expected, actual);
    }

    private void assertParameterEquals(XParameter expected, XParameter actual) {
        this.assertTypeEquals("Parameter types are equal", expected, actual);
        this.assertNameEquals("Parameter names are equal", expected, actual);
    }

    private void assertTypeEquals(String msg, Type expected, Type actual) {
        CodeTestCase.assertEquals((String)msg, (String)expected.getType().getQualifiedName(), (String)actual.getType().getQualifiedName());
        CodeTestCase.assertEquals((String)msg, (String)expected.getDimensionAsString(), (String)actual.getDimensionAsString());
    }

    private void assertNameEquals(String msg, Named expected, Named actual) {
        CodeTestCase.assertEquals((String)msg, (String)expected.getName(), (String)actual.getName());
    }

    private void assertSuperclassEquals(SourceClass expected, SourceClass actual) {
        String expectedSuperclass = expected.getSuperclass() != null ? expected.getSuperclass().getQualifiedName() : null;
        String actualSuperclass = actual.getSuperclass() != null ? actual.getSuperclass().getQualifiedName() : null;
        CodeTestCase.assertEquals((String)"Superclass is equal", (String)expectedSuperclass, (String)actualSuperclass);
    }

    private void assertInterfacesEqual(SourceClass expected, SourceClass actual) {
        CodeTestCase.assertEquals((String)"Implemented interfaces are equal", (int)expected.getDeclaredInterfaces().size(), (int)actual.getDeclaredInterfaces().size());
        Iterator declaredInterfaces = expected.getDeclaredInterfaces().iterator();
        while (declaredInterfaces.hasNext()) {
            XClass declaredInterface = (XClass)declaredInterfaces.next();
            CodeTestCase.assertTrue((String)("Implements " + declaredInterface.getQualifiedName()), (boolean)actual.isA(declaredInterface.getQualifiedName()));
        }
    }

    private void assertModifiersEqual(String msg, XProgramElement expected, XProgramElement actual) {
        CodeTestCase.assertEquals((String)msg, (String)expected.getModifiers(), (String)actual.getModifiers());
    }

    private void assertNameWithSignatureEquals(String msg, XExecutableMember expected, XExecutableMember actual) {
        CodeTestCase.assertEquals((String)msg, (String)expected.getNameWithSignature(false), (String)actual.getNameWithSignature(false));
    }

    private void assertParametersEqual(String msg, XExecutableMember expected, XExecutableMember actual) {
        CodeTestCase.assertEquals((String)msg, (int)expected.getParameters().size(), (int)actual.getParameters().size());
        Iterator expectedParameters = expected.getParameters().iterator();
        Iterator actualParameters = actual.getParameters().iterator();
        while (expectedParameters.hasNext()) {
            XParameter expectedParameter = (XParameter)expectedParameters.next();
            XParameter actualParameter = (XParameter)actualParameters.next();
            this.assertParameterEquals(expectedParameter, actualParameter);
        }
    }

    private void assertThrownExceptionsEqual(String msg, XExecutableMember expected, XExecutableMember actual) {
        CodeTestCase.assertEquals((String)msg, (int)expected.getThrownExceptions().size(), (int)actual.getThrownExceptions().size());
        Iterator expectedThrownExceptions = expected.getThrownExceptions().iterator();
        while (expectedThrownExceptions.hasNext()) {
            XClass expectedThrownException = (XClass)expectedThrownExceptions.next();
            CodeTestCase.assertTrue((String)("Throws " + expectedThrownException.getQualifiedName()), (boolean)actual.throwsException(expectedThrownException.getQualifiedName()));
        }
    }

    protected File getDir() {
        return new File(((Object)((Object)this)).getClass().getResource("/" + ((Object)((Object)this)).getClass().getName().replace('.', '/') + ".class").getFile()).getParentFile();
    }

    protected File getRootDir() {
        File dir = this.getDir();
        StringTokenizer st = new StringTokenizer(((Object)((Object)this)).getClass().getName(), ".");
        for (int i = 0; i < st.countTokens() - 1; ++i) {
            dir = dir.getParentFile();
        }
        return dir;
    }

    protected XJavaDoc getXJavaDoc() {
        return this._xJavaDoc;
    }
}

