/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.util.Iterator;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.jboss.aop.AspectManager;

public class AOPClassPool
extends ClassPool {
    protected AspectManager manager;
    protected ClassLoader dcl;
    protected LoaderClassPath classPath;

    public AOPClassPool(ClassLoader cl, ClassPool src, AspectManager manager) {
        super(src);
        this.manager = manager;
        this.dcl = cl;
        if (cl != null) {
            this.classPath = new LoaderClassPath(cl);
            this.insertClassPath((ClassPath)this.classPath);
        }
        this.childFirstLookup = true;
    }

    protected AOPClassPool(ClassPool src, AspectManager manager) {
        this(null, src, manager);
    }

    public void close() {
        this.removeClassPath((ClassPath)this.classPath);
        this.classPath.close();
        this.classes.clear();
    }

    public void flushClass(String classname) {
        this.classes.remove(classname);
    }

    public boolean isUnloadedClassLoader() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CtClass getCached(String classname) {
        CtClass clazz = this.getCachedLocally(classname);
        if (clazz == null) {
            Map registeredCLs;
            Map map = registeredCLs = this.manager.getRegisteredCLs();
            synchronized (map) {
                Iterator it = registeredCLs.values().iterator();
                while (it.hasNext()) {
                    AOPClassPool pool = (AOPClassPool)((Object)it.next());
                    if (pool.isUnloadedClassLoader()) {
                        AspectManager.instance().unregisterClassLoader(pool.dcl);
                        continue;
                    }
                    clazz = pool.getCachedLocally(classname);
                    if (clazz == null) continue;
                    return clazz;
                }
            }
        }
        return clazz;
    }

    protected CtClass getCachedLocally(String classname) {
        return (CtClass)this.classes.get(classname);
    }

    public synchronized CtClass getLocally(String classname) throws NotFoundException {
        CtClass clazz = (CtClass)this.classes.get(classname);
        if (clazz == null) {
            clazz = this.createCtClass(classname, true);
            if (clazz == null) {
                throw new NotFoundException(classname);
            }
            this.classes.put(classname, clazz);
        }
        return clazz;
    }

    public static AOPClassPool createAOPClassPool(ClassLoader cl, ClassPool src, AspectManager manager) {
        return AspectManager.classPoolFactory.create(cl, src, manager);
    }

    public static AOPClassPool createAOPClassPool(ClassPool src, AspectManager manager) {
        return AspectManager.classPoolFactory.create(src, manager);
    }

    public Class toClass(CtClass ct, ClassLoader loader) throws CannotCompileException {
        return super.toClass(ct, this.dcl);
    }
}

