/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;
import org.jboss.aop.AOPClassPool;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.instrument.ConstructorExecutionTransformer;
import org.jboss.aop.instrument.DeclareChecker;
import org.jboss.aop.instrument.FieldAccessTransformer;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.MethodExecutionTransformer;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.util.JavassistMethodHashing;

public class CallerTransformer {
    Instrumentor instrumentor;
    boolean optimize;
    FieldAccessTransformer.NotOptimizedTransformer notOptimizedTransformer;
    FieldAccessTransformer.OptimizedTransformer optimizedTransformer;
    AspectManager manager;

    public CallerTransformer(Instrumentor instrumentor, AspectManager manager) {
        this.instrumentor = instrumentor;
        this.optimize = AspectManager.optimize;
        this.manager = manager;
    }

    public boolean applyCallerPointcuts(CtClass clazz, ClassAdvisor advisor) throws CannotCompileException {
        CallerExprEditor expr = new CallerExprEditor(advisor, clazz);
        CtMethod[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!Instrumentor.isAdvisable(methods[i])) continue;
            methods[i].instrument((ExprEditor)expr);
        }
        CtConstructor[] cons = clazz.getDeclaredConstructors();
        for (int i = 0; i < cons.length; ++i) {
            cons[i].instrument((ExprEditor)expr);
        }
        return expr.appliedCallerBinding;
    }

    class CallerExprEditor
    extends ExprEditor {
        CtClass callingClass;
        ClassAdvisor advisor;
        List constructors;
        public boolean appliedCallerBinding = false;
        HashMap callerInfos = new HashMap();
        int invocationCounter = 0;

        public CallerExprEditor(ClassAdvisor advisor, CtClass callingClass) {
            this.advisor = advisor;
            this.callingClass = callingClass;
            this.constructors = CallerTransformer.this.instrumentor.getConstructors(callingClass);
        }

        private String getHashString(long hash) {
            if (hash < 0L) {
                return "_N_" + -1L * hash;
            }
            return "_" + hash;
        }

        private String getUniqueInvocationfieldname(long callingHash, String classname, long calledHash) {
            classname = classname.replace('.', '_');
            classname = classname.replace('/', '_');
            return this.getHashString(callingHash) + classname + this.getHashString(calledHash);
        }

        private String getUniqueInvocationClassname(String classname) {
            return classname + "_" + ++this.invocationCounter + "_";
        }

        private String getConstructorInfoName(long callingHash, String classname, long calledHash) {
            return "aop$constructorCall_" + this.getUniqueInvocationfieldname(callingHash, classname, calledHash);
        }

        private String getOptimizedConCalledByMethodInvocationClassName(long callingHash, String classname, long calledHash) {
            return this.getUniqueInvocationClassname(classname) + "ConByMInvocation";
        }

        private String getConstructorConstructorInfoName(long callingIndex, String classname, long calledHash) {
            return "aop$constructorCall_con_" + this.getUniqueInvocationfieldname(callingIndex, classname, calledHash);
        }

        private String getOptimizedConCalledByConInvocationClassName(long callingIndex, String classname, long calledHash) {
            return this.getUniqueInvocationClassname(classname) + "ConByConInvocation";
        }

        private String getCallerInfoName(long callingHash, String classname, long calledHash) {
            return "aop$methodCall_" + this.getUniqueInvocationfieldname(callingHash, classname, calledHash);
        }

        private String getOptimizedMethodCalledByMethodClassName(long callingHash, String classname, long calledHash) {
            return this.getUniqueInvocationClassname(classname) + "MByMInvocation";
        }

        private String getConstructorCallerInfoName(int index, String classname, long calledHash) {
            return "aop$methodCall_" + this.getUniqueInvocationfieldname(index, classname, calledHash);
        }

        private String getOptimizedMethodCalledByConstructorClassName(int callingIndex, String classname, long calledHash) {
            return this.getUniqueInvocationClassname(classname) + "MByConInvocation";
        }

        private void addCallerMethodInfoField(CtClass clazz, String fieldName, long callingHash, String classname, long calledHash) throws Exception {
            CtClass type = CallerTransformer.this.instrumentor.forName("org.jboss.aop.CallerMethodInfo");
            CtField field = new CtField(type, fieldName, clazz);
            field.setModifiers(10);
            CtField.Initializer initializer = CtField.Initializer.byExpr((String)("aop$classAdvisor$aop.resolveCallerMethodInfo(" + callingHash + "L, \"" + classname + "\", " + calledHash + "L)"));
            clazz.addField(field, initializer);
        }

        private void addCallerConstructorInfoField(CtClass clazz, String fieldName, long callingHash, String classname, long calledHash) throws Exception {
            CtClass type = CallerTransformer.this.instrumentor.forName("org.jboss.aop.CallerConstructorInfo");
            CtField field = new CtField(type, fieldName, clazz);
            field.setModifiers(10);
            CtField.Initializer initializer = CtField.Initializer.byExpr((String)("aop$classAdvisor$aop.resolveCallerConstructorInfo(" + callingHash + "L, \"" + classname + "\", " + calledHash + "L)"));
            clazz.addField(field, initializer);
        }

        private void addConstructorCallerConstructorInfoField(CtClass clazz, String fieldName, int callingIndex, String classname, long calledHash) throws Exception {
            CtClass type = CallerTransformer.this.instrumentor.forName("org.jboss.aop.CallerConstructorInfo");
            CtField field = new CtField(type, fieldName, clazz);
            field.setModifiers(10);
            CtField.Initializer initializer = CtField.Initializer.byExpr((String)("aop$classAdvisor$aop.resolveConstructorCallerConstructorInfo(" + callingIndex + ", \"" + classname + "\", " + calledHash + "L)"));
            clazz.addField(field, initializer);
        }

        private void addConstructorCallerMethodInfoField(CtClass clazz, String fieldName, int callingIndex, String classname, long calledHash) throws Exception {
            CtClass type = CallerTransformer.this.instrumentor.forName("org.jboss.aop.CallerMethodInfo");
            CtField field = new CtField(type, fieldName, clazz);
            field.setModifiers(10);
            CtField.Initializer initializer = CtField.Initializer.byExpr((String)("aop$classAdvisor$aop.resolveConstructorCallerMethodInfo(" + callingIndex + ", \"" + classname + "\", " + calledHash + "L)"));
            clazz.addField(field, initializer);
        }

        public void edit(MethodCall call) throws CannotCompileException {
            try {
                String classname = call.getClassName();
                String methodName = call.getMethodName();
                if (ClassAdvisor.isWithoutAdvisement(methodName) || methodName.startsWith("_") || classname.startsWith("org.jboss.aop") || call.getMethodName().equals("class$")) {
                    return;
                }
                CtBehavior behavior = call.where();
                boolean hasPointcut = false;
                DeclareChecker.checkDeclares(CallerTransformer.this.manager, call, this.advisor);
                Iterator it = CallerTransformer.this.manager.getPointcuts().values().iterator();
                while (it.hasNext()) {
                    Pointcut p = (Pointcut)it.next();
                    if (!p.matchesCall((Advisor)this.advisor, call)) continue;
                    hasPointcut = true;
                    break;
                }
                if (hasPointcut) {
                    if (behavior instanceof CtMethod) {
                        this.modifyMethod(call, classname);
                    } else if (behavior instanceof CtConstructor) {
                        this.modifyConstructor(call, classname);
                    }
                }
            }
            catch (Exception ex) {
                System.err.println("error getting:" + call.getClassName() + ". '" + call.getMethodName() + "'");
                ex.printStackTrace();
                throw new CannotCompileException((Throwable)ex);
            }
        }

        protected void modifyConstructor(MethodCall call, String classname) throws Exception, NotFoundException {
            String invocationClassName;
            CallerTransformer.this.instrumentor.setupBasics(this.callingClass);
            CtConstructor con = (CtConstructor)call.where();
            int callingIndex = this.constructors.indexOf(con);
            long calledHash = JavassistMethodHashing.methodHash(call.getMethod());
            String callerInfoField = this.getConstructorCallerInfoName(callingIndex, classname, calledHash);
            CtMethod calledMethod = call.getMethod();
            if (this.callerInfos.get(callerInfoField) == null) {
                invocationClassName = CallerTransformer.this.optimize ? this.createOptimizedMethodCalledByConInvocationClass(calledMethod, callingIndex, calledHash) : "whatever";
                this.callerInfos.put(callerInfoField, invocationClassName);
                this.addConstructorCallerMethodInfoField(this.callingClass, callerInfoField, callingIndex, classname, calledHash);
            }
            if (CallerTransformer.this.optimize) {
                invocationClassName = (String)this.callerInfos.get(callerInfoField);
                String typedTargetObject = Modifier.isStatic((int)calledMethod.getModifiers()) ? "" : "invocation.typedTargetObject=$0;";
                String replaced = "if (" + callerInfoField + ".interceptors != (org.jboss.aop.advice.Interceptor[])null) { " + invocationClassName + " invocation = new " + invocationClassName + "    (" + callerInfoField + ".method, $args, " + "aop$classAdvisor$aop" + ".getConstructors()[" + callingIndex + "]," + callerInfoField + ".interceptors);" + typedTargetObject + MethodExecutionTransformer.setArguments(calledMethod.getParameterTypes()) + "invocation.setTargetObject($0);" + "$_ = ($r)invocation.invokeNext();" + "} else { " + "$_ = $proceed($$); " + "}";
                call.replace(replaced);
            } else {
                String replaced = "if (" + callerInfoField + ".interceptors != (org.jboss.aop.advice.Interceptor[])null) { " + "$_ = ($r)aop$classAdvisor$aop.invokeConstructorCaller(" + callingIndex + ", $0, $args, " + callerInfoField + "); " + "} else { " + "$_ = $proceed($$); " + "}";
                call.replace(replaced);
            }
            this.appliedCallerBinding = true;
        }

        protected void modifyMethod(MethodCall call, String classname) throws Exception, NotFoundException {
            CallerTransformer.this.instrumentor.setupBasics(this.callingClass);
            CtMethod where = (CtMethod)call.where();
            long callingHash = JavassistMethodHashing.methodHash(where);
            long calledHash = JavassistMethodHashing.methodHash(call.getMethod());
            String callerInfoField = this.getCallerInfoName(callingHash, classname, calledHash);
            CtMethod calledMethod = call.getMethod();
            if (this.callerInfos.get(callerInfoField) == null) {
                String invocationClassName = CallerTransformer.this.optimize ? this.createOptimizedMethodCalledByMethodInvocationClass(calledMethod, callingHash, calledHash) : "whatever";
                this.callerInfos.put(callerInfoField, invocationClassName);
                this.addCallerMethodInfoField(this.callingClass, callerInfoField, callingHash, classname, calledHash);
            }
            String callingObject = ", null";
            if (!Modifier.isStatic((int)where.getModifiers())) {
                callingObject = ", this";
            }
            if (CallerTransformer.this.optimize) {
                String invocationClassName = (String)this.callerInfos.get(callerInfoField);
                String typedTargetObject = Modifier.isStatic((int)calledMethod.getModifiers()) ? "" : "invocation.typedTargetObject=$0;";
                String replaced = "if (" + callerInfoField + ".interceptors != (org.jboss.aop.advice.Interceptor[])null) { " + invocationClassName + " invocation = new " + invocationClassName + "    (" + callerInfoField + ".interceptors, " + callerInfoField + ".method, $args, " + "aop$classAdvisor$aop" + ".getClazz(), " + callingHash + "L" + callingObject + ");" + MethodExecutionTransformer.setArguments(calledMethod.getParameterTypes()) + typedTargetObject + "invocation.setTargetObject($0);" + "$_ = ($r)invocation.invokeNext();" + "} else { " + "$_ = $proceed($$); " + "}";
                call.replace(replaced);
            } else {
                String replaced = "if (" + callerInfoField + ".interceptors != (org.jboss.aop.advice.Interceptor[])null) { " + "$_ = ($r)aop$classAdvisor$aop.invokeCaller(" + callingHash + "L, $0, $args, " + callerInfoField + callingObject + "); " + "} else { " + "$_ = $proceed($$); " + "}";
                call.replace(replaced);
            }
            this.appliedCallerBinding = true;
        }

        protected void modifyMethod(NewExpr call, String classname) throws Exception, NotFoundException {
            CallerTransformer.this.instrumentor.setupBasics(this.callingClass);
            CtMethod where = (CtMethod)call.where();
            long callingHash = JavassistMethodHashing.methodHash(where);
            long calledHash = JavassistMethodHashing.constructorHash(call.getConstructor());
            String callerInfoField = this.getConstructorInfoName(callingHash, classname, calledHash);
            CtConstructor calledConstructor = call.getConstructor();
            if (this.callerInfos.get(callerInfoField) == null) {
                String invocationClassName = CallerTransformer.this.optimize ? this.createOptimizedConCalledByMethodInvocationClass(calledConstructor, callingHash, calledHash) : "whatever";
                this.callerInfos.put(callerInfoField, invocationClassName);
                this.addCallerConstructorInfoField(this.callingClass, callerInfoField, callingHash, classname, calledHash);
            }
            String callingObject = "null";
            if (!Modifier.isStatic((int)where.getModifiers())) {
                callingObject = "this";
            }
            ClassAdvisor adv = CallerTransformer.this.manager.getTempClassAdvisor(calledConstructor.getDeclaringClass());
            boolean isAdvisableTargetCon = ConstructorExecutionTransformer.isAdvisableConstructor(calledConstructor, adv);
            if (CallerTransformer.this.optimize && !isAdvisableTargetCon) {
                String invocationClassName = (String)this.callerInfos.get(callerInfoField);
                String replaced = "if (" + callerInfoField + ".interceptors != (org.jboss.aop.advice.Interceptor[])null) { " + "java.lang.Object callingObject = " + callingObject + "; " + invocationClassName + " invocation = new " + invocationClassName + "    (" + callerInfoField + ".interceptors, " + callerInfoField + ", " + callingHash + "L," + "aop$classAdvisor$aop" + ".getClazz(), $args, callingObject);" + MethodExecutionTransformer.setArguments(calledConstructor.getParameterTypes()) + "$_ = ($r)invocation.invokeNext();" + "} else { " + "$_ = $proceed($$); " + "}";
                call.replace(replaced);
            } else {
                String replaced = "if (" + callerInfoField + ".interceptors != (org.jboss.aop.advice.Interceptor[])null) { " + "java.lang.Object callingObject = " + callingObject + "; " + "$_ = ($r)aop$classAdvisor$aop.invokeConCalledByMethod(" + callingHash + "L, $args, " + callerInfoField + ", callingObject); " + "} else { " + "$_ = $proceed($$); " + "}";
                call.replace(replaced);
            }
            this.appliedCallerBinding = true;
        }

        protected void modifyConstructor(NewExpr call, String classname) throws Exception, NotFoundException {
            CallerTransformer.this.instrumentor.setupBasics(this.callingClass);
            CtConstructor con = (CtConstructor)call.where();
            int callingIndex = this.constructors.indexOf(con);
            long calledHash = JavassistMethodHashing.constructorHash(call.getConstructor());
            String callerInfoField = this.getConstructorConstructorInfoName(callingIndex, classname, calledHash);
            CtConstructor calledConstructor = call.getConstructor();
            if (this.callerInfos.get(callerInfoField) == null) {
                String invocationClassName = CallerTransformer.this.optimize ? this.createOptimizedConCalledByConInvocationClass(calledConstructor, callingIndex, calledHash) : "whatever";
                this.callerInfos.put(callerInfoField, invocationClassName);
                this.addConstructorCallerConstructorInfoField(this.callingClass, callerInfoField, callingIndex, classname, calledHash);
            }
            ClassAdvisor adv = CallerTransformer.this.manager.getTempClassAdvisor(calledConstructor.getDeclaringClass());
            boolean isAdvisableTargetCon = ConstructorExecutionTransformer.isAdvisableConstructor(calledConstructor, adv);
            if (CallerTransformer.this.optimize && !isAdvisableTargetCon) {
                String invocationClassName = (String)this.callerInfos.get(callerInfoField);
                String replaced = "if (" + callerInfoField + ".interceptors != (org.jboss.aop.advice.Interceptor[])null) { " + invocationClassName + " invocation = new " + invocationClassName + "    (aop$classAdvisor$aop.getConstructors()[" + callingIndex + "], " + callerInfoField + ", $args);" + MethodExecutionTransformer.setArguments(calledConstructor.getParameterTypes()) + "$_ = ($r)invocation.invokeNext();" + "} else { " + "$_ = $proceed($$); " + "}";
                call.replace(replaced);
            } else {
                String replaced = "if (" + callerInfoField + ".interceptors != (org.jboss.aop.advice.Interceptor[])null) { " + "$_ = ($r)aop$classAdvisor$aop.invokeConCalledByCon(" + callingIndex + ", $args, " + callerInfoField + "); " + "} else { " + "$_ = $proceed($$); " + "}";
                call.replace(replaced);
            }
            this.appliedCallerBinding = true;
        }

        public void edit(NewExpr call) throws CannotCompileException {
            try {
                DeclareChecker.checkDeclares(CallerTransformer.this.manager, call, this.advisor);
                String classname = call.getClassName();
                boolean hasPointcut = false;
                Iterator it = CallerTransformer.this.manager.getPointcuts().values().iterator();
                while (it.hasNext()) {
                    Pointcut p = (Pointcut)it.next();
                    if (!p.matchesCall((Advisor)this.advisor, call)) continue;
                    hasPointcut = true;
                    break;
                }
                if (hasPointcut) {
                    CtBehavior behavior = call.where();
                    if (behavior instanceof CtMethod) {
                        this.modifyMethod(call, classname);
                    } else if (behavior instanceof CtConstructor) {
                        this.modifyConstructor(call, classname);
                    }
                }
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                ex.printStackTrace();
                throw new CannotCompileException((Throwable)ex);
            }
        }

        private String createOptimizedConCalledByConInvocationClass(CtConstructor con, int callingIndex, long calledHash) throws Exception {
            AOPClassPool pool = (AOPClassPool)CallerTransformer.this.instrumentor.getClassPool();
            CtClass conInvocation = pool.get("org.jboss.aop.joinpoint.ConstructorCalledByConstructorInvocation");
            String className = this.getOptimizedConCalledByConInvocationClassName(callingIndex, this.callingClass.getName(), calledHash);
            boolean makeInnerClass = Modifier.isPrivate((int)con.getModifiers());
            CtClass invocation = TransformerCommon.makeInvocationClass(pool, makeInnerClass, this.callingClass, className, conInvocation);
            CtClass[] params = con.getParameterTypes();
            TransformerCommon.addArgumentFieldsToInvocation(invocation, params);
            CtMethod in = conInvocation.getDeclaredMethod("invokeNext");
            CtMethod invokeNext = CtNewMethod.make((CtClass)in.getReturnType(), (String)"invokeNext", (CtClass[])in.getParameterTypes(), (CtClass[])in.getExceptionTypes(), null, (CtClass)invocation);
            invokeNext.setModifiers(in.getModifiers());
            String code = "{    if (currentInterceptor < interceptors.length)    {       try         {          return interceptors[currentInterceptor++].invoke(this);       }        catch (Throwable t)        {           currentInterceptor--;           throw t;       }    } ";
            code = code + "return new " + con.getDeclaringClass().getName() + "(";
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    code = code + ", ";
                }
                code = code + "arg" + i;
            }
            code = code + ");  ";
            code = code + "}";
            try {
                invokeNext.setBody(code);
            }
            catch (CannotCompileException e) {
                System.out.println(code);
                throw e;
            }
            invocation.addMethod(invokeNext);
            TransformerCommon.addGetArguments(pool, invocation, con.getParameterTypes());
            CtMethod copyTemplate = conInvocation.getDeclaredMethod("copy");
            CtMethod copy = CtNewMethod.make((CtClass)copyTemplate.getReturnType(), (String)"copy", (CtClass[])copyTemplate.getParameterTypes(), (CtClass[])copyTemplate.getExceptionTypes(), null, (CtClass)invocation);
            copy.setModifiers(copyTemplate.getModifiers());
            String copyCode = "{    " + invocation.getName() + " wrapper = new " + invocation.getName() + "(this.calling, this.info, this.arguments);" + "   wrapper.metadata = super.metadata; " + "   wrapper.currentInterceptor = super.currentInterceptor; " + "   wrapper.instanceResolver = super.instanceResolver; " + "   wrapper.interceptors = super.interceptors; " + "   wrapper.advisor = super.advisor; " + "   wrapper.responseContextInfo = super.responseContextInfo; " + "   wrapper.targetObject = super.targetObject; ";
            for (int i = 0; i < params.length; ++i) {
                copyCode = copyCode + "   wrapper.arg" + i + " = this.arg" + i + "; ";
            }
            copyCode = copyCode + "   return wrapper; }";
            try {
                copy.setBody(copyCode);
            }
            catch (CannotCompileException e) {
                System.out.println(copyCode);
                throw e;
            }
            invocation.addMethod(copy);
            TransformerCommon.compileOrLoadClass(this.callingClass, invocation);
            return invocation.getName();
        }

        private String createOptimizedConCalledByMethodInvocationClass(CtConstructor con, long callingHash, long calledHash) throws Exception {
            AOPClassPool pool = (AOPClassPool)CallerTransformer.this.instrumentor.getClassPool();
            CtClass conInvocation = pool.get("org.jboss.aop.joinpoint.ConstructorCalledByMethodInvocation");
            String className = this.getOptimizedConCalledByMethodInvocationClassName(callingHash, this.callingClass.getName(), calledHash);
            boolean makeInnerClass = Modifier.isPrivate((int)con.getModifiers());
            CtClass invocation = TransformerCommon.makeInvocationClass(pool, makeInnerClass, this.callingClass, className, conInvocation);
            CtClass[] params = con.getParameterTypes();
            TransformerCommon.addArgumentFieldsToInvocation(invocation, params);
            CtMethod in = conInvocation.getDeclaredMethod("invokeNext");
            CtMethod invokeNext = CtNewMethod.make((CtClass)in.getReturnType(), (String)"invokeNext", (CtClass[])in.getParameterTypes(), (CtClass[])in.getExceptionTypes(), null, (CtClass)invocation);
            invokeNext.setModifiers(in.getModifiers());
            String code = "{    if (currentInterceptor < interceptors.length)    {       try         {          return interceptors[currentInterceptor++].invoke(this);       }        catch (Throwable t)        {           currentInterceptor--;           throw t;       }    } ";
            code = code + "return new " + con.getDeclaringClass().getName() + "(";
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    code = code + ", ";
                }
                code = code + "arg" + i;
            }
            code = code + ");  ";
            code = code + "}";
            try {
                invokeNext.setBody(code);
            }
            catch (CannotCompileException e) {
                System.out.println(code);
                throw e;
            }
            invocation.addMethod(invokeNext);
            TransformerCommon.addGetArguments(pool, invocation, con.getParameterTypes());
            CtMethod copyTemplate = conInvocation.getDeclaredMethod("copy");
            CtMethod copy = CtNewMethod.make((CtClass)copyTemplate.getReturnType(), (String)"copy", (CtClass[])copyTemplate.getParameterTypes(), (CtClass[])copyTemplate.getExceptionTypes(), null, (CtClass)invocation);
            copy.setModifiers(copyTemplate.getModifiers());
            String copyCode = "{    " + invocation.getName() + " wrapper = new " + invocation.getName() + "(this.interceptors, this.info, this.callingMethodHash, this.callingClass, this.arguments, this.callingObject);" + "   wrapper.metadata = this.metadata; " + "   wrapper.currentInterceptor = this.currentInterceptor; " + "   wrapper.instanceResolver = this.instanceResolver; " + "   wrapper.targetObject = this.targetObject; " + "   wrapper.advisor = this.advisor; " + "   wrapper.responseContextInfo = this.responseContextInfo; ";
            for (int i = 0; i < params.length; ++i) {
                copyCode = copyCode + "   wrapper.arg" + i + " = this.arg" + i + "; ";
            }
            copyCode = copyCode + "   return wrapper; }";
            try {
                copy.setBody(copyCode);
            }
            catch (CannotCompileException e) {
                System.out.println(copyCode);
                throw e;
            }
            invocation.addMethod(copy);
            TransformerCommon.compileOrLoadClass(this.callingClass, invocation);
            return invocation.getName();
        }

        private String createOptimizedMethodCalledByConInvocationClass(CtMethod method, int callingIndex, long calledHash) throws Exception {
            AOPClassPool pool = (AOPClassPool)CallerTransformer.this.instrumentor.getClassPool();
            CtClass methodInvocation = pool.get("org.jboss.aop.joinpoint.MethodCalledByConstructorInvocation");
            String className = this.getOptimizedMethodCalledByConstructorClassName(callingIndex, this.callingClass.getName(), calledHash);
            boolean makeInnerClass = Modifier.isPrivate((int)method.getModifiers());
            CtClass invocation = TransformerCommon.makeInvocationClass(pool, makeInnerClass, this.callingClass, className, methodInvocation);
            CtClass[] params = method.getParameterTypes();
            TransformerCommon.addArgumentFieldsToInvocation(invocation, params);
            boolean isStatic = Modifier.isStatic((int)method.getModifiers());
            if (!isStatic) {
                CtField target = new CtField(method.getDeclaringClass(), "typedTargetObject", invocation);
                target.setModifiers(1);
                invocation.addField(target);
            }
            CtMethod in = methodInvocation.getDeclaredMethod("invokeNext");
            CtMethod invokeNext = CtNewMethod.make((CtClass)in.getReturnType(), (String)"invokeNext", (CtClass[])in.getParameterTypes(), (CtClass[])in.getExceptionTypes(), null, (CtClass)invocation);
            invokeNext.setModifiers(in.getModifiers());
            String code = "{    if (currentInterceptor < interceptors.length)    {       try         {          return interceptors[currentInterceptor++].invoke(this);       }        catch (Throwable t)        {           currentInterceptor--;           throw t;       }    } ";
            String returnStr = method.getReturnType().equals(CtClass.voidType) ? "" : "return ($w)";
            code = isStatic ? code + "   " + returnStr + " " + method.getDeclaringClass().getName() + "." : code + "   " + returnStr + " typedTargetObject.";
            code = code + method.getName() + "(";
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    code = code + ", ";
                }
                code = code + "arg" + i;
            }
            code = code + ");  ";
            if (method.getReturnType().equals(CtClass.voidType)) {
                code = code + " return null; ";
            }
            code = code + "}";
            try {
                invokeNext.setBody(code);
            }
            catch (CannotCompileException e) {
                System.out.println(code);
                throw e;
            }
            invocation.addMethod(invokeNext);
            TransformerCommon.addGetArguments(pool, invocation, method.getParameterTypes());
            CtMethod copyTemplate = methodInvocation.getDeclaredMethod("copy");
            CtMethod copy = CtNewMethod.make((CtClass)copyTemplate.getReturnType(), (String)"copy", (CtClass[])copyTemplate.getParameterTypes(), (CtClass[])copyTemplate.getExceptionTypes(), null, (CtClass)invocation);
            copy.setModifiers(copyTemplate.getModifiers());
            String copyCode = "{    " + invocation.getName() + " wrapper = new " + invocation.getName() + "(this.calledMethod, this.arguments, this.calling, this.interceptors);" + "   wrapper.metadata = this.metadata; " + "   wrapper.currentInterceptor = this.currentInterceptor; " + "   wrapper.instanceResolver = this.instanceResolver; " + "   wrapper.targetObject = this.targetObject; " + "   wrapper.advisor = this.advisor; " + "   wrapper.responseContextInfo = this.responseContextInfo; ";
            if (!isStatic) {
                copyCode = copyCode + "wrapper.typedTargetObject = typedTargetObject;";
            }
            for (int i = 0; i < params.length; ++i) {
                copyCode = copyCode + "   wrapper.arg" + i + " = this.arg" + i + "; ";
            }
            copyCode = copyCode + "   return wrapper; }";
            try {
                copy.setBody(copyCode);
            }
            catch (CannotCompileException e) {
                System.out.println(copyCode);
                throw e;
            }
            invocation.addMethod(copy);
            TransformerCommon.compileOrLoadClass(this.callingClass, invocation);
            return invocation.getName();
        }

        private String createOptimizedMethodCalledByMethodInvocationClass(CtMethod method, long callingHash, long calledHash) throws Exception {
            AOPClassPool pool = (AOPClassPool)CallerTransformer.this.instrumentor.getClassPool();
            CtClass methodInvocation = pool.get("org.jboss.aop.joinpoint.MethodCalledByMethodInvocation");
            String className = this.getOptimizedMethodCalledByMethodClassName(callingHash, this.callingClass.getName(), calledHash);
            boolean makeInnerClass = Modifier.isPrivate((int)method.getModifiers());
            CtClass invocation = TransformerCommon.makeInvocationClass(pool, makeInnerClass, this.callingClass, className, methodInvocation);
            CtClass[] params = method.getParameterTypes();
            TransformerCommon.addArgumentFieldsToInvocation(invocation, params);
            boolean isStatic = Modifier.isStatic((int)method.getModifiers());
            if (!isStatic) {
                CtField target = new CtField(method.getDeclaringClass(), "typedTargetObject", invocation);
                target.setModifiers(1);
                invocation.addField(target);
            }
            CtMethod in = methodInvocation.getDeclaredMethod("invokeNext");
            CtMethod invokeNext = CtNewMethod.make((CtClass)in.getReturnType(), (String)"invokeNext", (CtClass[])in.getParameterTypes(), (CtClass[])in.getExceptionTypes(), null, (CtClass)invocation);
            invokeNext.setModifiers(in.getModifiers());
            String code = "{    if (currentInterceptor < interceptors.length)    {       try         {          return interceptors[currentInterceptor++].invoke(this);       }        catch (Throwable t)        {           currentInterceptor--;           throw t;       }    } ";
            String returnStr = method.getReturnType().equals(CtClass.voidType) ? "" : "return ($w)";
            code = isStatic ? code + "   " + returnStr + " " + method.getDeclaringClass().getName() + "." : code + "   " + returnStr + " typedTargetObject.";
            code = code + method.getName() + "(";
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    code = code + ", ";
                }
                code = code + "arg" + i;
            }
            code = code + ");  ";
            if (method.getReturnType().equals(CtClass.voidType)) {
                code = code + " return null; ";
            }
            code = code + "}";
            try {
                invokeNext.setBody(code);
            }
            catch (CannotCompileException e) {
                System.out.println(code);
                throw e;
            }
            invocation.addMethod(invokeNext);
            TransformerCommon.addGetArguments(pool, invocation, method.getParameterTypes());
            CtMethod copyTemplate = methodInvocation.getDeclaredMethod("copy");
            CtMethod copy = CtNewMethod.make((CtClass)copyTemplate.getReturnType(), (String)"copy", (CtClass[])copyTemplate.getParameterTypes(), (CtClass[])copyTemplate.getExceptionTypes(), null, (CtClass)invocation);
            copy.setModifiers(copyTemplate.getModifiers());
            String copyCode = "{    " + invocation.getName() + " wrapper = new " + invocation.getName() + "(this.interceptors, this.calledMethod, this.arguments, this.callingClass, this.callingMethodHash, this.callingObject);" + "   wrapper.metadata = this.metadata; " + "   wrapper.currentInterceptor = this.currentInterceptor; " + "   wrapper.instanceResolver = this.instanceResolver; " + "   wrapper.targetObject = this.targetObject; " + "   wrapper.advisor = this.advisor; " + "   wrapper.callingMethod = this.callingMethod; " + "   wrapper.responseContextInfo = this.responseContextInfo; ";
            if (!isStatic) {
                copyCode = copyCode + "wrapper.typedTargetObject = typedTargetObject;";
            }
            for (int i = 0; i < params.length; ++i) {
                copyCode = copyCode + "   wrapper.arg" + i + " = this.arg" + i + "; ";
            }
            copyCode = copyCode + "   return wrapper; }";
            try {
                copy.setBody(copyCode);
            }
            catch (CannotCompileException e) {
                System.out.println(copyCode);
                throw e;
            }
            invocation.addMethod(copy);
            TransformerCommon.compileOrLoadClass(this.callingClass, invocation);
            return invocation.getName();
        }
    }
}

