/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

class Introspector {
    private static Vector attributes;
    private static Vector operations;
    private static String className;
    private static Class baseClass;
    private static final String attributeDescription = "Attribute exposed for management";
    private static final String operationDescription = "Operation exposed for management";
    private static final String constructorDescription = "Public constructor of the MBean";
    private static final String mbeanInfoDescription = "Information on the management interface of the MBean";

    static {
        className = null;
        baseClass = null;
    }

    Introspector() {
    }

    private static MBeanInfo constructResult() {
        Serializable serializable;
        int n;
        int n2 = 0;
        while (n2 < attributes.size()) {
            MBeanAttributeInfo mBeanAttributeInfo = (MBeanAttributeInfo)attributes.elementAt(n2);
            n = 0;
            while (n < attributes.size()) {
                serializable = (MBeanAttributeInfo)attributes.elementAt(n);
                if (serializable.getName().compareTo(mBeanAttributeInfo.getName()) == 0 && n2 != n) {
                    try {
                        attributes.setElementAt(new MBeanAttributeInfo(mBeanAttributeInfo.getName(), mBeanAttributeInfo.getType(), attributeDescription, true, true), n);
                    }
                    catch (Exception exception) {}
                    attributes.removeElementAt(n2);
                }
                ++n;
            }
            ++n2;
        }
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[attributes.size()];
        int n3 = 0;
        while (n3 < attributes.size()) {
            mBeanAttributeInfoArray[n3] = (MBeanAttributeInfo)attributes.elementAt(n3);
            ++n3;
        }
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[operations.size()];
        n = 0;
        while (n < operations.size()) {
            mBeanOperationInfoArray[n] = (MBeanOperationInfo)operations.elementAt(n);
            ++n;
        }
        MBeanConstructorInfo[] mBeanConstructorInfoArray = Introspector.getConstructors();
        serializable = new MBeanInfo(className, mbeanInfoDescription, mBeanAttributeInfoArray, mBeanConstructorInfoArray, mBeanOperationInfoArray, null);
        return serializable;
    }

    static MBeanConstructorInfo[] getConstructors() {
        Constructor<?>[] constructorArray = baseClass.getConstructors();
        Vector<MBeanConstructorInfo> vector = new Vector<MBeanConstructorInfo>();
        int n = 0;
        while (n < constructorArray.length) {
            Constructor<?> constructor = constructorArray[n];
            MBeanConstructorInfo mBeanConstructorInfo = null;
            try {
                mBeanConstructorInfo = new MBeanConstructorInfo(constructorDescription, constructor);
            }
            catch (Exception exception) {
                mBeanConstructorInfo = null;
            }
            if (mBeanConstructorInfo != null) {
                vector.addElement(mBeanConstructorInfo);
            }
            ++n;
        }
        MBeanConstructorInfo[] mBeanConstructorInfoArray = new MBeanConstructorInfo[vector.size()];
        int n2 = 0;
        while (n2 < mBeanConstructorInfoArray.length) {
            mBeanConstructorInfoArray[n2] = (MBeanConstructorInfo)vector.elementAt(n2);
            ++n2;
        }
        return mBeanConstructorInfoArray;
    }

    public static Class getMBeanInterface(Class clazz) {
        Class<?>[] classArray = null;
        Class clazz2 = clazz;
        boolean bl = false;
        Class clazz3 = null;
        Class clazz4 = null;
        Class clazz5 = null;
        boolean bl2 = false;
        while (clazz2 != null && !bl) {
            classArray = clazz2.getInterfaces();
            bl2 = false;
            int n = 0;
            while (n < classArray.length) {
                clazz3 = Introspector.implementsMBean(classArray[n], clazz2.getName());
                if (clazz3 != null) {
                    bl = true;
                    clazz4 = clazz3;
                    clazz5 = clazz2;
                }
                if (Introspector.isDynamic(classArray[n])) {
                    bl = true;
                    bl2 = true;
                }
                if (bl) break;
                ++n;
            }
            clazz2 = clazz2.getSuperclass();
        }
        return clazz4;
    }

    static Class implementsMBean(Class clazz, String string) {
        if (clazz.getName().compareTo(String.valueOf(string) + "MBean") == 0) {
            return clazz;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            if (classArray[n].getName().compareTo(String.valueOf(string) + "MBean") == 0) {
                return classArray[n];
            }
            ++n;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MBeanInfo introspect(Class clazz) throws NotCompliantMBeanException {
        attributes = new Vector();
        operations = new Vector();
        Method[] methodArray = null;
        methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            block30: {
                MBeanOperationInfo mBeanOperationInfo;
                int n2;
                Method method;
                block35: {
                    MBeanAttributeInfo mBeanAttributeInfo;
                    Class<?> clazz2;
                    String string;
                    block33: {
                        block29: {
                            block34: {
                                block32: {
                                    block31: {
                                        method = methodArray[n];
                                        if (method == null) break block30;
                                        string = method.getName();
                                        Class<?>[] classArray = method.getParameterTypes();
                                        clazz2 = method.getReturnType();
                                        n2 = classArray.length;
                                        mBeanAttributeInfo = null;
                                        mBeanOperationInfo = null;
                                        if (!string.equals("get") && !string.equals("is") && !string.equals("set")) break block31;
                                        try {
                                            mBeanOperationInfo = new MBeanOperationInfo(operationDescription, method);
                                        }
                                        catch (Exception exception) {
                                            exception.printStackTrace();
                                        }
                                        operations.addElement(mBeanOperationInfo);
                                        break block30;
                                    }
                                    if (string.startsWith("get") || string.startsWith("set") || string.startsWith("is")) break block32;
                                    try {
                                        mBeanOperationInfo = new MBeanOperationInfo(operationDescription, method);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                    operations.addElement(mBeanOperationInfo);
                                    break block30;
                                }
                                if (n2 != 0) break block33;
                                if (!string.startsWith("get")) break block34;
                                if (clazz2 == Void.TYPE) {
                                    try {
                                        mBeanOperationInfo = new MBeanOperationInfo(operationDescription, method);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                    operations.addElement(mBeanOperationInfo);
                                    break block30;
                                } else {
                                    try {
                                        mBeanAttributeInfo = new MBeanAttributeInfo(string.substring(3), attributeDescription, method, null);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                    if (Introspector.testConsistency(mBeanAttributeInfo)) {
                                        attributes.addElement(mBeanAttributeInfo);
                                    }
                                }
                                break block30;
                            }
                            try {
                                if (clazz2 != Class.forName("java.lang.Boolean") && clazz2 != Boolean.TYPE || !string.startsWith("is")) break block29;
                                try {
                                    mBeanAttributeInfo = new MBeanAttributeInfo(string.substring(2), attributeDescription, method, null);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                if (Introspector.testConsistency(mBeanAttributeInfo)) {
                                    attributes.addElement(mBeanAttributeInfo);
                                }
                                break block30;
                            }
                            catch (ClassNotFoundException classNotFoundException) {}
                        }
                        if (!string.startsWith("set")) break block33;
                        try {
                            mBeanOperationInfo = new MBeanOperationInfo(operationDescription, method);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        operations.addElement(mBeanOperationInfo);
                        break block30;
                    }
                    if (n2 != 1) break block35;
                    if (clazz2 == Void.TYPE && string.startsWith("set")) {
                        try {
                            mBeanAttributeInfo = new MBeanAttributeInfo(string.substring(3), attributeDescription, null, method);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (Introspector.testConsistency(mBeanAttributeInfo)) {
                            attributes.addElement(mBeanAttributeInfo);
                        }
                        break block30;
                    } else {
                        try {
                            mBeanOperationInfo = new MBeanOperationInfo(operationDescription, method);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        operations.addElement(mBeanOperationInfo);
                    }
                    break block30;
                }
                if (n2 > 1) {
                    try {
                        mBeanOperationInfo = new MBeanOperationInfo(operationDescription, method);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    operations.addElement(mBeanOperationInfo);
                }
            }
            ++n;
        }
        return Introspector.constructResult();
    }

    static boolean isDynamic(Class clazz) {
        if (clazz.getName().compareTo("javax.management.DynamicMBean") == 0) {
            return true;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            if (classArray[n].getName().compareTo("javax.management.DynamicMBean") == 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static MBeanInfo testCompliance(Class clazz) throws NotCompliantMBeanException {
        baseClass = clazz;
        className = clazz.getName();
        int n = clazz.getModifiers();
        if (Modifier.isAbstract(n)) {
            throw new NotCompliantMBeanException("The MBean must be have a concrete class");
        }
        Constructor<?>[] constructorArray = clazz.getConstructors();
        if (constructorArray.length == 0) {
            throw new NotCompliantMBeanException("The MBean does not have a public constructor");
        }
        Class<?>[] classArray = null;
        Class clazz2 = clazz;
        boolean bl = false;
        Class clazz3 = null;
        Class clazz4 = null;
        Class clazz5 = null;
        boolean bl2 = false;
        while (clazz2 != null && !bl) {
            classArray = clazz2.getInterfaces();
            bl2 = false;
            int n2 = 0;
            while (n2 < classArray.length) {
                clazz3 = Introspector.implementsMBean(classArray[n2], clazz2.getName());
                if (clazz3 != null) {
                    bl = true;
                    clazz4 = clazz3;
                    clazz5 = clazz2;
                }
                if (Introspector.isDynamic(classArray[n2])) {
                    bl = true;
                    bl2 = true;
                }
                if (clazz4 != null && clazz2.equals(clazz5) && bl2) {
                    throw new NotCompliantMBeanException(String.valueOf(clazz.getName()) + " implements javax.management.DynamicMBean and MBean interface");
                }
                ++n2;
            }
            if (bl) break;
            clazz2 = clazz2.getSuperclass();
        }
        if (!bl) {
            throw new NotCompliantMBeanException(String.valueOf(clazz.getName()) + " does not implement the " + clazz.getName() + "MBean interface or the DynamicMBean interface");
        }
        if (clazz4 != null) {
            return Introspector.introspect(clazz4);
        }
        return null;
    }

    private static boolean testConsistency(MBeanAttributeInfo mBeanAttributeInfo) throws NotCompliantMBeanException {
        int n = 0;
        while (n < attributes.size()) {
            if (((MBeanAttributeInfo)attributes.elementAt(n)).getName().compareTo(mBeanAttributeInfo.getName()) == 0) {
                MBeanAttributeInfo mBeanAttributeInfo2 = (MBeanAttributeInfo)attributes.elementAt(n);
                if (mBeanAttributeInfo.isReadable() && mBeanAttributeInfo2.isReadable() && (mBeanAttributeInfo.isIs() || mBeanAttributeInfo2.isIs())) {
                    throw new NotCompliantMBeanException("Getter is" + mBeanAttributeInfo2.getName() + " cannot co-exist with getter get" + mBeanAttributeInfo.getName());
                }
                if (mBeanAttributeInfo2.getType().compareTo(mBeanAttributeInfo.getType()) != 0) {
                    if (mBeanAttributeInfo2.isWritable() && mBeanAttributeInfo.isWritable()) {
                        throw new NotCompliantMBeanException("Type mismatch between parameters of set" + mBeanAttributeInfo2.getName() + " methods");
                    }
                    throw new NotCompliantMBeanException("Type mismatch between parameters of get or is" + mBeanAttributeInfo2.getName() + ", set" + mBeanAttributeInfo2.getName() + " methods");
                }
                if (mBeanAttributeInfo.isReadable() && mBeanAttributeInfo2.isReadable()) {
                    return false;
                }
                if (mBeanAttributeInfo.isWritable() && mBeanAttributeInfo2.isWritable()) {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }
}

