/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.server;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.management.MBeanServer;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;
import org.jboss.axis.AxisFault;
import org.jboss.axis.Handler;
import org.jboss.axis.MessageContext;
import org.jboss.axis.handlers.soap.SOAPService;
import org.jboss.axis.message.SOAPEnvelopeAxisImpl;
import org.jboss.axis.providers.java.RPCInvocation;
import org.jboss.axis.providers.java.RPCProvider;
import org.jboss.axis.transport.http.HTTPConstants;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.webservice.AxisServiceMBean;
import org.jboss.webservice.PortComponentInfo;
import org.jboss.webservice.handler.ServerHandlerChain;
import org.jboss.webservice.metadata.HandlerMetaData;
import org.jboss.webservice.metadata.InitParamMetaData;
import org.jboss.webservice.metadata.WebserviceDescriptionMetaData;
import org.jboss.webservice.server.JBossRPCInvocation;
import org.jboss.webservice.server.ServiceException;
import org.jboss.webservice.server.WSDLRequestHandler;
import org.w3c.dom.Document;

public abstract class InvokerProvider
extends RPCProvider {
    static final long serialVersionUID = 3036485550614460123L;
    private Logger log = Logger.getLogger((Class)InvokerProvider.class);
    protected MBeanServer server;
    protected PortComponentInfo portComponentInfo;
    protected ServerHandlerChain handlerChain;

    public void initServiceDesc(SOAPService service, MessageContext msgContext) throws AxisFault {
        this.log.debug((Object)("initServiceDesc: service=" + service.getName()));
        try {
            this.server = MBeanServerLocator.locateJBoss();
            String wsID = (String)service.getOption("webserviceID");
            this.portComponentInfo = (PortComponentInfo)this.server.invoke(AxisServiceMBean.OBJECT_NAME, "getPortComponentInfo", new Object[]{wsID}, new String[]{String.class.getName()});
            if (this.portComponentInfo == null) {
                throw new ServiceException("Cannot obtain port component info for: " + wsID);
            }
            this.initHandlerChain();
        }
        catch (Exception e) {
            throw new ServiceException("Cannot initialize webservice", e);
        }
        super.initServiceDesc(service, msgContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initHandlerChain() throws Exception {
        ClassLoader cl = this.getContextClassLoader();
        HashSet<String> handlerRoles = new HashSet<String>();
        ArrayList<HandlerInfo> handlerInfos = new ArrayList<HandlerInfo>();
        HandlerMetaData[] handlers = this.portComponentInfo.getPortComponentMetaData().getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            HandlerMetaData hMetaData = handlers[i];
            handlerRoles.addAll(Arrays.asList(hMetaData.getSoapRoles()));
            Class<?> hClass = cl.loadClass(hMetaData.getHandlerClass());
            HashMap<String, String> hConfig = new HashMap<String, String>();
            InitParamMetaData[] params = hMetaData.getInitParams();
            for (int j = 0; j < params.length; ++j) {
                InitParamMetaData param = params[j];
                hConfig.put(param.getParamName(), param.getParamValue());
            }
            QName[] hHeaders = hMetaData.getSoapHeaders();
            HandlerInfo info = new HandlerInfo(hClass, hConfig, hHeaders);
            String serviceName = this.portComponentInfo.getPortComponentMetaData().getPortComponentName();
            this.log.debug((Object)("Adding server side handler to service '" + serviceName + "': " + info));
            handlerInfos.add(info);
        }
        this.handlerChain = new ServerHandlerChain(handlerInfos, handlerRoles);
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getContextClassLoader());
            if (this.handlerChain.getState() == 1) {
                this.handlerChain.init(null);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    protected abstract ClassLoader getContextClassLoader();

    public void generateWSDL(MessageContext msgContext) throws AxisFault {
        HttpServletRequest req = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (req == null) {
            throw new IllegalStateException("Cannot obtain HttpServletRequest from msg context");
        }
        try {
            String resourcePath = (String)msgContext.getProperty("axis.wsdlgen.resource");
            String requestURI = req.getRequestURI();
            WebserviceDescriptionMetaData webserviceDescription = this.portComponentInfo.getPortComponentMetaData().getWebserviceDescription();
            DeploymentInfo di = this.portComponentInfo.getDeploymentInfo();
            WSDLRequestHandler wsdlRequestHandler = new WSDLRequestHandler(webserviceDescription, di);
            Document document = wsdlRequestHandler.getDocumentForPath(requestURI, resourcePath);
            msgContext.setProperty("WSDL", (Object)document);
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot process WSDL document", (Throwable)e);
        }
    }

    public RPCInvocation createRPCInvocation(MessageContext msgContext, SOAPEnvelopeAxisImpl reqEnv, SOAPEnvelopeAxisImpl resEnv, Object obj) {
        JBossRPCInvocation invocation = new JBossRPCInvocation(this, msgContext, reqEnv, resEnv, obj);
        return invocation;
    }

    public PortComponentInfo getPortComponentInfo() {
        return this.portComponentInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class getServiceClass(String clsName, SOAPService service, MessageContext msgContext) throws AxisFault {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getContextClassLoader());
            String seiName = this.portComponentInfo.getPortComponentMetaData().getServiceEndpointInterface();
            Class clazz = super.getServiceClass(seiName, service, msgContext);
            return clazz;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    protected String getServiceClassName(Handler handler) {
        return this.portComponentInfo.getPortComponentMetaData().getServiceEndpointInterface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object invokeMethod(MessageContext msgContext, Method method, Object obj, Object[] argValues) throws Exception {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getContextClassLoader());
            Object object = this.invokeServiceEndpoint(msgContext, method, obj, argValues);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    protected abstract Object invokeServiceEndpoint(MessageContext var1, Method var2, Object var3, Object[] var4) throws Exception;
}

