/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.server;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.axis.AxisFault;
import org.jboss.axis.ConfigurationException;
import org.jboss.axis.MessageContext;
import org.jboss.axis.description.OperationDesc;
import org.jboss.axis.description.ServiceDesc;
import org.jboss.axis.server.AxisServer;
import org.jboss.axis.transport.http.AxisServlet;
import org.jboss.axis.utils.XMLUtils;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanProxyCreationException;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.webservice.AxisServiceMBean;
import org.jboss.webservice.PortComponentInfo;
import org.w3c.dom.Document;

public abstract class AbstractServlet
extends AxisServlet {
    protected final Logger log = Logger.getLogger((Class)AbstractServlet.class);

    protected String getTransportURL(HttpServletRequest req, String serviceName) {
        return req.getRequestURI();
    }

    protected void setupHTMLResponseHeader(HttpServletResponse res, PrintWriter writer) {
        writer.println("<head>");
        writer.println("<meta http-equiv='Content-Type content='text/html; charset=iso-8859-1'>");
        writer.println("<title>JBossWS</title>");
        writer.println("<link rel='stylesheet' href='/ws4ee/styles.css'>");
        writer.println("</head>");
    }

    protected void reportAvailableServices(HttpServletResponse res, PrintWriter writer, HttpServletRequest req) throws ConfigurationException, AxisFault {
        AxisServer engine = this.getEngine();
        res.setContentType("text/html");
        this.setupHTMLResponseHeader(res, writer);
        writer.println("<h2>And now... Some Services</h2>");
        writer.println("<ul>");
        AxisServiceMBean axisService = null;
        try {
            MBeanServer server = MBeanServerLocator.locateJBoss();
            axisService = (AxisServiceMBean)MBeanProxy.get((Class)AxisServiceMBean.class, (ObjectName)AxisServiceMBean.OBJECT_NAME, (MBeanServer)server);
        }
        catch (MBeanProxyCreationException e) {
            throw new IllegalStateException("Cannot obtain: " + AxisServiceMBean.OBJECT_NAME);
        }
        Iterator it = engine.getConfig().getDeployedServices();
        while (it.hasNext()) {
            ServiceDesc sd = (ServiceDesc)it.next();
            String serviceName = sd.getName();
            PortComponentInfo pcInfo = axisService.getPortComponentInfo(serviceName);
            String serviceURL = null;
            serviceURL = pcInfo != null ? pcInfo.getServiceEndpointURL() : this.getWebappBase(req) + "/services/" + serviceName;
            StringBuffer sb = new StringBuffer("<li>" + serviceName + "<a href='" + serviceURL + "?wsdl'>&nbsp;<i>(wsdl)</i></a></li>");
            ArrayList operations = sd.getOperations();
            if (!operations.isEmpty()) {
                sb.append("<ul>");
                Iterator itOp = operations.iterator();
                while (itOp.hasNext()) {
                    OperationDesc desc = (OperationDesc)itOp.next();
                    sb.append("<li>" + desc.getName() + "</li>");
                }
                sb.append("</ul>");
            }
            writer.println(sb.toString());
        }
        writer.println("</ul>");
    }

    protected void processWsdlRequest(MessageContext msgContext, HttpServletResponse res, PrintWriter writer) throws AxisFault {
        String serviceURL = (String)msgContext.getProperty("transport.url");
        AxisServer engine = this.getEngine();
        engine.generateWSDL(msgContext);
        Document doc = (Document)msgContext.getProperty("WSDL");
        if (doc == null) {
            throw new AxisFault("Cannot get wsdl document for service: " + serviceURL);
        }
        res.setContentType("text/xml");
        XMLUtils.DocumentToWriter((Document)doc, (Writer)writer);
    }

    public AxisServer getEngine() throws AxisFault {
        try {
            MBeanServer server = MBeanServerLocator.locateJBoss();
            this.axisServer = (AxisServer)server.getAttribute(AxisServiceMBean.OBJECT_NAME, "AxisServer");
        }
        catch (Exception e) {
            this.log.warn((Object)"Cannot access AxisService, using default server config");
            this.axisServer = super.getEngine();
        }
        return this.axisServer;
    }
}

