/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.deployment;

import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Calendar;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import org.jboss.axis.encoding.ser.ArrayDeserializerFactory;
import org.jboss.axis.encoding.ser.ArraySerializerFactory;
import org.jboss.axis.encoding.ser.BeanDeserializerFactory;
import org.jboss.axis.encoding.ser.BeanSerializerFactory;
import org.jboss.axis.encoding.ser.CalendarDeserializerFactory;
import org.jboss.axis.encoding.ser.CalendarSerializerFactory;
import org.jboss.axis.encoding.ser.EnumDeserializerFactory;
import org.jboss.axis.encoding.ser.EnumSerializerFactory;
import org.jboss.axis.encoding.ser.QNameDeserializerFactory;
import org.jboss.axis.encoding.ser.QNameSerializerFactory;
import org.jboss.axis.encoding.ser.SimpleDeserializerFactory;
import org.jboss.axis.encoding.ser.SimpleSerializerFactory;
import org.jboss.axis.enums.Enum;
import org.jboss.axis.enums.Use;
import org.jboss.axis.utils.DOM2Utils;
import org.jboss.axis.utils.JavaUtils;
import org.jboss.logging.Logger;
import org.jboss.util.Classes;
import org.jboss.webservice.deployment.BeanXMLMetaData;
import org.jboss.webservice.deployment.WSDDGenerator;
import org.jboss.webservice.encoding.ser.MetaDataBeanDeserializerFactory;
import org.jboss.webservice.encoding.ser.MetaDataBeanSerializerFactory;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaXmlTypeMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.VariableMapping;
import org.jboss.webservice.util.DOMUtils;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class TypeMappingDescription {
    private final Logger log = Logger.getLogger((Class)TypeMappingDescription.class);
    private QName typeQName;
    private QName anonymousQName;
    private String javaType;
    private String serFactoryName;
    private String desFactoryName;
    private String encodingURI;
    private BeanXMLMetaData metaData;
    private boolean userDefined;

    public TypeMappingDescription(QName qname, QName anonymousQName, String javaType, Use use, JavaXmlTypeMapping jaxrpcTypeMapping) {
        if (qname == null) {
            throw new IllegalArgumentException("TypeMapping qname cannot be null");
        }
        if (javaType == null) {
            throw new IllegalArgumentException("TypeMapping javaType cannot be null");
        }
        if (use == null) {
            throw new IllegalArgumentException("TypeMapping use cannot be null");
        }
        this.javaType = javaType;
        this.typeQName = qname;
        this.anonymousQName = anonymousQName;
        if (jaxrpcTypeMapping != null) {
            this.initMetaDataFromJavaXMLTypeMapping(qname, jaxrpcTypeMapping);
        }
        if (Use.LITERAL.equals((Enum)use)) {
            this.encodingURI = "";
        } else if (Use.ENCODED.equals((Enum)use)) {
            this.encodingURI = "http://schemas.xmlsoap.org/soap/encoding/";
        } else {
            throw new IllegalArgumentException("Unsupported use: " + use);
        }
    }

    private void initMetaDataFromJavaXMLTypeMapping(QName qname, JavaXmlTypeMapping jaxrpcTypeMapping) {
        if (jaxrpcTypeMapping.getVariableMappings().length > 0) {
            VariableMapping varMapping;
            int i;
            String xmlns = "xmlns:" + qname.getPrefix() + "='" + qname.getNamespaceURI() + "'";
            StringBuffer buffer = new StringBuffer("<typeMapping " + xmlns + "><typeDesc>");
            VariableMapping[] varMappings = jaxrpcTypeMapping.getVariableMappings();
            for (i = 0; i < varMappings.length; ++i) {
                varMapping = varMappings[i];
                String fieldName = varMapping.getJavaVariableName();
                String xmlName = varMapping.getXmlElementName();
                if (xmlName == null) {
                    xmlName = varMapping.getXmlAttributeName();
                }
                if (xmlName == null) {
                    xmlName = varMapping.getXmlWildcard();
                }
                boolean isAttribute = varMapping.getXmlAttributeName() != null;
                String asAttr = isAttribute ? "asAttr='true' " : " ";
                buffer.append("<elementDesc fieldName='" + fieldName + "' xmlName='" + xmlName + "' " + asAttr + "/>");
            }
            buffer.append("<elementOrder>");
            for (i = 0; i < varMappings.length; ++i) {
                varMapping = varMappings[i];
                if (varMapping.getXmlElementName() == null) continue;
                buffer.append("<element name='" + varMapping.getJavaVariableName() + "'/>");
            }
            buffer.append("</elementOrder></typeDesc></typeMapping>");
            try {
                DocumentBuilder builder = DOM2Utils.getDocumentBuilder();
                Element root = builder.parse(new InputSource(new StringReader(buffer.toString()))).getDocumentElement();
                this.metaData = BeanXMLMetaData.parse(DOMUtils.getFirstChildElement(root));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot construct meta data from: " + buffer);
            }
        }
    }

    public Class loadJavaType(ClassLoader cl) {
        Class<?> typeClass = null;
        String componentType = null;
        try {
            boolean isArrayType = this.javaType.endsWith("[]");
            componentType = isArrayType ? this.javaType.substring(0, this.javaType.indexOf("[")) : this.javaType;
            if (isArrayType) {
                if (JavaUtils.isJavaKeyword((String)componentType)) {
                    String className = JavaUtils.getLoadableClassName((String)this.javaType);
                    typeClass = ClassLoader.getSystemClassLoader().loadClass(className);
                } else {
                    Class.forName(componentType, true, cl);
                    String className = JavaUtils.getLoadableClassName((String)this.javaType);
                    typeClass = Class.forName(className, true, cl);
                }
            }
            if (!isArrayType) {
                typeClass = JavaUtils.isJavaKeyword((String)this.javaType) ? this.getPrimitiveClass(this.javaType) : cl.loadClass(this.javaType);
            }
            this.initSerializerForClass(typeClass);
        }
        catch (ClassNotFoundException ignore) {
            this.log.warn((Object)("Class not found: " + this.javaType));
        }
        catch (NoClassDefFoundError ignore) {
            this.log.warn((Object)("No class definition for " + this.javaType));
        }
        return typeClass;
    }

    private Class getPrimitiveClass(String javaType) {
        if ("int".equals(javaType)) {
            return Integer.TYPE;
        }
        if ("short".equals(javaType)) {
            return Short.TYPE;
        }
        if ("boolean".equals(javaType)) {
            return Boolean.TYPE;
        }
        if ("byte".equals(javaType)) {
            return Byte.TYPE;
        }
        if ("long".equals(javaType)) {
            return Long.TYPE;
        }
        if ("double".equals(javaType)) {
            return Double.TYPE;
        }
        if ("float".equals(javaType)) {
            return Float.TYPE;
        }
        if ("char".equals(javaType)) {
            return Character.TYPE;
        }
        return null;
    }

    private void initSerializerForClass(Class typeClass) {
        boolean isSimpleType;
        boolean isEncoded = "http://schemas.xmlsoap.org/soap/encoding/".equals(this.encodingURI);
        boolean bl = isSimpleType = typeClass == null || Classes.isPrimitive((Class)typeClass) || typeClass.getName().startsWith("java.lang") || typeClass.getName().startsWith("java.math");
        if (this.getSerializerFactoryName() == null) {
            String serFactory = null;
            if (isSimpleType) {
                serFactory = SimpleSerializerFactory.class.getName();
            } else if (JavaUtils.isArrayClass((Class)typeClass)) {
                if (isEncoded) {
                    serFactory = ArraySerializerFactory.class.getName();
                }
            } else {
                serFactory = JavaUtils.isEnumClass((Class)typeClass) ? EnumSerializerFactory.class.getName() : (QName.class.isAssignableFrom(typeClass) ? QNameSerializerFactory.class.getName() : (Calendar.class.isAssignableFrom(typeClass) ? CalendarSerializerFactory.class.getName() : (this.metaData != null ? MetaDataBeanSerializerFactory.class.getName() : BeanSerializerFactory.class.getName())));
            }
            this.setSerializerFactoryName(serFactory);
        }
        if (this.getDeserializerFactoryName() == null) {
            String desFactory = null;
            if (isSimpleType) {
                desFactory = SimpleDeserializerFactory.class.getName();
            } else if (JavaUtils.isEnumClass((Class)typeClass)) {
                desFactory = EnumDeserializerFactory.class.getName();
            } else if (JavaUtils.isArrayClass((Class)typeClass)) {
                if (isEncoded) {
                    desFactory = ArrayDeserializerFactory.class.getName();
                }
            } else {
                desFactory = QName.class.isAssignableFrom(typeClass) ? QNameDeserializerFactory.class.getName() : (Calendar.class.isAssignableFrom(typeClass) ? CalendarDeserializerFactory.class.getName() : (this.metaData != null ? MetaDataBeanDeserializerFactory.class.getName() : BeanDeserializerFactory.class.getName()));
            }
            this.setDeserializerFactoryName(desFactory);
        }
    }

    public String getJavaType() {
        return this.javaType;
    }

    public QName getTypeQName() {
        return this.typeQName;
    }

    public QName getAnonymousQName() {
        return this.anonymousQName;
    }

    public String getDeserializerFactoryName() {
        return this.desFactoryName;
    }

    public String getSerializerFactoryName() {
        return this.serFactoryName;
    }

    public String getEncodingURI() {
        return this.encodingURI;
    }

    public void setEncodingURI(String encodingURI) {
        this.encodingURI = encodingURI;
    }

    public void setTypeQName(QName typeQName) {
        this.typeQName = typeQName;
    }

    public void setSerializerFactoryName(String serFactoryName) {
        this.serFactoryName = serFactoryName;
    }

    public void setDeserializerFactoryName(String desFactoryName) {
        this.desFactoryName = desFactoryName;
    }

    public BeanXMLMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(BeanXMLMetaData metaData) {
        this.metaData = metaData;
    }

    public boolean isUserDefined() {
        return this.userDefined;
    }

    public void setUserDefined(boolean userDefined) {
        this.userDefined = userDefined;
    }

    public void writeWSDD(PrintWriter out) {
        String javaType = this.getJavaType();
        QName typeQName = this.getTypeQName();
        String encodingURI = this.getEncodingURI();
        this.log.trace((Object)("TypeMapping: " + this));
        String typeAttr = WSDDGenerator.getQNameAttrValue(typeQName);
        String typePrefix = typeQName.getPrefix();
        String xmlns = "xmlns:" + typePrefix + "='" + typeQName.getNamespaceURI() + "'";
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class typeClass = this.loadJavaType(cl);
        String serializer = this.getSerializerFactoryName();
        String deserializer = this.getDeserializerFactoryName();
        if (this.isUserDefined()) {
            out.println("  <!-- User defined type mapping -->");
        }
        if (typeClass == null) {
            out.println("  <!-- Class not found, ignore type mapping");
        } else if (serializer == null || deserializer == null) {
            out.println("  <!-- Serializer/Deserializer not found, ignore type mapping");
        }
        out.println("  <typeMapping");
        out.println("    qname='" + typeAttr + "' " + xmlns);
        out.println("    type='java:" + javaType + "'");
        out.println("    serializer='" + serializer + "'");
        out.println("    deserializer='" + deserializer + "'");
        out.println("    encodingStyle='" + encodingURI + "'>");
        if (this.metaData != null) {
            this.metaData.serializeAsXML(out);
        }
        out.println("  </typeMapping>");
        if (typeClass == null || serializer == null || deserializer == null) {
            out.println("  -->");
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "[type=" + this.typeQName + ",anonymous=" + this.anonymousQName + ",java=" + this.javaType + ",serf=" + this.serFactoryName + ",desf=" + this.desFactoryName + ",encoding=" + this.encodingURI + "]";
    }
}

