/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.management.ObjectName;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.logging.Logger;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.webservice.PortComponentInfo;
import org.jboss.webservice.ServiceDeployer;
import org.jboss.webservice.ServiceDeployerJSEMBean;
import org.jboss.webservice.metadata.PortComponentMetaData;
import org.jboss.webservice.metadata.WebserviceDescriptionMetaData;
import org.jboss.webservice.metadata.WebservicesMetaData;
import org.jboss.webservice.server.ServiceEndpointServletJSE;
import org.xml.sax.EntityResolver;

public class ServiceDeployerJSE
extends ServiceDeployer
implements ServiceDeployerJSEMBean {
    private final Logger log = Logger.getLogger((Class)ServiceDeployer.class);
    private ObjectName warDeployer;

    public void setWARDeployer(ObjectName deployerName) {
        this.warDeployer = deployerName;
    }

    protected void startService() throws Exception {
        super.startService();
        this.registerNotificationListener(this.warDeployer);
    }

    protected void stopService() throws Exception {
        this.unregisterNotificationListener(this.warDeployer);
        super.stopService();
    }

    protected URL getWebservicesDescriptor(DeploymentInfo di) {
        return di.localCl.findResource("WEB-INF/webservices.xml");
    }

    protected void createWebservice(DeploymentInfo di) throws DeploymentException {
        super.createWebservice(di);
        WebservicesMetaData webservices = (WebservicesMetaData)this.webservicesMap.get(di.url);
        this.modifyWebXML(di, webservices);
    }

    private void modifyWebXML(DeploymentInfo di, WebservicesMetaData webservices) throws DeploymentException {
        if (webservices == null) {
            throw new DeploymentException("webservices.xml not registerd");
        }
        File warFile = new File(di.localUrl.getFile());
        if (!warFile.isDirectory()) {
            throw new DeploymentException("Expected a war directory: " + di.localUrl);
        }
        File webXML = new File(di.localUrl.getFile() + "/WEB-INF/web.xml");
        if (!webXML.isFile()) {
            throw new DeploymentException("Cannot find web.xml: " + webXML);
        }
        FileOutputStream fos = null;
        try {
            SAXReader saxReader = new SAXReader();
            saxReader.setEntityResolver((EntityResolver)new JBossEntityResolver());
            Document doc = saxReader.read(webXML);
            if (this.modifyWebXMLDocument(doc, di, webservices)) {
                File orgWebXML = new File(webXML.getCanonicalPath() + ".org");
                orgWebXML.delete();
                if (!webXML.renameTo(orgWebXML)) {
                    throw new DeploymentException("Cannot rename web.xml: " + orgWebXML);
                }
                OutputFormat format = OutputFormat.createPrettyPrint();
                fos = new FileOutputStream(webXML);
                XMLWriter writer = new XMLWriter((OutputStream)fos, format);
                writer.write(doc);
            }
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    this.log.warn((Object)"Unexpected IOException on file close", (Throwable)e);
                }
            }
        }
    }

    private boolean modifyWebXMLDocument(Document doc, DeploymentInfo di, WebservicesMetaData webservices) throws DeploymentException {
        boolean modified = false;
        WebserviceDescriptionMetaData[] wsDescriptions = webservices.getWebserviceDescriptions();
        for (int i = 0; i < wsDescriptions.length; ++i) {
            WebserviceDescriptionMetaData wsDescription = wsDescriptions[i];
            PortComponentMetaData[] portComponents = wsDescription.getPortComponents();
            for (int j = 0; j < portComponents.length; ++j) {
                PortComponentMetaData pcMetaData = portComponents[j];
                PortComponentInfo pcInfo = new PortComponentInfo(di, pcMetaData);
                String servletLink = pcMetaData.getServletLink();
                if (servletLink == null) {
                    throw new DeploymentException("Cannot find servlet-link in port-component: " + pcMetaData.getPortComponentName());
                }
                if (!this.modifyServletConfig(doc, servletLink, pcInfo)) continue;
                modified = true;
            }
        }
        return modified;
    }

    protected String getServiceEndpointServletName() {
        return ServiceEndpointServletJSE.class.getName();
    }
}

