/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.spi;

import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.deployment.SerializableDeploymentInfo;
import org.jboss.deployment.spi.JBossTarget;
import org.jboss.deployment.spi.TargetModuleIDImpl;
import org.jboss.logging.Logger;

public class JMXTarget
implements JBossTarget {
    private static final Logger log = Logger.getLogger((Class)JMXTarget.class);
    private static final String DEFAULT_ADAPTOR_PATH = "/jmx/invoker/RMIAdaptor";
    private static final String MAIN_DEPLOYER = "jboss.system:service=MainDeployer";
    private URI deployURI;
    private Properties jndiEnv;

    public JMXTarget(URI deployURI) {
        log.debug((Object)("new JMXTarget: " + deployURI));
        try {
            String scheme = deployURI.getScheme();
            String host = deployURI.getHost();
            int port = deployURI.getPort();
            String path = deployURI.getPath();
            String query = deployURI.getQuery();
            StringBuffer uri = new StringBuffer(scheme + "://");
            uri.append(host != null ? host : InetAddress.getLocalHost().getHostName());
            uri.append(port > 0 ? ":" + port : "");
            uri.append(path != null && path.length() > 0 ? path : DEFAULT_ADAPTOR_PATH);
            uri.append(query != null ? "?" + query : "");
            deployURI = new URI(uri.toString());
            log.debug((Object)("URI changed to: " + deployURI));
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        this.deployURI = deployURI;
    }

    public String getDescription() {
        return "JBoss JMX deployment target";
    }

    public String getName() {
        return this.deployURI.toString();
    }

    public String getHostName() {
        return this.deployURI.getHost();
    }

    public void deploy(TargetModuleID targetModuleID) throws Exception {
        MBeanServerConnection server = this.getMBeanServerConnection();
        ObjectName mainDeployer = new ObjectName(MAIN_DEPLOYER);
        String url = targetModuleID.getModuleID();
        Object[] args = new Object[]{url};
        String[] sig = new String[]{String.class.getName()};
        log.info((Object)("Starting deploy of: " + url));
        server.invoke(mainDeployer, "deploy", args, sig);
    }

    public void start(TargetModuleID targetModuleID) throws Exception {
    }

    public void stop(TargetModuleID targetModuleID) throws Exception {
    }

    public void undeploy(TargetModuleID targetModuleID) throws Exception {
        MBeanServerConnection server = this.getMBeanServerConnection();
        ObjectName mainDeployer = new ObjectName(MAIN_DEPLOYER);
        String url = targetModuleID.getModuleID();
        Object[] args = new Object[]{url};
        String[] sig = new String[]{String.class.getName()};
        log.debug((Object)("Starting undeploy of: " + url));
        server.invoke(mainDeployer, "undeploy", args, sig);
    }

    public TargetModuleID[] getAvailableModules(ModuleType moduleType) throws TargetException {
        try {
            ArrayList<TargetModuleIDImpl> list = new ArrayList<TargetModuleIDImpl>();
            MBeanServerConnection server = this.getMBeanServerConnection();
            ObjectName mainDeployer = new ObjectName(MAIN_DEPLOYER);
            Collection col = (Collection)server.invoke(mainDeployer, "listDeployedModules", new Object[0], new String[0]);
            Iterator it = col.iterator();
            while (it.hasNext()) {
                SerializableDeploymentInfo info = (SerializableDeploymentInfo)it.next();
                if (info.parent != null) continue;
                String module = info.url.toString();
                TargetModuleIDImpl tmid = new TargetModuleIDImpl(this, module, null, false);
                list.add(tmid);
            }
            TargetModuleID[] targetModuleIDs = new TargetModuleID[list.size()];
            list.toArray(targetModuleIDs);
            return targetModuleIDs;
        }
        catch (Exception e) {
            log.error((Object)"Cannot get available modules", (Throwable)e);
            TargetException tex = new TargetException("");
            tex.initCause((Throwable)e);
            throw tex;
        }
    }

    private MBeanServerConnection getMBeanServerConnection() throws NamingException {
        Properties env = this.buildJNDIEnv();
        String lookupPath = this.deployURI.getPath();
        log.debug((Object)("JNDI lookup: " + lookupPath));
        log.trace((Object)("Creating InitialContext with env: " + env));
        InitialContext ctx = new InitialContext(env);
        MBeanServerConnection server = (MBeanServerConnection)ctx.lookup(lookupPath);
        return server;
    }

    private Properties buildJNDIEnv() {
        if (this.jndiEnv == null) {
            this.jndiEnv = new Properties();
            String query = this.deployURI.getQuery();
            if (query != null) {
                log.debug((Object)("Parsing query string: " + query));
                StringTokenizer tokenizer = new StringTokenizer(query, "=&");
                while (tokenizer.hasMoreTokens()) {
                    String name = tokenizer.nextToken();
                    String value = tokenizer.nextToken();
                    this.jndiEnv.setProperty(name, value);
                }
            }
            if (this.jndiEnv.getProperty("java.naming.factory.initial") == null) {
                this.jndiEnv.setProperty("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            }
            if (this.jndiEnv.getProperty("java.naming.provider.url") == null) {
                String host = this.deployURI.getHost();
                int port = this.deployURI.getPort();
                if (port <= 0) {
                    port = 1099;
                }
                String jnpURL = "jnp://" + host + ':' + port;
                this.jndiEnv.setProperty("java.naming.provider.url", jnpURL);
            }
            if (this.jndiEnv.getProperty("java.naming.factory.object") == null) {
                this.jndiEnv.setProperty("java.naming.factory.object", "org.jboss.naming");
            }
        }
        return this.jndiEnv;
    }
}

