/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import org.apache.batik.bridge.NoRepaintRunnable;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.util.RunnableQueue;

public class RepaintRateManager
extends Thread {
    protected UpdateManager updateManager;
    protected long targetFrameTime = 50L;

    public RepaintRateManager(UpdateManager um) {
        this.updateManager = um;
        this.setDaemon(true);
    }

    public void run() {
        NoRepaintRunnable repaintRunnable = new NoRepaintRunnable(){

            public void run() {
                RepaintRateManager.this.updateManager.repaint();
            }
        };
        RunnableQueue rq = this.updateManager.getUpdateRunnableQueue();
        try {
            while (!Thread.currentThread().isInterrupted()) {
                long lastFrameTime = System.currentTimeMillis();
                rq.invokeAndWait(repaintRunnable);
                long currentTime = System.currentTimeMillis();
                long tm = currentTime - lastFrameTime;
                long sleepTime = this.targetFrameTime - tm;
                if (sleepTime <= 0L) continue;
                Thread.sleep(sleepTime);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }
}

