/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIOutput;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.apache.myfaces.config.MyfacesConfig;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.HTML;
import org.apache.myfaces.renderkit.html.HtmlFormRendererBase;
import org.apache.myfaces.renderkit.html.HtmlRenderer;
import org.apache.myfaces.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.DummyFormResponseWriter;
import org.apache.myfaces.renderkit.html.util.DummyFormUtils;
import org.apache.myfaces.renderkit.html.util.JavascriptUtils;

public abstract class HtmlLinkRendererBase
extends HtmlRenderer {
    public static final String URL_STATE_MARKER = "JSF_URL_STATE_MARKER=DUMMY";
    public static final int URL_STATE_MARKER_LEN = "JSF_URL_STATE_MARKER=DUMMY".length();

    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        super.decode(facesContext, component);
        if (component instanceof UICommand) {
            String clientId = component.getClientId(facesContext);
            String reqValue = (String)facesContext.getExternalContext().getRequestParameterMap().get(HtmlRendererUtils.getHiddenCommandLinkFieldName(HtmlRendererUtils.getFormName(component, facesContext)));
            if (reqValue != null && reqValue.equals(clientId)) {
                component.queueEvent((FacesEvent)new ActionEvent(component));
            }
        } else if (!(component instanceof UIOutput)) {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        super.encodeBegin(facesContext, component);
        if (component instanceof UICommand) {
            this.renderCommandLinkStart(facesContext, component, component.getClientId(facesContext), ((UICommand)component).getValue(), this.getStyle(facesContext, component), this.getStyleClass(facesContext, component));
        } else if (component instanceof UIOutput) {
            this.renderOutputLinkStart(facesContext, (UIOutput)component);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    protected String getStyle(FacesContext facesContext, UIComponent link) {
        if (link instanceof HtmlCommandLink) {
            return ((HtmlCommandLink)link).getStyle();
        }
        return (String)link.getAttributes().get("style");
    }

    protected String getStyleClass(FacesContext facesContext, UIComponent link) {
        if (link instanceof HtmlCommandLink) {
            return ((HtmlCommandLink)link).getStyleClass();
        }
        return (String)link.getAttributes().get("styleClass");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.renderChildren(facesContext, component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        super.encodeEnd(facesContext, component);
        this.renderLinkEnd(facesContext, component);
    }

    protected void renderCommandLinkStart(FacesContext facesContext, UIComponent component, String clientId, Object value, String style, String styleClass) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        if (JavascriptUtils.isJavascriptAllowed(facesContext.getExternalContext())) {
            this.renderJavaScriptAnchorStart(facesContext, writer, component, clientId);
        } else {
            this.renderNonJavaScriptAnchorStart(facesContext, writer, component, clientId);
        }
        writer.writeAttribute("id", (Object)clientId, null);
        HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES_WITHOUT_STYLE);
        HtmlRendererUtils.renderHTMLAttribute(writer, "style", "style", (Object)style);
        HtmlRendererUtils.renderHTMLAttribute(writer, "styleClass", "styleClass", (Object)styleClass);
        if (value != null) {
            writer.writeText((Object)value.toString(), "value");
        }
    }

    protected void renderJavaScriptAnchorStart(FacesContext facesContext, ResponseWriter writer, UIComponent component, String clientId) throws IOException {
        DummyFormResponseWriter dummyFormResponseWriter;
        String formName;
        UIComponent parent;
        for (parent = component.getParent(); parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        UIForm nestingForm = null;
        if (parent != null) {
            nestingForm = (UIForm)parent;
            formName = nestingForm.getClientId(facesContext);
            dummyFormResponseWriter = null;
        } else {
            formName = "linkDummyForm";
            dummyFormResponseWriter = DummyFormUtils.getDummyFormResponseWriter(facesContext);
            dummyFormResponseWriter.setWriteDummyForm(true);
        }
        StringBuffer onClick = new StringBuffer();
        String commandOnclick = component instanceof HtmlCommandLink ? ((HtmlCommandLink)component).getOnclick() : (String)component.getAttributes().get("onclick");
        if (commandOnclick != null) {
            onClick.append(commandOnclick);
            onClick.append(';');
        }
        onClick.append(HtmlRendererUtils.getClearHiddenCommandFormParamsFunctionName(formName)).append("();");
        String jsForm = "document.forms['" + formName + "']";
        if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isAutoScroll()) {
            JavascriptUtils.appendAutoScrollAssignment(onClick, formName);
        }
        String hiddenFieldName = HtmlRendererUtils.getHiddenCommandLinkFieldName(formName);
        onClick.append(jsForm);
        onClick.append(".elements['").append(hiddenFieldName).append("']");
        onClick.append(".value='").append(clientId).append("';");
        if (nestingForm != null) {
            HtmlFormRendererBase.addHiddenCommandParameter((UIComponent)nestingForm, hiddenFieldName);
        } else {
            dummyFormResponseWriter.addDummyFormParameter(hiddenFieldName);
        }
        Iterator it = component.getChildren().iterator();
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            if (!(child instanceof UIParameter)) continue;
            String name = ((UIParameter)child).getName();
            Object value = ((UIParameter)child).getValue();
            this.renderLinkParameter(dummyFormResponseWriter, name, value, onClick, jsForm, nestingForm);
        }
        String target = ((HtmlCommandLink)component).getTarget();
        if (target != null && target.trim().length() > 0) {
            onClick.append(jsForm);
            onClick.append(".target='");
            onClick.append(target);
            onClick.append("';");
        }
        onClick.append("if(" + jsForm + ".onsubmit){" + jsForm + ".onsubmit();}");
        onClick.append(jsForm);
        onClick.append(".submit();return false;");
        writer.startElement("a", component);
        writer.writeURIAttribute("href", (Object)"#", null);
        writer.writeAttribute("onclick", (Object)onClick.toString(), null);
    }

    protected void renderNonJavaScriptAnchorStart(FacesContext facesContext, ResponseWriter writer, UIComponent component, String clientId) throws IOException {
        StateManager stateManager;
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        String viewId = facesContext.getViewRoot().getViewId();
        String path = viewHandler.getActionURL(facesContext, viewId);
        StringBuffer hrefBuf = new StringBuffer(path);
        if (path.indexOf(63) == -1) {
            hrefBuf.append('?');
        } else {
            hrefBuf.append('&');
        }
        String hiddenFieldName = HtmlRendererUtils.getHiddenCommandLinkFieldName(HtmlRendererUtils.getFormName(component, facesContext));
        hrefBuf.append(hiddenFieldName);
        hrefBuf.append('=');
        hrefBuf.append(clientId);
        if (component.getChildCount() > 0) {
            this.addChildParametersToHref(component, hrefBuf, false, writer.getCharacterEncoding());
        }
        if ((stateManager = facesContext.getApplication().getStateManager()).isSavingStateInClient(facesContext)) {
            hrefBuf.append("&");
            hrefBuf.append(URL_STATE_MARKER);
        }
        String href = facesContext.getExternalContext().encodeActionURL(hrefBuf.toString());
        writer.startElement("a", component);
        writer.writeURIAttribute("href", (Object)facesContext.getExternalContext().encodeActionURL(href), null);
    }

    private void addChildParametersToHref(UIComponent linkComponent, StringBuffer hrefBuf, boolean firstParameter, String charEncoding) throws IOException {
        Iterator it = linkComponent.getChildren().iterator();
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            if (!(child instanceof UIParameter)) continue;
            String name = ((UIParameter)child).getName();
            Object value = ((UIParameter)child).getValue();
            HtmlLinkRendererBase.addParameterToHref(name, value, hrefBuf, firstParameter, charEncoding);
            firstParameter = false;
        }
    }

    protected void renderOutputLinkStart(FacesContext facesContext, UIOutput output) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String href = RendererUtils.getStringValue(facesContext, (UIComponent)output);
        if (output.getChildCount() > 0) {
            StringBuffer hrefBuf = new StringBuffer(href);
            this.addChildParametersToHref((UIComponent)output, hrefBuf, href.indexOf(63) == -1, writer.getCharacterEncoding());
            href = hrefBuf.toString();
        }
        href = facesContext.getExternalContext().encodeResourceURL(href);
        writer.startElement("a", (UIComponent)output);
        writer.writeAttribute("id", (Object)output.getClientId(facesContext), null);
        writer.writeURIAttribute("href", (Object)href, null);
        HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)output, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES);
        writer.flush();
    }

    private void renderLinkParameter(DummyFormResponseWriter dummyFormResponseWriter, String name, Object value, StringBuffer onClick, String jsForm, UIForm nestingForm) {
        if (name == null) {
            throw new IllegalArgumentException("Unnamed parameter value not allowed within command link.");
        }
        onClick.append(jsForm);
        onClick.append(".elements['").append(name).append("']");
        String strParamValue = value != null ? value.toString() : "";
        onClick.append(".value='").append(strParamValue).append("';");
        if (nestingForm != null) {
            HtmlFormRendererBase.addHiddenCommandParameter((UIComponent)nestingForm, name);
        } else {
            dummyFormResponseWriter.addDummyFormParameter(name);
        }
    }

    private static void addParameterToHref(String name, Object value, StringBuffer hrefBuf, boolean firstParameter, String charEncoding) throws UnsupportedEncodingException {
        if (name == null) {
            throw new IllegalArgumentException("Unnamed parameter value not allowed within command link.");
        }
        hrefBuf.append(firstParameter ? (char)'?' : '&');
        hrefBuf.append(URLEncoder.encode(name, charEncoding));
        hrefBuf.append('=');
        if (value != null) {
            hrefBuf.append(URLEncoder.encode(value.toString(), charEncoding));
        }
    }

    protected void renderLinkEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.writeText((Object)"", null);
        writer.endElement("a");
    }
}

